/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.microblocks.api.recipe;

import java.util.List;
import java.util.function.Predicate;
import org.zeith.multipart.microblocks.api.MicroblockType;
import org.zeith.multipart.microblocks.api.recipe.MicroblockedStack;

public final class MicroblockIngredient {
    public static final MicroblockIngredient EMPTY = MicroblockIngredient.of(new MicroblockType[0]);
    public static final MicroblockIngredient FULL_BLOCK = new MicroblockIngredient(f -> false, true);
    private final boolean isFullBlock;
    private final Predicate<MicroblockType> typeFilter;

    private MicroblockIngredient(Predicate<MicroblockType> typeFilter, boolean isFullBlock) {
        this.typeFilter = typeFilter;
        this.isFullBlock = isFullBlock;
    }

    public static MicroblockIngredient fullBlock() {
        return FULL_BLOCK;
    }

    public static MicroblockIngredient of(MicroblockType ... types) {
        if (types.length == 0 && EMPTY != null) {
            return EMPTY;
        }
        List<MicroblockType> tlst = List.of(types);
        return new MicroblockIngredient(tlst::contains, false);
    }

    public boolean matchesType(MicroblockType type) {
        return this.typeFilter.test(type);
    }

    public boolean isFullBlock() {
        return this.isFullBlock;
    }

    public boolean test(MicroblockedStack stack) {
        if (stack == null) {
            return this == EMPTY;
        }
        return this.isFullBlock && stack.fullBlock() || !this.isFullBlock && !stack.fullBlock() && stack.type().map(this::matchesType).orElse(false) != false;
    }
}

