/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.microblocks.api.grids;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.zeith.multipart.api.PartContainer;
import org.zeith.multipart.api.PartEntity;
import org.zeith.multipart.api.placement.PartPlacement;
import org.zeith.multipart.api.placement.PartPos;
import org.zeith.multipart.microblocks.api.MicroblockType;
import org.zeith.multipart.microblocks.api.grids.MicroblockPlacementGrid;
import org.zeith.multipart.microblocks.contents.microblocks.CubicMicroblockType;
import org.zeith.multipart.microblocks.contents.multipart.entity.MicroblockEntity;
import org.zeith.multipart.microblocks.contents.multipart.placements.CubeConfiguration;
import org.zeith.multipart.microblocks.contents.multipart.placements.CubicPartPlacement;

public class CubicPlacementGrid
extends MicroblockPlacementGrid {
    public static final CubicPlacementGrid INSTANCE = new CubicPlacementGrid();

    @Override
    @Nullable
    public BlockState getAppearance(MicroblockEntity thisEntity, PartPlacement thisPlacement, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos, @Nullable PartContainer queryContainer, @Nullable PartPos queryPartPos) {
        MicroblockEntity mbe;
        PartEntity partEntity;
        CubicPartPlacement rev;
        Direction.Axis a2;
        Direction.Axis a1;
        CubicPartPlacement cp2;
        PartPlacement partPlacement;
        Direction.AxisDirection part;
        CubicPartPlacement cpp;
        BlockPos thisPos;
        block17: {
            block16: {
                if (queryPos == null) {
                    return null;
                }
                thisPos = thisEntity.pos().pos();
                if (!(thisPlacement instanceof CubicPartPlacement)) {
                    return null;
                }
                cpp = (CubicPartPlacement)thisPlacement;
                MicroblockType microblockType = thisEntity.state.getType();
                if (!(microblockType instanceof CubicMicroblockType)) break block16;
                CubicMicroblockType cmt = (CubicMicroblockType)microblockType;
                if (cmt.thickness == 0.5) break block17;
            }
            return null;
        }
        BlockPos rel = queryPos.m_121996_((Vec3i)thisPos);
        BlockState theState = thisEntity.state.asBlockState();
        CubeConfiguration cfg = cpp.getCfg();
        Direction.Axis a = side.m_122434_();
        Direction.AxisDirection ad = side.m_122421_();
        if (!(ad == (part = cfg.of(a).m_122541_()) || queryPartPos != null && (partPlacement = queryPartPos.placement()) instanceof CubicPartPlacement && (cp2 = (CubicPartPlacement)partPlacement).getCfg().of(a) == cfg.of(a))) {
            return null;
        }
        if (a == Direction.Axis.Y) {
            a1 = Direction.Axis.X;
            a2 = Direction.Axis.Z;
        } else if (a == Direction.Axis.X) {
            a1 = Direction.Axis.Y;
            a2 = Direction.Axis.Z;
        } else {
            a1 = Direction.Axis.X;
            a2 = Direction.Axis.Y;
        }
        int x = rel.m_123304_(a1);
        int z = rel.m_123304_(a2);
        int x1 = -cfg.of(a1).m_122540_();
        int z1 = -cfg.of(a2).m_122540_();
        if (x == x1) {
            rev = CubicPartPlacement.LOOKUP.get(cfg.opposite(a2).ordinal());
            partEntity = thisEntity.container().getPartAt((PartPlacement)rev);
            if (partEntity instanceof MicroblockEntity) {
                mbe = (MicroblockEntity)partEntity;
                if (mbe.state.asBlockState() == theState) {
                    return theState;
                }
            }
        }
        if (z == z1) {
            rev = CubicPartPlacement.LOOKUP.get(cfg.opposite(a1).ordinal());
            partEntity = thisEntity.container().getPartAt((PartPlacement)rev);
            if (partEntity instanceof MicroblockEntity) {
                mbe = (MicroblockEntity)partEntity;
                if (mbe.state.asBlockState() == theState) {
                    return theState;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PartPlacement pickPlacement(Player player, BlockHitResult hit, boolean sameBlock) {
        Vec3 loc = hit.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)hit.m_82425_()));
        int x = 0;
        int y = 0;
        int z = 0;
        Direction hitSide = hit.m_82434_();
        Direction.Axis a = hitSide.m_122434_();
        if (hitSide.m_122421_() != (sameBlock ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE)) {
            if (a == Direction.Axis.X) {
                ++x;
            }
            if (a == Direction.Axis.Y) {
                ++y;
            }
            if (a == Direction.Axis.Z) {
                ++z;
            }
        }
        if (a == Direction.Axis.X) {
            if (loc.f_82480_ > 0.5) {
                ++y;
            }
            if (loc.f_82481_ > 0.5) {
                ++z;
            }
        }
        if (a == Direction.Axis.Y) {
            if (loc.f_82479_ > 0.5) {
                ++x;
            }
            if (loc.f_82481_ > 0.5) {
                ++z;
            }
        }
        if (a == Direction.Axis.Z) {
            if (loc.f_82479_ > 0.5) {
                ++x;
            }
            if (loc.f_82480_ > 0.5) {
                ++y;
            }
        }
        int ordinal = z + y * 2 + x * 4;
        return CubicPartPlacement.LOOKUP.get(7 - ordinal);
    }

    @Override
    @NotNull
    public List<Vector3f> getLinesForRendering(Player player, VoxelShape blockBounds, BlockHitResult hit) {
        if (blockBounds.m_83281_()) {
            return List.of();
        }
        AABB boundary = blockBounds.m_83215_();
        if (hit.m_82434_().m_122434_() == Direction.Axis.X) {
            float my = (float)(hit.m_82434_() == Direction.EAST ? boundary.f_82291_ : boundary.f_82288_);
            return List.of(new Vector3f(my, 0.0f, 0.0f), new Vector3f(my, 1.0f, 0.0f), new Vector3f(my, 1.0f, 1.0f), new Vector3f(my, 0.0f, 1.0f), new Vector3f(my, 0.0f, 0.0f), new Vector3f(my, 0.0f, 1.0f), new Vector3f(my, 1.0f, 0.0f), new Vector3f(my, 1.0f, 1.0f), new Vector3f(my, 0.0f, 0.5f), new Vector3f(my, 1.0f, 0.5f), new Vector3f(my, 0.5f, 0.0f), new Vector3f(my, 0.5f, 1.0f));
        }
        if (hit.m_82434_().m_122434_() == Direction.Axis.Y) {
            float my = (float)(hit.m_82434_() == Direction.UP ? boundary.f_82292_ : boundary.f_82289_);
            return List.of(new Vector3f(0.0f, my, 0.0f), new Vector3f(1.0f, my, 0.0f), new Vector3f(1.0f, my, 1.0f), new Vector3f(0.0f, my, 1.0f), new Vector3f(0.0f, my, 0.0f), new Vector3f(0.0f, my, 1.0f), new Vector3f(1.0f, my, 0.0f), new Vector3f(1.0f, my, 1.0f), new Vector3f(0.5f, my, 0.0f), new Vector3f(0.5f, my, 1.0f), new Vector3f(0.0f, my, 0.5f), new Vector3f(1.0f, my, 0.5f));
        }
        if (hit.m_82434_().m_122434_() == Direction.Axis.Z) {
            float my = (float)(hit.m_82434_() == Direction.SOUTH ? boundary.f_82293_ : boundary.f_82290_);
            return List.of(new Vector3f(0.0f, 0.0f, my), new Vector3f(1.0f, 0.0f, my), new Vector3f(1.0f, 1.0f, my), new Vector3f(0.0f, 1.0f, my), new Vector3f(0.0f, 0.0f, my), new Vector3f(0.0f, 1.0f, my), new Vector3f(1.0f, 0.0f, my), new Vector3f(1.0f, 1.0f, my), new Vector3f(0.5f, 0.0f, my), new Vector3f(0.5f, 1.0f, my), new Vector3f(0.0f, 0.5f, my), new Vector3f(1.0f, 0.5f, my));
        }
        return List.of();
    }
}

