/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.util.citizenutils;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.Network;
import com.minecolonies.core.network.messages.client.BlockParticleEffectMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenItemUtils {
    public static void tryPickupItemEntity(@NotNull AbstractEntityCitizen citizen, @NotNull ItemEntity itemEntity) {
        if (!CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)citizen).f_46443_) {
            if (itemEntity.m_32063_()) {
                return;
            }
            ItemStack itemStack = itemEntity.m_32055_();
            ItemStack compareStack = itemStack.m_41777_();
            if (citizen.getCitizenJobHandler().getColonyJob() == null || citizen.getCitizenJobHandler().getColonyJob().pickupSuccess(compareStack)) {
                int resultingStackSize;
                ItemStack resultStack = InventoryUtils.addItemStackToItemHandlerWithResult((IItemHandler)citizen.getInventoryCitizen(), itemStack);
                int n = resultingStackSize = ItemStackUtils.isEmpty(resultStack) ? 0 : ItemStackUtils.getSize(resultStack);
                if (ItemStackUtils.isEmpty(resultStack) || ItemStackUtils.getSize(resultStack) != ItemStackUtils.getSize(compareStack)) {
                    CompatibilityUtils.getWorldFromCitizen(citizen).m_5594_(null, citizen.m_20183_(), SoundEvents.f_12019_, SoundSource.AMBIENT, 0.2f, (float)((citizen.m_217043_().m_188583_() * 0.7 + 1.0) * 2.0));
                    citizen.m_7938_((Entity)itemEntity, ItemStackUtils.getSize(itemStack) - resultingStackSize);
                    ItemStack overrulingStack = itemStack.m_41777_();
                    overrulingStack.m_41764_(ItemStackUtils.getSize(itemStack) - resultingStackSize);
                    if (citizen.getCitizenJobHandler().getColonyJob() != null) {
                        citizen.getCitizenJobHandler().getColonyJob().onStackPickUp(overrulingStack);
                    }
                    if (ItemStackUtils.isEmpty(resultStack)) {
                        itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                    }
                }
            } else {
                itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public static void removeHeldItem(AbstractEntityCitizen citizen) {
        citizen.m_8061_(EquipmentSlot.MAINHAND, ItemStackUtils.EMPTY);
    }

    public static void setHeldItem(@NotNull AbstractEntityCitizen citizen, InteractionHand hand, int slot) {
        citizen.getCitizenData().getInventory().setHeldItem(hand, slot);
        if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
            citizen.m_8061_(EquipmentSlot.MAINHAND, citizen.getCitizenData().getInventory().getStackInSlot(slot));
        } else if (hand.equals((Object)InteractionHand.OFF_HAND)) {
            citizen.m_8061_(EquipmentSlot.OFFHAND, citizen.getCitizenData().getInventory().getStackInSlot(slot));
        }
    }

    public static void setMainHeldItem(@NotNull AbstractEntityCitizen citizen, int slot) {
        citizen.getCitizenData().getInventory().setHeldItem(InteractionHand.MAIN_HAND, slot);
        citizen.m_8061_(EquipmentSlot.MAINHAND, citizen.getCitizenData().getInventory().getStackInSlot(slot));
    }

    public static void hitBlockWithToolInHand(@NotNull AbstractEntityCitizen citizen, @Nullable BlockPos blockPos) {
        if (blockPos == null) {
            return;
        }
        CitizenItemUtils.hitBlockWithToolInHand(citizen, blockPos, false);
    }

    public static void hitBlockWithToolInHand(@NotNull AbstractEntityCitizen citizen, @Nullable BlockPos blockPos, boolean breakBlock) {
        if (blockPos == null) {
            return;
        }
        citizen.m_21563_().m_24950_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 10.0f, (float)citizen.m_8132_());
        citizen.m_6674_(citizen.m_7655_());
        BlockState blockState = CompatibilityUtils.getWorldFromCitizen(citizen).m_8055_(blockPos);
        Block block = blockState.m_60734_();
        if (breakBlock) {
            if (!CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)citizen).f_46443_) {
                Network.getNetwork().sendToPosition(new BlockParticleEffectMessage(blockPos, CompatibilityUtils.getWorldFromCitizen(citizen).m_8055_(blockPos), -1), new PacketDistributor.TargetPoint((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 16.0, citizen.f_19853_.m_46472_()));
            }
            CompatibilityUtils.getWorldFromCitizen(citizen).m_5594_(null, blockPos, block.getSoundType(blockState, (LevelReader)CompatibilityUtils.getWorldFromCitizen(citizen), blockPos, (Entity)citizen).m_56775_(), SoundSource.BLOCKS, (block.getSoundType(blockState, (LevelReader)CompatibilityUtils.getWorldFromCitizen(citizen), blockPos, (Entity)citizen).m_56773_() + 1.0f) * 0.5f, block.getSoundType(blockState, (LevelReader)CompatibilityUtils.getWorldFromCitizen(citizen), blockPos, (Entity)citizen).m_56774_() * 0.8f);
            WorldUtil.removeBlock((LevelAccessor)CompatibilityUtils.getWorldFromCitizen(citizen), blockPos, false);
            CitizenItemUtils.damageItemInHand(citizen, citizen.m_7655_(), 1);
        } else {
            if (!CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)citizen).f_46443_) {
                BlockPos vector = blockPos.m_121996_((Vec3i)citizen.m_20183_());
                Direction facing = BlockPosUtil.directionFromDelta(vector.m_123341_(), vector.m_123342_(), vector.m_123343_()).m_122424_();
                Network.getNetwork().sendToPosition(new BlockParticleEffectMessage(blockPos, CompatibilityUtils.getWorldFromCitizen(citizen).m_8055_(blockPos), facing.ordinal()), new PacketDistributor.TargetPoint((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 16.0, citizen.f_19853_.m_46472_()));
            }
            CompatibilityUtils.getWorldFromCitizen(citizen).m_5594_(null, blockPos, block.getSoundType(blockState, (LevelReader)CompatibilityUtils.getWorldFromCitizen(citizen), blockPos, (Entity)citizen).m_56778_(), SoundSource.BLOCKS, (block.getSoundType(blockState, (LevelReader)CompatibilityUtils.getWorldFromCitizen(citizen), blockPos, (Entity)citizen).m_56773_() + 1.0f) * 0.125f, block.getSoundType(blockState, (LevelReader)CompatibilityUtils.getWorldFromCitizen(citizen), blockPos, (Entity)citizen).m_56774_() * 0.5f);
        }
    }

    public static void damageItemInHand(@NotNull AbstractEntityCitizen citizen, InteractionHand hand, int damage) {
        ItemStack heldItem = citizen.getCitizenData().getInventory().getHeldItem(hand);
        if (heldItem == null || heldItem.m_41619_()) {
            return;
        }
        if (citizen.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.TOOL_DURABILITY) > 0.0 && citizen.m_217043_().m_188500_() > 1.0 / (1.0 + citizen.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.TOOL_DURABILITY))) {
            return;
        }
        if (citizen.getCitizenData().getInventory().damageInventoryItem(citizen.getCitizenData().getInventory().getHeldItemSlot(hand), damage, citizen, item -> item.m_21190_(hand))) {
            if (hand == InteractionHand.MAIN_HAND) {
                citizen.m_8061_(EquipmentSlot.MAINHAND, ItemStackUtils.EMPTY);
            } else {
                citizen.m_8061_(EquipmentSlot.OFFHAND, ItemStackUtils.EMPTY);
            }
        }
    }

    public static void pickupItems(AbstractEntityCitizen citizen) {
        for (ItemEntity item : CompatibilityUtils.getWorldFromCitizen(citizen).m_45976_(ItemEntity.class, new AABB(citizen.m_20183_()).m_82363_(2.0, 1.0, 2.0).m_82363_(-2.0, -1.0, -2.0))) {
            if (item == null || !item.m_6084_()) continue;
            CitizenItemUtils.tryPickupItemEntity(citizen, item);
        }
    }

    public static void breakBlockWithToolInHand(@NotNull AbstractEntityCitizen citizen, @Nullable BlockPos blockPos) {
        if (blockPos == null) {
            return;
        }
        CitizenItemUtils.hitBlockWithToolInHand(citizen, blockPos, true);
    }

    public static ItemEntity entityDropItem(@NotNull AbstractEntityCitizen citizen, @NotNull ItemStack itemstack) {
        return citizen.m_5552_(itemstack, 0.0f);
    }

    public static void updateArmorDamage(@NotNull AbstractEntityCitizen citizen, double damage) {
        if (citizen.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARMOR_DURABILITY) > 0.0 && citizen.m_217043_().m_188500_() > 1.0 / (1.0 + citizen.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARMOR_DURABILITY))) {
            return;
        }
        int armorDmg = Math.max(1, (int)(damage / 4.0));
        for (int i = 0; i < 4; ++i) {
            EquipmentSlot equipmentSlot = EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)i);
            ItemStack equipment = citizen.getInventoryCitizen().getArmorInSlot(equipmentSlot);
            equipment.m_41622_(armorDmg, (LivingEntity)citizen, s -> {
                s.m_21166_(equipmentSlot);
                citizen.onArmorRemove(equipment, equipmentSlot);
                citizen.getInventoryCitizen().markDirty();
            });
        }
    }

    public static double applyMending(@NotNull AbstractEntityCitizen citizen, double xp) {
        double localXp = xp;
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            if (localXp <= 0.0) break;
            ItemStack tool = equipmentSlot.m_254934_() ? citizen.getInventoryCitizen().getArmorInSlot(equipmentSlot) : citizen.getInventoryCitizen().getHeldItem(equipmentSlot == EquipmentSlot.MAINHAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
            if (ItemStackUtils.isEmpty(tool) || !tool.m_41768_() || !tool.m_41793_() || !EnchantmentHelper.m_44831_((ItemStack)tool).containsKey(Enchantments.f_44962_)) continue;
            double dmgHealed = Math.min(localXp / 2.0, (double)tool.m_41773_());
            localXp -= dmgHealed * 2.0;
            tool.m_41721_(tool.m_41773_() - (int)Math.ceil(dmgHealed));
        }
        return localXp;
    }
}

