/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.research;

import com.minecolonies.api.research.IResearchEffect;
import com.minecolonies.api.research.IResearchEffectManager;
import com.minecolonies.core.research.GlobalResearchEffect;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class ResearchEffectManager
implements IResearchEffectManager {
    private final Map<ResourceLocation, IResearchEffect> effectMap = new HashMap<ResourceLocation, IResearchEffect>();

    @Override
    public double getEffectStrength(ResourceLocation id) {
        IResearchEffect effect = this.effectMap.get(id);
        if (effect instanceof GlobalResearchEffect) {
            GlobalResearchEffect globalResearchEffect = (GlobalResearchEffect)effect;
            return globalResearchEffect.getEffect();
        }
        return 0.0;
    }

    @Override
    public void applyEffect(IResearchEffect effect) {
        IResearchEffect effectInMap = this.effectMap.get(effect.getId());
        if (effectInMap != null) {
            if (effect.overrides(effectInMap)) {
                this.effectMap.put(effect.getId(), effect);
            }
        } else {
            this.effectMap.put(effect.getId(), effect);
        }
    }

    @Override
    public void removeAllEffects() {
        this.effectMap.clear();
    }
}

