/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.items.ItemBannerRallyGuards;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveFromRallyingListMessage
implements IMessage {
    private ItemStack banner;
    private ILocation location;

    public RemoveFromRallyingListMessage() {
    }

    public RemoveFromRallyingListMessage(ItemStack banner, ILocation location) {
        this.banner = banner;
        this.location = location;
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.banner = buf.m_130267_();
        this.location = (ILocation)StandardFactoryController.getInstance().deserialize(buf.m_130260_());
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.m_130055_(this.banner);
        buf.m_130079_(StandardFactoryController.getInstance().serialize(this.location));
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerPlayer player = ctxIn.getSender();
        int slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((Container)player.m_150109_()), itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, this.banner));
        if (slot == -1) {
            MessageUtils.format("com.minecolonies.coremod.item.bannerrallyguards.gui.error", new Object[0]).sendTo(new Player[]{player});
            return;
        }
        ItemBannerRallyGuards.removeGuardTowerAtLocation(player.m_150109_().m_8020_(slot), this.location);
    }
}

