/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.pathjobs;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.PathingOptions;
import com.minecolonies.core.entity.pathfinding.SurfaceType;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathjobs.IDestinationPathJob;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class PathJobRandomPos
extends AbstractPathJob
implements IDestinationPathJob {
    @NotNull
    protected final BlockPos destination;
    protected final int minDistFromStart;
    private final int maxDistToDest;
    private boolean preferInside = false;
    private AABB restrictionBox = null;
    private BlockPos restrictionBoxCenter = null;
    private final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();

    public PathJobRandomPos(Level world, @NotNull BlockPos start, int minDistFromStart, int range, Mob entity) {
        super(world, start, range, new PathResult(), entity);
        this.minDistFromStart = minDistFromStart;
        this.maxDistToDest = -1;
        this.destination = BlockPosUtil.getRandomPosAround(start, minDistFromStart);
    }

    public PathJobRandomPos(Level world, @NotNull BlockPos start, int minDistFromStart, int searchRange, int maxDistToDest, Mob entity, @NotNull BlockPos dest) {
        super(world, start, searchRange, new PathResult(), entity);
        this.minDistFromStart = minDistFromStart;
        this.maxDistToDest = maxDistToDest;
        this.destination = dest;
    }

    public PathJobRandomPos(Level world, @NotNull BlockPos start, int minDistFromStart, int range, Mob entity, BlockPos startRestriction, BlockPos endRestriction) {
        super(world, start, range, new PathResult(), entity);
        this.restrictionBox = new AABB((double)Math.min(startRestriction.m_123341_(), endRestriction.m_123341_()), (double)Math.min(startRestriction.m_123342_(), endRestriction.m_123342_()), (double)Math.min(startRestriction.m_123343_(), endRestriction.m_123343_()), (double)Math.max(startRestriction.m_123341_(), endRestriction.m_123341_()), (double)Math.max(startRestriction.m_123342_(), endRestriction.m_123342_()), (double)Math.max(startRestriction.m_123343_(), endRestriction.m_123343_()));
        this.restrictionBoxCenter = BlockPos.m_274446_((Position)this.restrictionBox.m_82399_());
        this.minDistFromStart = minDistFromStart;
        this.maxDistToDest = -1;
        this.destination = BlockPosUtil.getRandomPosAround(start, minDistFromStart);
    }

    public PathJobRandomPos(Level world, @NotNull BlockPos start, int minDistFromStart, int range, Mob entity, BlockPos startRestriction, BlockPos endRestriction, boolean preferInside) {
        super(world, start, range, new PathResult(), entity);
        this.restrictionBox = new AABB((double)Math.min(startRestriction.m_123341_(), endRestriction.m_123341_()), (double)Math.min(startRestriction.m_123342_(), endRestriction.m_123342_()), (double)Math.min(startRestriction.m_123343_(), endRestriction.m_123343_()), (double)Math.max(startRestriction.m_123341_(), endRestriction.m_123341_()), (double)Math.max(startRestriction.m_123342_(), endRestriction.m_123342_()), (double)Math.max(startRestriction.m_123343_(), endRestriction.m_123343_()));
        this.restrictionBoxCenter = BlockPos.m_274446_((Position)this.restrictionBox.m_82399_());
        this.minDistFromStart = minDistFromStart;
        this.maxDistToDest = -1;
        this.preferInside = preferInside;
        this.destination = BlockPosUtil.getRandomPosAround(start, minDistFromStart);
        this.maxNodes = this.restrictionBox == null ? 2000 : 1000;
    }

    private boolean hasSpaceAbove(int x, int y, int z) {
        for (int i = 1; i < 5; ++i) {
            if (!this.cachedBlockLookup.getBlockState(x, y + i + 1, z).m_280296_()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected double computeHeuristic(int x, int y, int z) {
        if (this.restrictionBox != null) {
            return (double)BlockPosUtil.distManhattan(this.destination, x, y, z) + (double)BlockPosUtil.distManhattan(this.restrictionBoxCenter, x, y, z) / 2.0;
        }
        return BlockPosUtil.distManhattan(this.destination, x, y, z);
    }

    @Override
    protected boolean isAtDestination(@NotNull MNode n) {
        if (!(this.restrictionBox != null && !this.restrictionBox.m_82393_((double)n.x, (double)n.y, (double)n.z) || BlockPosUtil.distSqr(this.start, n.x, n.y, n.z) <= this.minDistFromStart * this.minDistFromStart || this.maxDistToDest != -1 && BlockPosUtil.distSqr(this.destination, n.x, n.y, n.z) >= this.maxDistToDest * this.maxDistToDest || !this.getPathingOptions().canWalkUnderWater() && PathfindingUtils.isWater(this.cachedBlockLookup, (BlockPos)this.tempWorldPos.m_122178_(n.x, n.y - 1, n.z)) || SurfaceType.getSurfaceType(this.cachedBlockLookup, this.cachedBlockLookup.getBlockState(n.x, n.y - 1, n.z), (BlockPos)this.tempWorldPos.m_122178_(n.x, n.y - 1, n.z), this.getPathingOptions()) != SurfaceType.WALKABLE)) {
            return !this.preferInside || !this.hasSpaceAbove(n.x, n.y, n.z);
        }
        return false;
    }

    @Override
    protected double getEndNodeScore(@NotNull MNode n) {
        return BlockPosUtil.distManhattan(this.start, n.x, n.y, n.z);
    }

    @Override
    public void setPathingOptions(PathingOptions pathingOptions) {
        super.setPathingOptions(pathingOptions);
        this.getPathingOptions().canDrop = false;
    }

    @Override
    public BlockPos getDestination() {
        return this.destination;
    }

    public static boolean isJobFor(AbstractPathJob job, BlockPos center, int range) {
        if (job instanceof PathJobRandomPos) {
            PathJobRandomPos pathJob = (PathJobRandomPos)job;
            return pathJob.destination != null && pathJob.destination.equals((Object)center) && pathJob.maxDistToDest == range;
        }
        return false;
    }
}

