/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.datalistener;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.colony.crafting.CustomRecipe;
import com.minecolonies.core.colony.crafting.CustomRecipeManager;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class CrafterRecipeListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public CrafterRecipeListener() {
        super(GSON, "crafterrecipes");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> object, @NotNull ResourceManager resourceManagerIn, @NotNull ProfilerFiller profilerIn) {
        Log.getLogger().info("Beginning load of custom recipes for colony workers");
        CustomRecipeManager recipeManager = CustomRecipeManager.getInstance();
        recipeManager.reset();
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            ResourceLocation key = entry.getKey();
            try {
                JsonObject recipeJson = entry.getValue().getAsJsonObject();
                switch (GsonHelper.m_13851_((JsonObject)recipeJson, (String)"type", (String)"")) {
                    case "recipe": 
                    case "recipe-multi-out": {
                        recipeManager.addRecipe(CustomRecipe.parse(key, recipeJson));
                        break;
                    }
                    case "recipe-template": {
                        recipeManager.addRecipeTemplate(key, recipeJson);
                        break;
                    }
                    case "remove": {
                        ResourceLocation toRemove = new ResourceLocation(GsonHelper.m_13851_((JsonObject)recipeJson, (String)"recipe-id-to-remove", (String)""));
                        recipeManager.removeRecipe(toRemove);
                    }
                }
            }
            catch (JsonParseException e) {
                Log.getLogger().error("Error parsing crafterrecipe " + key.toString(), (Throwable)e);
            }
        }
        int totalRecipes = recipeManager.getAllRecipes().values().stream().mapToInt(Map::size).sum();
        Log.getLogger().info("Loaded " + totalRecipes + " recipes for " + recipeManager.getAllRecipes().size() + " crafters");
    }
}

