/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.colonycommands;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.registry.ColonyEventTypeRegistryEntry;
import com.minecolonies.api.colony.managers.interfaces.IRaiderManager;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.colony.events.raid.norsemenevent.NorsemenShipRaidEvent;
import com.minecolonies.core.colony.events.raid.pirateEvent.PirateGroundRaidEvent;
import com.minecolonies.core.commands.arguments.ColonyIdArgument;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.commands.commandTypes.IMCOPCommand;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public class CommandRaid
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        return this.raidExecute(context, "");
    }

    public int onSpecificExecute(CommandContext<CommandSourceStack> context) {
        try {
            if (!this.checkPreCondition(context)) {
                return 0;
            }
            return this.raidExecute(context, StringArgumentType.getString(context, (String)"raidtype"));
        }
        catch (Throwable e) {
            Log.getLogger().warn("Error during running command:", e);
            return 0;
        }
    }

    public int raidExecute(CommandContext<CommandSourceStack> context, String raidType) {
        IColony colony = ColonyIdArgument.getColony(context, "colonyID");
        boolean allowShips = BoolArgumentType.getBool(context, (String)"allowships");
        if (StringArgumentType.getString(context, (String)"raidtime").equals("now")) {
            IRaiderManager.RaidSpawnResult result = colony.getRaiderManager().raiderEvent(raidType, true, allowShips);
            if (result == IRaiderManager.RaidSpawnResult.SUCCESS) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.raidnow.success", (Object[])new Object[]{colony.getName()}), true);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"com.minecolonies.command.raidnow.failure", (Object[])new Object[]{colony.getName(), result}));
        } else if (StringArgumentType.getString(context, (String)"raidtime").equals("tonight")) {
            if (!colony.getRaiderManager().canRaid()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.raidnow.failure", (Object[])new Object[]{colony.getName(), IRaiderManager.RaidSpawnResult.CANNOT_RAID}), true);
                return 1;
            }
            colony.getRaiderManager().setRaidNextNight(true, raidType, allowShips);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.raidtonight.success", (Object[])new Object[]{colony.getName()}), true);
        }
        return 1;
    }

    @Override
    public String getName() {
        return "raid";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        ArrayList<String> raidTypes = new ArrayList<String>();
        for (ColonyEventTypeRegistryEntry type : IMinecoloniesAPI.getInstance().getColonyEventRegistry().getValues()) {
            if (type.getRegistryName().m_135815_().equals(PirateGroundRaidEvent.PIRATE_GROUND_RAID_EVENT_TYPE_ID.m_135815_()) || type.getRegistryName().m_135815_().equals(NorsemenShipRaidEvent.NORSEMEN_RAID_EVENT_TYPE_ID.m_135815_())) continue;
            raidTypes.add(type.getRegistryName().m_135815_());
        }
        String[] opt = new String[]{"now", "tonight"};
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("raidtime", StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82967_((String[])opt, (SuggestionsBuilder)builder)).then(((RequiredArgumentBuilder)IMCCommand.newArgument("colonyID", ColonyIdArgument.id()).then(IMCCommand.newArgument("raidtype", StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_((Iterable)raidTypes, (SuggestionsBuilder)builder)).then(IMCCommand.newArgument("allowships", BoolArgumentType.bool()).executes(this::onSpecificExecute)))).executes(this::checkPreConditionAndExecute)));
    }
}

