/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.colony.events.raid.RaidManager;
import com.minecolonies.core.commands.arguments.ColonyIdArgument;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.commands.commandTypes.IMCOPCommand;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;

public class CommandColonyRaidsInfo
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        IColony colony = ColonyIdArgument.getColony(context, "colonyID");
        if (!((CommandSourceStack)context.getSource()).m_6761_(4) && !((Boolean)MineColonies.getConfig().getServer().canPlayerUseShowColonyInfoCommand.get()).booleanValue()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"com.minecolonies.command.notenabledinconfig"), true);
            return 0;
        }
        List<RaidManager.RaidHistory> allRaids = ((RaidManager)colony.getRaiderManager()).getAllRaids();
        for (int i = 0; i < allRaids.size(); ++i) {
            RaidManager.RaidHistory history = allRaids.get(i);
            double hoursSince = (double)Math.round((double)(100L * (colony.getWorld().m_46467_() - history.raidTime)) / 72000.0) / 100.0;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)(hoursSince + " hours ago:" + String.valueOf(history))), true);
        }
        return 1;
    }

    @Override
    public String getName() {
        return "raidhistory";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", ColonyIdArgument.id()).executes(this::checkPreConditionAndExecute));
    }
}

