/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.managers;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.descriptions.IColonyEventDescription;
import com.minecolonies.api.colony.colonyEvents.registry.ColonyEventDescriptionTypeRegistryEntry;
import com.minecolonies.api.colony.managers.interfaces.IEventDescriptionManager;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayDeque;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class EventDescriptionManager
implements IEventDescriptionManager {
    private static final String TAG_EVENT_DESC_LIST = "event_descs_list";
    private final IColony colony;
    private final ArrayDeque<IColonyEventDescription> eventDescs = new ArrayDeque();

    public EventDescriptionManager(IColony colony) {
        this.colony = colony;
    }

    @Override
    public void addEventDescription(@NotNull IColonyEventDescription colonyEventDescription) {
        if (this.eventDescs.size() >= 100) {
            this.eventDescs.poll();
        }
        colonyEventDescription.setDay(this.colony.getDay());
        this.eventDescs.add(colonyEventDescription);
        if (this.colony.getBuildingManager().getTownHall() != null) {
            this.colony.getBuildingManager().getTownHall().markDirty();
        } else {
            this.colony.markDirty();
        }
    }

    @Override
    public void serialize(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.eventDescs.size());
        for (IColonyEventDescription event : this.eventDescs) {
            buf.m_130070_(event.getEventTypeId().m_135815_());
            event.serialize(buf);
        }
    }

    public void deserializeNBT(@NotNull CompoundTag eventManagerNBT) {
        ListTag eventDescListNBT = eventManagerNBT.m_128437_(TAG_EVENT_DESC_LIST, 10);
        for (Tag event : eventDescListNBT) {
            CompoundTag eventCompound = (CompoundTag)event;
            ResourceLocation eventTypeID = new ResourceLocation("minecolonies", eventCompound.m_128461_("name"));
            ColonyEventDescriptionTypeRegistryEntry registryEntry = (ColonyEventDescriptionTypeRegistryEntry)MinecoloniesAPIProxy.getInstance().getColonyEventDescriptionRegistry().getValue(eventTypeID);
            if (registryEntry == null) {
                Log.getLogger().warn("Event is missing registryEntry!:" + eventTypeID.m_135815_());
                continue;
            }
            IColonyEventDescription eventDescription = registryEntry.deserializeEventDescriptionFromNBT(eventCompound);
            this.eventDescs.add(eventDescription);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag eventManagerNBT = new CompoundTag();
        ListTag eventDescsListNBT = new ListTag();
        for (IColonyEventDescription event : this.eventDescs) {
            CompoundTag eventNBT = (CompoundTag)event.serializeNBT();
            eventNBT.m_128359_("name", event.getEventTypeId().m_135815_());
            eventDescsListNBT.add((Object)eventNBT);
        }
        eventManagerNBT.m_128365_(TAG_EVENT_DESC_LIST, (Tag)eventDescsListNBT);
        return eventManagerNBT;
    }

    @Override
    public void computeNews() {
        Object2IntOpenHashMap summaries = new Object2IntOpenHashMap();
        for (IColonyEventDescription event : this.eventDescs) {
            if (!event.includeInSummary() || event.getDay() != this.colony.getDay()) continue;
            summaries.compute((Object)event.getSummaryTranslationKey(), (key, value) -> value == null ? 1 : value + 1);
        }
        MessageUtils.MessageBuilder builder = null;
        for (Object2IntMap.Entry entry : summaries.object2IntEntrySet()) {
            if (builder == null) {
                builder = MessageUtils.format((Component)Component.m_237115_((String)"com.minecolonies.core.event.summary.prefix")).append((Component)Component.m_237110_((String)((String)entry.getKey()), (Object[])new Object[]{entry.getIntValue()}));
                continue;
            }
            builder = builder.append((Component)Component.m_237113_((String)", ")).append((Component)Component.m_237110_((String)((String)entry.getKey()), (Object[])new Object[]{entry.getIntValue()}));
        }
        if (builder != null) {
            builder.append((Component)Component.m_237113_((String)"!"));
            builder.sendTo(this.colony.getImportantMessageEntityPlayers());
        }
    }
}

