/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.crafting;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorageFactory;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.ModRecipeTypes;
import com.minecolonies.api.crafting.RecipeStorage;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.ArrayList;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class RecipeStorageFactory
implements IRecipeStorageFactory {
    private static final String TAG_GRID = "grid";
    private static final String BLOCK_TAG = "block";
    private static final String INPUT_TAG = "input";
    private static final String ALTOUTPUT_TAG = "alternate-output";
    private static final String SECOUTPUT_TAG = "secondary-output";
    private static final String SOURCE_TAG = "source";
    private static final String TYPE_TAG = "type";
    private static final String LOOT_TAG = "loot-table";
    private static final String TOOL_TAG = "tool";

    @Override
    @NotNull
    public TypeToken<RecipeStorage> getFactoryOutputType() {
        return TypeConstants.RECIPE;
    }

    @Override
    @NotNull
    public TypeToken<? extends IToken<?>> getFactoryInputType() {
        return TypeConstants.ITOKEN;
    }

    @Override
    @NotNull
    public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull RecipeStorage recipeStorage) {
        CompoundTag compound = new CompoundTag();
        @NotNull ListTag inputTagList = new ListTag();
        for (ItemStorage itemStorage : recipeStorage.getInput()) {
            @NotNull CompoundTag neededRes = StandardFactoryController.getInstance().serialize(itemStorage);
            inputTagList.add((Object)neededRes);
        }
        compound.m_128365_(INPUT_TAG, (Tag)inputTagList);
        recipeStorage.getPrimaryOutput().m_41739_(compound);
        if (recipeStorage.getIntermediate() != null) {
            compound.m_128365_(BLOCK_TAG, (Tag)NbtUtils.m_129202_((BlockState)recipeStorage.getIntermediate().m_49966_()));
        }
        compound.m_128405_(TAG_GRID, recipeStorage.getGridSize());
        compound.m_128365_("Token", (Tag)StandardFactoryController.getInstance().serialize(recipeStorage.getToken()));
        if (recipeStorage.getRecipeSource() != null) {
            compound.m_128359_(SOURCE_TAG, recipeStorage.getRecipeSource().toString());
        }
        compound.m_128359_(TYPE_TAG, recipeStorage.getRecipeType().getId().toString());
        @NotNull ListTag altOutputTagList = new ListTag();
        for (ItemStack stack : recipeStorage.getAlternateOutputs()) {
            @NotNull CompoundTag neededRes = new CompoundTag();
            stack.m_41739_(neededRes);
            altOutputTagList.add((Object)neededRes);
        }
        compound.m_128365_(ALTOUTPUT_TAG, (Tag)altOutputTagList);
        @NotNull ListTag listTag = new ListTag();
        for (ItemStack stack : recipeStorage.getCraftingToolsAndSecondaryOutputs()) {
            @NotNull CompoundTag neededRes = new CompoundTag();
            stack.m_41739_(neededRes);
            listTag.add((Object)neededRes);
        }
        compound.m_128365_(SECOUTPUT_TAG, (Tag)listTag);
        if (recipeStorage.getLootTable() != null) {
            compound.m_128359_(LOOT_TAG, recipeStorage.getLootTable().toString());
        }
        compound.m_128359_(TOOL_TAG, recipeStorage.getRequiredTool().getRegistryName().toString());
        return compound;
    }

    @Override
    @NotNull
    public RecipeStorage deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
        ArrayList<ItemStorage> input = new ArrayList<ItemStorage>();
        ListTag inputTagList = nbt.m_128437_(INPUT_TAG, 10);
        for (int i = 0; i < inputTagList.size(); ++i) {
            CompoundTag inputTag = inputTagList.m_128728_(i);
            if (inputTag.m_128441_("NType") || inputTag.m_128441_("Type")) {
                input.add((ItemStorage)StandardFactoryController.getInstance().deserialize(inputTag));
                continue;
            }
            ItemStorage newItem = new ItemStorage(ItemStack.m_41712_((CompoundTag)inputTag));
            input.add(newItem);
        }
        ItemStack primaryOutput = ItemStack.m_41712_((CompoundTag)nbt);
        Block intermediate = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)nbt.m_128469_(BLOCK_TAG)).m_60734_();
        int gridSize = nbt.m_128451_(TAG_GRID);
        IToken token = (IToken)StandardFactoryController.getInstance().deserialize(nbt.m_128469_("Token"));
        ResourceLocation source = nbt.m_128441_(SOURCE_TAG) ? new ResourceLocation(nbt.m_128461_(SOURCE_TAG)) : null;
        ResourceLocation type = nbt.m_128441_(TYPE_TAG) ? new ResourceLocation(nbt.m_128461_(TYPE_TAG).toLowerCase()) : ModRecipeTypes.CLASSIC_ID;
        ListTag altOutputTagList = nbt.m_128437_(ALTOUTPUT_TAG, 10);
        ArrayList<ItemStack> altOutputs = new ArrayList<ItemStack>();
        for (int i = 0; i < altOutputTagList.size(); ++i) {
            CompoundTag altOutputTag = altOutputTagList.m_128728_(i);
            altOutputs.add(ItemStack.m_41712_((CompoundTag)altOutputTag));
        }
        ListTag secOutputTagList = nbt.m_128437_(SECOUTPUT_TAG, 10);
        ArrayList<ItemStack> secOutputs = new ArrayList<ItemStack>();
        for (int i = 0; i < secOutputTagList.size(); ++i) {
            CompoundTag secOutputTag = secOutputTagList.m_128728_(i);
            secOutputs.add(ItemStack.m_41712_((CompoundTag)secOutputTag));
        }
        ResourceLocation lootTable = nbt.m_128441_(LOOT_TAG) ? new ResourceLocation(nbt.m_128461_(LOOT_TAG)) : null;
        EquipmentTypeEntry requiredTool = (EquipmentTypeEntry)ModEquipmentTypes.getRegistry().getValue(EquipmentTypeEntry.parseResourceLocation(nbt.m_128461_(TOOL_TAG)));
        return RecipeStorage.builder().withToken(token).withInputs(input).withGridSize(gridSize).withPrimaryOutput(primaryOutput).withIntermediate(intermediate).withRecipeId(source).withRecipeType(type).withAlternateOutputs(altOutputs).withSecondaryOutputs(secOutputs).withLootTable(lootTable).withRequiredTool(requiredTool).build();
    }

    @Override
    public void serialize(@NotNull IFactoryController controller, RecipeStorage input, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130130_(input.getInput().size());
        input.getInput().forEach(stack -> StandardFactoryController.getInstance().serialize(packetBuffer, stack));
        packetBuffer.m_130055_(input.getPrimaryOutput());
        packetBuffer.writeBoolean(input.getIntermediate() != null);
        if (input.getIntermediate() != null) {
            packetBuffer.m_130130_(Block.m_49956_((BlockState)input.getIntermediate().m_49966_()));
        }
        packetBuffer.m_130130_(input.getGridSize());
        packetBuffer.m_130085_(input.getRecipeType().getId());
        packetBuffer.m_130130_(input.getAlternateOutputs().size());
        input.getAlternateOutputs().forEach(stack -> packetBuffer.m_130055_(stack));
        packetBuffer.m_130130_(input.getCraftingToolsAndSecondaryOutputs().size());
        input.getCraftingToolsAndSecondaryOutputs().forEach(stack -> packetBuffer.m_130055_(stack));
        packetBuffer.m_130085_(input.getRequiredTool().getRegistryName());
        packetBuffer.writeBoolean(input.getLootTable() != null);
        if (input.getLootTable() != null) {
            packetBuffer.m_130085_(input.getLootTable());
        }
        packetBuffer.writeBoolean(input.getRecipeSource() != null);
        if (input.getRecipeSource() != null) {
            packetBuffer.m_130085_(input.getRecipeSource());
        }
        controller.serialize(packetBuffer, input.getToken());
    }

    @Override
    @NotNull
    public RecipeStorage deserialize(@NotNull IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
        ArrayList<ItemStorage> input = new ArrayList<ItemStorage>();
        int inputSize = buffer.m_130242_();
        for (int i = 0; i < inputSize; ++i) {
            input.add((ItemStorage)StandardFactoryController.getInstance().deserialize(buffer));
        }
        ItemStack primaryOutput = buffer.m_130267_();
        Block intermediate = buffer.readBoolean() ? Block.m_49803_((int)buffer.m_130242_()).m_60734_() : Blocks.f_50016_;
        int gridSize = buffer.m_130242_();
        ResourceLocation type = buffer.m_130281_();
        ArrayList<ItemStack> altOutputs = new ArrayList<ItemStack>();
        int altOutputSize = buffer.m_130242_();
        for (int i = 0; i < altOutputSize; ++i) {
            altOutputs.add(buffer.m_130267_());
        }
        ArrayList<ItemStack> secOutputs = new ArrayList<ItemStack>();
        int secOutputSize = buffer.m_130242_();
        for (int i = 0; i < secOutputSize; ++i) {
            secOutputs.add(buffer.m_130267_());
        }
        ResourceLocation resLoc = EquipmentTypeEntry.parseResourceLocation(buffer.m_130281_());
        EquipmentTypeEntry requiredTool = (EquipmentTypeEntry)ModEquipmentTypes.getRegistry().getValue(resLoc);
        ResourceLocation lootTable = null;
        if (buffer.readBoolean()) {
            lootTable = buffer.m_130281_();
        }
        ResourceLocation source = null;
        if (buffer.readBoolean()) {
            source = buffer.m_130281_();
        }
        IToken token = (IToken)controller.deserialize(buffer);
        return RecipeStorage.builder().withToken(token).withInputs(input).withGridSize(gridSize).withPrimaryOutput(primaryOutput).withIntermediate(intermediate).withRecipeId(source).withRecipeType(type).withAlternateOutputs(altOutputs).withSecondaryOutputs(secOutputs).withLootTable(lootTable).withRequiredTool(requiredTool).build();
    }

    @Override
    public short getSerializationId() {
        return 26;
    }
}

