/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.ItemListModule;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingFlorist
extends AbstractBuilding {
    private static final String FLORIST = "florist";
    private static final int MAX_BUILDING_LEVEL = 5;
    private final List<BlockPos> plantGround = new ArrayList<BlockPos>();

    public BuildingFlorist(@NotNull IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(stack -> stack.m_41720_() == ModItems.compost, new Tuple((Object)64, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.shears.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
    }

    public List<BlockPos> getPlantGround() {
        return ImmutableList.copyOf(this.plantGround);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return FLORIST;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull Level world) {
        super.registerBlockPosition(block, pos, world);
        if (block == ModBlocks.blockCompostedDirt && !this.plantGround.contains(pos)) {
            this.plantGround.add(pos);
        }
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        ListTag compostBinTagList = compound.m_128437_("plantGround", 10);
        for (int i = 0; i < compostBinTagList.size(); ++i) {
            this.plantGround.add(NbtUtils.m_129239_((CompoundTag)compostBinTagList.m_128728_(i).m_128469_("pos")));
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        @NotNull ListTag compostBinTagList = new ListTag();
        for (BlockPos entry : this.plantGround) {
            @NotNull CompoundTag compostBinCompound = new CompoundTag();
            compostBinCompound.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)entry));
            compostBinTagList.add((Object)compostBinCompound);
        }
        compound.m_128365_("plantGround", (Tag)compostBinTagList);
        return compound;
    }

    public void removePlantableGround(BlockPos pos) {
        this.plantGround.remove(pos);
    }

    @Nullable
    public ItemStack getFlowerToGrow() {
        List<ItemStorage> stacks = BuildingFlorist.getPlantablesForBuildingLevel(this.getBuildingLevel()).stream().filter(stack -> !((ItemListModule)this.getModuleMatching(ItemListModule.class, (T m) -> m.getId().equals("flowers"))).isItemInList((ItemStorage)stack)).toList();
        if (stacks.isEmpty()) {
            return null;
        }
        return stacks.get(MathUtils.RANDOM.nextInt(stacks.size())).getItemStack();
    }

    public static Set<ItemStorage> getPlantablesForBuildingLevel(int level) {
        switch (level) {
            case 0: 
            case 1: {
                return IColonyManager.getInstance().getCompatibilityManager().getCopyOfPlantables().stream().filter(storage -> storage.getItem() == Items.f_41940_ || storage.getItem() == Items.f_41939_).collect(Collectors.toSet());
            }
            case 2: {
                return IColonyManager.getInstance().getCompatibilityManager().getCopyOfPlantables().stream().filter(itemStorage -> itemStorage.getItemStack().m_204117_(ItemTags.f_13145_)).collect(Collectors.toSet());
            }
        }
        return IColonyManager.getInstance().getCompatibilityManager().getCopyOfPlantables();
    }
}

