/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.ItemListModule;
import com.minecolonies.core.entity.other.SittingEntity;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BuildingCook
extends AbstractBuilding {
    private static final String COOK_DESC = "cook";
    public static final String FOOD_EXCLUSION_LIST = "food";
    private static final int MAX_BUILDING_LEVEL = 5;

    public BuildingCook(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
    }

    @Override
    protected boolean keepFood() {
        return false;
    }

    public BlockPos getNextSittingPosition() {
        if (this.getLocationsFromTag("sit").isEmpty() && this.getLocationsFromTag("sit_in").isEmpty() && this.getLocationsFromTag("sit_out").isEmpty()) {
            Log.getLogger().error("Restaurant without sitting position. Style: {} Schematic: {}", (Object)this.getStructurePack(), (Object)this.getTileEntity().getBlueprintPath());
            return null;
        }
        int sittingSize = this.getLocationsFromTag("sit").size();
        int sitInSize = this.getLocationsFromTag("sit_in").size();
        int sitOutSize = this.getLocationsFromTag("sit_out").size();
        int totalSize = sittingSize + sitInSize + (this.colony.getWorld().m_46471_() ? 0 : sitOutSize);
        for (int i = 0; i < 3; ++i) {
            BlockPos pos;
            int rng = MathUtils.RANDOM.nextInt(totalSize);
            if (!(rng < sittingSize ? !SittingEntity.isSittingPosOccupied(pos = this.getLocationsFromTag("sit").get(rng), this.colony.getWorld()) : (rng < sittingSize + sitInSize ? !SittingEntity.isSittingPosOccupied(pos = this.getLocationsFromTag("sit_in").get(rng - sittingSize), this.colony.getWorld()) : !SittingEntity.isSittingPosOccupied(pos = this.getLocationsFromTag("sit_out").get(rng - sittingSize - sitInSize), this.colony.getWorld())))) continue;
            return pos;
        }
        return null;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return COOK_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public int buildingRequiresCertainAmountOfItem(ItemStack stack, List<ItemStorage> localAlreadyKept, boolean inventory, JobEntry jobEntry) {
        if (stack.m_41619_()) {
            return 0;
        }
        Predicate<ItemStack> allowedFuel = theStack -> ((ItemListModule)this.getModuleMatching(ItemListModule.class, (T m) -> m.getId().equals("fuel"))).isItemInList(new ItemStorage((ItemStack)theStack));
        if (allowedFuel.test(stack) && (localAlreadyKept.stream().filter(storage -> allowedFuel.test(storage.getItemStack())).mapToInt(ItemStorage::getAmount).sum() < 64 || !inventory)) {
            ItemStorage kept = new ItemStorage(stack);
            if (localAlreadyKept.contains(kept)) {
                kept.setAmount(localAlreadyKept.remove(localAlreadyKept.indexOf(kept)).getAmount());
            }
            localAlreadyKept.add(kept);
            return 0;
        }
        return super.buildingRequiresCertainAmountOfItem(stack, localAlreadyKept, inventory, jobEntry);
    }
}

