/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.factory;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.ITypeOverrideHandler;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public interface IFactoryController {
    default public <Input> IFactory<Input, ?> getFactoryForInput(@NotNull String className) throws IllegalArgumentException {
        try {
            return this.getFactoryForInput(TypeToken.of(Class.forName(className)));
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("The given input name is unknown", ex);
        }
    }

    public <Input> IFactory<Input, ?> getFactoryForInput(@NotNull TypeToken<? extends Input> var1) throws IllegalArgumentException;

    public <Input, Output> IFactory<Input, Output> getFactoryForIO(@NotNull TypeToken<? extends Input> var1, @NotNull TypeToken<? extends Output> var2) throws IllegalArgumentException;

    default public <Output> IFactory<?, Output> getFactoryForOutput(@NotNull String className) throws IllegalArgumentException {
        try {
            return this.getFactoryForOutput(TypeToken.of(Class.forName(className)));
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("The given output name is unknown", ex);
        }
    }

    default public <Output> IFactory<?, Output> getFactoryForOutput(short id) throws IllegalArgumentException {
        try {
            return this.getFactoryForSerializationId(id);
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("The given output name is unknown", ex);
        }
    }

    public <Output> IFactory<?, Output> getFactoryForOutput(@NotNull TypeToken<? extends Output> var1) throws IllegalArgumentException;

    public <Output> IFactory<?, Output> getFactoryForSerializationId(short var1) throws IllegalArgumentException;

    public <Input, Output> void registerNewFactory(@NotNull IFactory<Input, Output> var1) throws IllegalArgumentException;

    public <Output> CompoundTag serialize(@NotNull Output var1) throws IllegalArgumentException;

    default public <Output> Tag serializeList(Collection<Output> list) {
        ListTag tag = new ListTag();
        for (Output value : list) {
            tag.add((Object)this.serialize(value));
        }
        return tag;
    }

    public <Output> Output deserialize(@NotNull CompoundTag var1) throws IllegalArgumentException;

    default public <Output> Collection<Output> deserializeList(ListTag listTag) {
        ArrayList<Output> values = new ArrayList<Output>();
        for (Tag subCompound : listTag) {
            values.add(this.deserialize((CompoundTag)subCompound));
        }
        return values;
    }

    public <Output> void serialize(@NotNull FriendlyByteBuf var1, @NotNull Output var2) throws IllegalArgumentException;

    public <Output> Output deserialize(@NotNull FriendlyByteBuf var1) throws IllegalArgumentException;

    public <Input, Output> Output getNewInstance(@NotNull TypeToken<? extends Output> var1, @NotNull Input var2, Object ... var3) throws IllegalArgumentException, ClassCastException;

    public <Output> Output getNewInstance(@NotNull TypeToken<? extends Output> var1) throws IllegalArgumentException, ClassCastException;

    public <Output> void registerNewTypeOverrideHandler(@NotNull ITypeOverrideHandler<Output> var1);
}

