/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.connections;

import com.minecolonies.api.util.BlockPosUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;

public class ColonyConnectionNode {
    private BlockPos previousNode = BlockPos.f_121853_;
    private BlockPos nextNode = BlockPos.f_121853_;
    private final BlockPos position;
    private int targetColonyId = -1;

    public ColonyConnectionNode(BlockPos position) {
        this.position = position;
    }

    public void alterPreviousNode(BlockPos previousNode) {
        this.previousNode = previousNode;
    }

    public void alterNextNode(BlockPos nextNode) {
        this.nextNode = nextNode;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public BlockPos getPreviousNode() {
        return this.previousNode;
    }

    public BlockPos getNextNode() {
        return this.nextNode;
    }

    public int getTargetColonyId() {
        return this.targetColonyId;
    }

    public void setTargetColonyId(int targetColonyId) {
        this.targetColonyId = targetColonyId;
    }

    public CompoundTag write() {
        CompoundTag compound = new CompoundTag();
        BlockPosUtil.write(compound, "pos", this.position);
        BlockPosUtil.write(compound, "prevpos", this.previousNode);
        BlockPosUtil.write(compound, "nextpos", this.nextNode);
        compound.m_128405_("targetcolony", this.targetColonyId);
        return compound;
    }

    public void read(@NotNull CompoundTag compound) {
        this.previousNode = BlockPosUtil.read(compound, "prevpos");
        this.nextNode = BlockPosUtil.read(compound, "nextpos");
        this.targetColonyId = compound.m_128451_("targetcolony");
    }

    public boolean hasNextNode() {
        return !this.nextNode.equals((Object)BlockPos.f_121853_);
    }
}

