/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.buildingextensions;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildingextensions.modules.IBuildingExtensionModule;
import com.minecolonies.api.colony.buildingextensions.registry.BuildingExtensionRegistries;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.modules.IModuleContainer;
import com.minecolonies.api.util.BlockPosUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IBuildingExtension
extends IModuleContainer<IBuildingExtensionModule> {
    @NotNull
    public BuildingExtensionRegistries.BuildingExtensionEntry getBuildingExtensionType();

    @NotNull
    public BlockPos getPosition();

    @Nullable
    public BlockPos getBuildingId();

    public void setBuilding(BlockPos var1);

    public void resetOwningBuilding();

    public boolean isTaken();

    public int getSqDistance(IBuildingView var1);

    @NotNull
    public CompoundTag serializeNBT();

    public void deserializeNBT(@NotNull CompoundTag var1);

    public void serialize(@NotNull FriendlyByteBuf var1);

    public void deserialize(@NotNull FriendlyByteBuf var1);

    public boolean isValidPlacement(IColony var1);

    public int hashCode();

    public boolean equals(Object var1);

    public ExtensionId getId();

    public record ExtensionId(BlockPos pos, BuildingExtensionRegistries.BuildingExtensionEntry entry) {
        public Tag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            BlockPosUtil.write(tag, "pos", this.pos);
            tag.m_128359_("id", this.entry.getRegistryName().toString());
            return tag;
        }

        public static ExtensionId deserializeNBT(CompoundTag nbt) {
            return new ExtensionId(BlockPosUtil.read(nbt, "pos"), (BuildingExtensionRegistries.BuildingExtensionEntry)BuildingExtensionRegistries.getBuildingExtensionRegistry().getValue(ResourceLocation.m_135820_((String)nbt.m_128461_("id"))));
        }
    }
}

