/*
 * Decompiled with CFR 0.152.
 */
package io.karma.unifyeverything;

import com.almostreliable.unified.api.AlmostUnifiedLookup;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="unifyeverything")
public class AlmostUnifyEverything {
    public static final String MODID = "unifyeverything";
    public static final Logger LOGGER = LogManager.getLogger((String)"AUE");

    public AlmostUnifyEverything() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(this::onRegisterCommands);
    }

    public static ItemStack unify(ItemStack stack) {
        Item item = AlmostUnifiedLookup.INSTANCE.getReplacementForItem((ItemLike)stack.m_41720_());
        if (item == null || item == stack.m_41720_()) {
            return stack;
        }
        return new ItemStack((ItemLike)item, stack.m_41613_());
    }

    public static int unifyInventory(Container container) {
        int unifiedItems = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack input = container.m_8020_(i);
            ItemStack output = AlmostUnifyEverything.unify(input);
            if (input.m_41720_() == output.m_41720_()) continue;
            container.m_6836_(i, output);
            ++unifiedItems;
        }
        return unifiedItems;
    }

    private int unifyInventory(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (player == null) {
            return 0;
        }
        int unifiedItems = AlmostUnifyEverything.unifyInventory((Container)player.m_150109_());
        if (unifiedItems > 0) {
            player.m_213846_((Component)Component.m_237110_((String)String.format("message.%s.unified_items", MODID), (Object[])new Object[]{unifiedItems}));
        }
        return 1;
    }

    private int unifyPlayersIn(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer sender = ((CommandSourceStack)context.getSource()).m_81375_();
        sender.m_213846_((Component)Component.m_237115_((String)String.format("message.%s.performance_warning", MODID)));
        MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
        ResourceLocation dimension = (ResourceLocation)context.getArgument("dimension", ResourceLocation.class);
        ResourceKey dimensionKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimension);
        ServerLevel level = server.m_129880_(dimensionKey);
        if (level == null) {
            return 0;
        }
        int unifiedItems = 0;
        for (ServerPlayer player2 : level.m_8795_(player -> true)) {
            unifiedItems += AlmostUnifyEverything.unifyInventory((Container)player2.m_150109_());
        }
        if (unifiedItems > 0) {
            sender.m_213846_((Component)Component.m_237110_((String)String.format("message.%s.unified_items_in", MODID), (Object[])new Object[]{unifiedItems, dimension}));
        }
        return 1;
    }

    private int unifyInventoriesInRange(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer sender = ((CommandSourceStack)context.getSource()).m_81375_();
        Level level = sender.m_9236_();
        sender.m_213846_((Component)Component.m_237115_((String)String.format("message.%s.performance_warning", MODID)));
        BlockPos pos = sender.m_20097_();
        int range = (Integer)context.getArgument("rangeInChunks", Integer.class);
        int unifiedItems = 0;
        ChunkPos centerChunkPos = level.m_46865_(pos).m_7697_();
        int fullRange = range << 1;
        int numChunks = fullRange * fullRange;
        int chunkIndex = 0;
        for (int zOffset = -range; zOffset < range; ++zOffset) {
            for (int xOffset = -range; xOffset < range; ++xOffset) {
                int chunkX = centerChunkPos.f_45578_ + xOffset;
                int chunkZ = centerChunkPos.f_45579_ + zOffset;
                if (!level.m_7232_(chunkX, chunkZ)) {
                    sender.m_213846_((Component)Component.m_237110_((String)String.format("message.%s.processed_chunk_at", MODID), (Object[])new Object[]{chunkIndex + 1, numChunks, chunkX, chunkZ}));
                    ++chunkIndex;
                    continue;
                }
                LevelChunk chunk = level.m_6325_(chunkX, chunkZ);
                for (BlockPos blockEntityPos : chunk.m_5928_()) {
                    Container container;
                    int numberUnified;
                    BlockEntity blockEntity = chunk.getExistingBlockEntity(blockEntityPos);
                    if (!(blockEntity instanceof Container) || (numberUnified = AlmostUnifyEverything.unifyInventory(container = (Container)blockEntity)) <= 0) continue;
                    blockEntity.m_6596_();
                    unifiedItems += numberUnified;
                    sender.m_213846_((Component)Component.m_237110_((String)String.format("message.%s.unified_items_at", MODID), (Object[])new Object[]{numberUnified, blockEntityPos.m_123344_()}));
                }
                sender.m_213846_((Component)Component.m_237110_((String)String.format("message.%s.processed_chunk_at", MODID), (Object[])new Object[]{chunkIndex + 1, numChunks, chunkX, chunkZ}));
                ++chunkIndex;
            }
        }
        if (unifiedItems > 0) {
            sender.m_213846_((Component)Component.m_237110_((String)String.format("message.%s.unified_items", MODID), (Object[])new Object[]{unifiedItems}));
        }
        return 1;
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)MODID).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"unify").then(LiteralArgumentBuilder.literal((String)"playersin").then(RequiredArgumentBuilder.argument((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(this::unifyPlayersIn)))).then(LiteralArgumentBuilder.literal((String)"all").then(RequiredArgumentBuilder.argument((String)"rangeInChunks", (ArgumentType)IntegerArgumentType.integer()).executes(this::unifyInventoriesInRange)))).executes(this::unifyInventory)));
    }
}

