/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEIJeiRuntime;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.Minecraft;

public enum JEIRecipesGui implements IRecipesGui
{
    INSTANCE;


    @Override
    public <V> void show(IFocus<V> focus) {
        EntryStack<?> stack;
        ViewSearchBuilder builder = ViewSearchBuilder.builder();
        if (focus != null && (stack = JEIPluginDetector.unwrapStack(focus.getTypedValue())) != null && !stack.isEmpty()) {
            if (focus.getRole() == RecipeIngredientRole.INPUT || focus.getRole() == RecipeIngredientRole.CATALYST) {
                builder.addUsagesFor(stack);
            } else {
                builder.addRecipesFor(stack);
            }
        }
        builder.open();
    }

    @Override
    public void show(List<IFocus<?>> focuses) {
        ViewSearchBuilder builder = ViewSearchBuilder.builder();
        for (IFocus<?> focus : focuses) {
            EntryStack<?> stack = JEIPluginDetector.unwrapStack(focus.getTypedValue());
            if (focus.getRole() == RecipeIngredientRole.INPUT || focus.getRole() == RecipeIngredientRole.CATALYST) {
                builder.addUsagesFor(stack);
                continue;
            }
            builder.addRecipesFor(stack);
        }
        builder.open();
    }

    @Override
    public void showTypes(List<RecipeType<?>> recipeTypes) {
        ViewSearchBuilder.builder().addCategories((Collection)CollectionUtils.map(recipeTypes, JEIPluginDetector::categoryId)).open();
    }

    @Override
    public <T> Optional<T> getIngredientUnderMouse(IIngredientType<T> ingredientType) {
        T ingredient = JEIJeiRuntime.INSTANCE.getIngredientListOverlay().getIngredientUnderMouse(ingredientType);
        if (ingredient != null) {
            return Optional.of(ingredient);
        }
        ingredient = JEIJeiRuntime.INSTANCE.getBookmarkOverlay().getIngredientUnderMouse(ingredientType);
        if (ingredient != null) {
            return Optional.of(ingredient);
        }
        EntryStack focusedStack = ScreenRegistry.getInstance().getFocusedStack(Minecraft.m_91087_().f_91080_, PointHelper.ofMouse());
        if (focusedStack == null) {
            return Optional.empty();
        }
        if (focusedStack.getType() != JEIPluginDetector.unwrapType(ingredientType)) {
            return Optional.empty();
        }
        return Optional.ofNullable(JEIPluginDetector.jeiValue(focusedStack.cast()));
    }
}

