/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.network;

import java.util.EnumMap;
import java.util.HashMap;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.network.FriendlyByteBuf;

public abstract class PacketDataFragment
extends AbstractPacket {
    public String fileName;
    public short packetTotal;
    public short packetNumber;
    public byte[] data;
    public static final EnumMap<LogicalSide, HashMap<String, byte[][]>> SIDED_PARTIAL_DATA = new EnumMap(LogicalSide.class);

    public PacketDataFragment() {
    }

    public PacketDataFragment(String fileName, int packetTotal, int packetNumber, byte[] data) {
        this.fileName = fileName;
        this.packetTotal = (short)packetTotal;
        this.packetNumber = (short)packetNumber;
        this.data = data;
    }

    @Override
    public void writeTo(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.fileName);
        buffer.writeShort((int)this.packetTotal);
        buffer.writeShort((int)this.packetNumber);
        buffer.writeInt(this.data.length);
        buffer.writeBytes(this.data);
    }

    @Override
    public void readFrom(FriendlyByteBuf buffer) {
        this.fileName = buffer.m_130136_(Short.MAX_VALUE);
        this.packetTotal = buffer.readShort();
        this.packetNumber = buffer.readShort();
        this.data = new byte[buffer.readInt()];
        buffer.readBytes(this.data);
    }

    public byte[] process(boolean client) {
        HashMap sidedFiles = SIDED_PARTIAL_DATA.computeIfAbsent(client ? LogicalSide.CLIENT : LogicalSide.SERVER, v -> new HashMap());
        byte[][] packets = sidedFiles.computeIfAbsent(this.fileName, v -> new byte[this.packetTotal][]);
        packets[this.packetNumber] = this.data;
        boolean complete = true;
        for (byte[] b : packets) {
            if (b != null && b.length != 0) continue;
            complete = false;
            break;
        }
        if (complete) {
            int size = 0;
            for (int i = 0; i < packets.length; ++i) {
                size += packets[i].length;
            }
            byte[] fileData = new byte[size];
            int index = 0;
            for (int i = 0; i < packets.length; ++i) {
                System.arraycopy(packets[i], 0, fileData, index, packets[i].length);
                index += packets[i].length;
            }
            sidedFiles.remove(this.fileName);
            return fileData;
        }
        return null;
    }

    private static enum LogicalSide {
        CLIENT,
        SERVER;

    }
}

