/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.tflostblocks.client;

import com.kittehmod.tflostblocks.blockentities.ModBlockEntities;
import com.kittehmod.tflostblocks.registry.ModBlocks;
import java.awt.Color;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import twilightforest.block.AuroraBrickBlock;
import twilightforest.init.TFBlocks;
import twilightforest.util.ColorUtil;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientHandler {
    public static void setupRenderers() {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.LOST_TF_SIGN.get()), SignRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.LOST_TF_HANGING_SIGN.get()), HangingSignRenderer::new);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.AURORALIZED_GLASS_PANE.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.THORN_DOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.THORN_TRAPDOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.TOWERWOOD_DOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.TOWERWOOD_TRAPDOOR.get()), (RenderType)RenderType.m_110463_());
    }

    @SubscribeEvent
    public static void registerBlockColours(RegisterColorHandlersEvent.Block event) {
        BlockColors blockColours = event.getBlockColors();
        event.register((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (worldIn == null || pos == null) {
                return -1;
            }
            float f = AuroraBrickBlock.rippleFractialNoise((int)2, (float)32.0f, (BlockPos)pos, (float)0.4f, (float)1.0f, (float)2.0f);
            return Color.HSBtoRGB(0.1f, 1.0f - f, (f + 2.0f) / 3.0f);
        }, new Block[]{(Block)ModBlocks.TOWERWOOD_STAIRS.get(), (Block)ModBlocks.TOWERWOOD_SLAB.get(), (Block)ModBlocks.TOWERWOOD_FENCE.get(), (Block)ModBlocks.TOWERWOOD_FENCE_GATE.get(), (Block)ModBlocks.TOWERWOOD_DOOR.get(), (Block)ModBlocks.TOWERWOOD_TRAPDOOR.get(), (Block)ModBlocks.TOWERWOOD_BUTTON.get(), (Block)ModBlocks.TOWERWOOD_PRESSURE_PLATE.get(), (Block)ModBlocks.MOSSY_TOWERWOOD_STAIRS.get(), (Block)ModBlocks.MOSSY_TOWERWOOD_SLAB.get()});
        event.register((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            int normalColor = blockColours.m_92577_(((Block)TFBlocks.AURORA_BLOCK.get()).m_49966_(), worldIn, pos, tintIndex);
            int red = normalColor >> 16 & 0xFF;
            int blue = normalColor & 0xFF;
            int green = normalColor >> 8 & 0xFF;
            float[] hsb = ColorUtil.rgbToHSV((int)red, (int)green, (int)blue);
            return ColorUtil.hsvToRGB((float)hsb[0], (float)(hsb[1] * 0.5f), (float)Math.min(hsb[2] + 0.4f, 0.9f));
        }, new Block[]{(Block)ModBlocks.AURORA_STAIRS.get(), (Block)ModBlocks.AURORA_WALL.get(), (Block)ModBlocks.AURORALIZED_GLASS_PANE.get()});
    }

    @SubscribeEvent
    public static void registerItemColours(RegisterColorHandlersEvent.Item event) {
        BlockColors blockColours = event.getBlockColors();
        event.register((stack, tintIndex) -> blockColours.m_92577_(((BlockItem)stack.m_41720_()).m_40614_().m_49966_(), null, null, tintIndex), new ItemLike[]{(ItemLike)ModBlocks.AURORA_STAIRS.get(), (ItemLike)ModBlocks.AURORA_WALL.get(), (ItemLike)ModBlocks.AURORALIZED_GLASS_PANE.get()});
    }
}

