/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain;

import com.leclowndu93150.particlerain.ModConfig;
import com.leclowndu93150.particlerain.ParticleRainClient;
import com.leclowndu93150.particlerain.ParticleRegistry;
import com.leclowndu93150.particlerain.WeatherParticleSpawner;
import com.leclowndu93150.particlerain.particle.DustMoteParticle;
import com.leclowndu93150.particlerain.particle.DustParticle;
import com.leclowndu93150.particlerain.particle.FogParticle;
import com.leclowndu93150.particlerain.particle.GroundFogParticle;
import com.leclowndu93150.particlerain.particle.RainParticle;
import com.leclowndu93150.particlerain.particle.RippleParticle;
import com.leclowndu93150.particlerain.particle.ShrubParticle;
import com.leclowndu93150.particlerain.particle.SnowParticle;
import com.leclowndu93150.particlerain.particle.StreakParticle;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import it.unimi.dsi.fastutil.ints.IntUnaryOperator;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Math;

public class ClientStuff {
    public static final String MOD_ID = "particlerain";
    public static ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
    public static boolean previousBiomeTintOption;
    public static boolean previousUseResolutionOption;
    public static int previousResolutionOption;
    public static IntUnaryOperator desaturateOperation;

    static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ParticleRegistry.RAIN.get(), RainParticle.DefaultFactory::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.SNOW.get(), SnowParticle.DefaultFactory::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.DUST_MOTE.get(), DustMoteParticle.DefaultFactory::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.DUST.get(), DustParticle.DefaultFactory::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.SHRUB.get(), ShrubParticle.DefaultFactory::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.FOG.get(), FogParticle.DefaultFactory::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.GROUND_FOG.get(), GroundFogParticle.DefaultFactory::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.RIPPLE.get(), RippleParticle.DefaultFactory::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.STREAK.get(), StreakParticle.DefaultFactory::new);
    }

    static InteractionResult saveListener(ConfigHolder<ModConfig> modConfigConfigHolder, ModConfig modConfig) {
        if (ClientStuff.config.biomeTint != previousBiomeTintOption || ClientStuff.config.ripple.useResourcepackResolution != previousUseResolutionOption || ClientStuff.config.ripple.resolution != previousResolutionOption) {
            Minecraft.m_91087_().m_91391_();
        }
        return InteractionResult.PASS;
    }

    public static void applyWaterTint(TextureSheetParticle particle, ClientLevel clientLevel, BlockPos blockPos) {
        Color waterColor = new Color(BiomeColors.m_108811_((BlockAndTintGetter)clientLevel, (BlockPos)blockPos));
        Color fogColor = new Color(((Biome)clientLevel.m_204166_(blockPos).m_203334_()).m_47539_());
        float rCol = Mth.m_14179_((float)((float)ClientStuff.config.tintMix / 100.0f), (float)waterColor.getRed(), (float)fogColor.getRed()) / 255.0f;
        float gCol = Mth.m_14179_((float)((float)ClientStuff.config.tintMix / 100.0f), (float)waterColor.getGreen(), (float)fogColor.getGreen()) / 255.0f;
        float bCol = Mth.m_14179_((float)((float)ClientStuff.config.tintMix / 100.0f), (float)waterColor.getBlue(), (float)fogColor.getBlue()) / 255.0f;
        particle.m_107253_(rCol, gCol, bCol);
    }

    public static NativeImage loadTexture(ResourceLocation resourceLocation) throws IOException {
        NativeImage nativeImage;
        Resource resource = Minecraft.m_91087_().m_91098_().m_215593_(resourceLocation);
        try (InputStream inputStream = resource.m_215507_();){
            nativeImage = NativeImage.m_85058_((InputStream)inputStream);
        }
        return nativeImage;
    }

    public static SpriteContents splitImage(NativeImage image, int segment, String id) {
        int size = image.m_84982_();
        NativeImage sprite = new NativeImage(size, size, false);
        image.m_260930_(sprite, 0, size * segment, 0, 0, size, size, true, true);
        return new SpriteContents(new ResourceLocation(MOD_ID, id + segment), new FrameSize(size, size), sprite, AnimationMetadataSection.f_119012_);
    }

    public static double yLevelWindAdjustment(double y) {
        return Math.clamp((double)0.01, (double)1.0, (double)((y - 64.0) / 40.0));
    }

    public static int getRippleResolution(List<SpriteContents> contents) {
        if (ClientStuff.config.ripple.useResourcepackResolution) {
            ResourceLocation resourceLocation = new ResourceLocation("big_smoke_0");
            for (SpriteContents spriteContents : contents) {
                if (!spriteContents.m_246162_().equals((Object)resourceLocation) || spriteContents.m_246492_() >= 256) continue;
                return spriteContents.m_246492_();
            }
        }
        if (ClientStuff.config.ripple.resolution < 4) {
            ClientStuff.config.ripple.resolution = 4;
        }
        if (ClientStuff.config.ripple.resolution > 256) {
            ClientStuff.config.ripple.resolution = 256;
        }
        return ClientStuff.config.ripple.resolution;
    }

    public static SpriteContents generateRipple(int i, int size) {
        float radius = (float)size / 2.0f / 8.0f * (float)(i + 1);
        NativeImage image = new NativeImage(size, size, true);
        Color color = Color.WHITE;
        int colorint = (color.getAlpha() & 0xFF) << 24 | (color.getRed() & 0xFF) << 16 | (color.getGreen() & 0xFF) << 8 | color.getBlue() & 0xFF;
        ClientStuff.generateBresenhamCircle(image, size, (int)Math.clamp((float)1.0f, (float)((float)size / 2.0f - 1.0f), (float)radius), colorint);
        return new SpriteContents(new ResourceLocation(MOD_ID, "ripple" + i), new FrameSize(size, size), image, AnimationMetadataSection.f_119012_);
    }

    public static void generateBresenhamCircle(NativeImage image, int imgSize, int radius, int colorint) {
        int centerX = imgSize / 2;
        int centerY = imgSize / 2;
        int x = 0;
        int y = radius;
        int d = 3 - 2 * radius;
        ClientStuff.drawCirclePixel(centerX, centerY, x, y, image, colorint);
        while (y >= x) {
            d = d > 0 ? d + 4 * (x - --y) + 10 : d + 4 * x + 6;
            ClientStuff.drawCirclePixel(centerX, centerY, ++x, y, image, colorint);
        }
    }

    static void drawCirclePixel(int xc, int yc, int x, int y, NativeImage img, int col) {
        img.m_84988_(xc + x, yc + y, col);
        img.m_84988_(xc - x, yc + y, col);
        img.m_84988_(xc + x, yc - y, col);
        img.m_84988_(xc - x, yc - y, col);
        img.m_84988_(xc + y, yc + x, col);
        img.m_84988_(xc - y, yc + x, col);
        img.m_84988_(xc + y, yc - x, col);
        img.m_84988_(xc - y, yc - x, col);
    }

    static {
        desaturateOperation = rgba -> {
            Color col = new Color(rgba, true);
            int gray = Math.max((int)Math.max((int)col.getRed(), (int)col.getGreen()), (int)col.getBlue());
            return (col.getAlpha() & 0xFF) << 24 | (gray & 0xFF) << 16 | (gray & 0xFF) << 8 | gray & 0xFF;
        };
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ModClientForgeEvents {
        @SubscribeEvent
        public static void registerClientCommands(RegisterClientCommandsEvent event) {
            event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)ClientStuff.MOD_ID).executes(ctx -> {
                ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237113_((String)String.format("Particle count: %d/%d", ParticleRainClient.particleCount, ParticleRainClient.config.maxParticleAmount)));
                ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237113_((String)String.format("Fog density: %d/%d", ParticleRainClient.fogCount, ParticleRainClient.config.groundFog.density)));
                return 0;
            }));
        }

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            Minecraft minecraft;
            if (event.phase == TickEvent.Phase.END && !(minecraft = Minecraft.m_91087_()).m_91104_() && minecraft.f_91073_ != null && minecraft.m_91288_() != null) {
                WeatherParticleSpawner.update(minecraft.f_91073_, minecraft.m_91288_(), minecraft.m_261169_());
            }
        }

        @SubscribeEvent
        public static void onPlayerJoin(ClientPlayerNetworkEvent.LoggingIn event) {
            ParticleRainClient.particleCount = 0;
            ParticleRainClient.fogCount = 0;
        }

        @SubscribeEvent
        public static void onPlayerClone(ClientPlayerNetworkEvent.Clone event) {
            ParticleRainClient.particleCount = 0;
            ParticleRainClient.fogCount = 0;
        }
    }
}

