/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.net;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.MainThreaded;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.multipart.api.PartContainer;
import org.zeith.multipart.api.PartEntity;
import org.zeith.multipart.blocks.BlockMultipartContainer;
import org.zeith.multipart.client.IClientPartDefinitionExtensions;

@MainThreaded
public class PacketSendLandingEffect
implements IPacket {
    protected BlockPos pos;
    protected int numberOfParticles;
    protected int entityId;
    protected AABB entityAABB;
    protected Vec3 particlePos;

    public PacketSendLandingEffect(BlockPos pos, int numberOfParticles, LivingEntity entity) {
        this.pos = pos;
        this.numberOfParticles = numberOfParticles;
        this.entityId = entity.m_19879_();
        this.entityAABB = entity.m_20191_();
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        BlockPos entPos = entity.m_20183_();
        if (pos.m_123341_() != entPos.m_123341_() || pos.m_123343_() != entPos.m_123343_()) {
            double d3 = x - (double)pos.m_123341_() - 0.5;
            double d5 = z - (double)pos.m_123343_() - 0.5;
            double d6 = Math.max(Math.abs(d3), Math.abs(d5));
            x = (double)pos.m_123341_() + 0.5 + d3 / d6 * 0.5;
            z = (double)pos.m_123343_() + 0.5 + d5 / d6 * 0.5;
        }
        this.particlePos = new Vec3(x, y, z);
    }

    public PacketSendLandingEffect() {
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.numberOfParticles);
        buf.writeInt(this.entityId);
        buf.writeDouble(this.entityAABB.f_82288_);
        buf.writeDouble(this.entityAABB.f_82289_);
        buf.writeDouble(this.entityAABB.f_82290_);
        buf.writeDouble(this.entityAABB.f_82291_);
        buf.writeDouble(this.entityAABB.f_82292_);
        buf.writeDouble(this.entityAABB.f_82293_);
        buf.writeDouble(this.particlePos.f_82479_);
        buf.writeDouble(this.particlePos.f_82480_);
        buf.writeDouble(this.particlePos.f_82481_);
    }

    public void read(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.numberOfParticles = buf.readInt();
        this.entityId = buf.readInt();
        double minX = buf.readDouble();
        double minY = buf.readDouble();
        double minZ = buf.readDouble();
        double maxX = buf.readDouble();
        double maxY = buf.readDouble();
        double maxZ = buf.readDouble();
        this.entityAABB = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        this.particlePos = new Vec3(x, y, z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientExecute(PacketContext ctx) {
        Entity entity;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (entity = level.m_6815_(this.entityId)) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            PartContainer ctr = BlockMultipartContainer.pc((BlockGetter)level, this.pos);
            if (ctr == null) {
                return;
            }
            for (PartEntity part : ctr.parts()) {
                VoxelShape shape = Shapes.m_83113_((VoxelShape)part.getShape().m_83216_((double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)this.entityAABB.m_82400_(0.1)), (BooleanOp)BooleanOp.f_82689_);
                if (shape.m_83281_()) continue;
                IClientPartDefinitionExtensions.of(part).addLandingEffects(part, shape, living, this.numberOfParticles, this.entityAABB, this.particlePos);
            }
        }
    }
}

