/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.impl.parts.entities;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.abstractions.actions.impl.MethodHandleLevelAction;
import org.zeith.hammerlib.annotations.ExposedToLevelAction;
import org.zeith.hammerlib.api.io.NBTSerializable;
import org.zeith.hammerlib.util.java.reflection.SerializableMethodHandle;
import org.zeith.hammerlib.util.java.tuples.Tuple2;
import org.zeith.hammerlib.util.java.tuples.Tuples;
import org.zeith.hammerlib.util.mcf.LogicalSidePredictor;
import org.zeith.multipart.api.PartContainer;
import org.zeith.multipart.api.PartDefinition;
import org.zeith.multipart.api.PartEntity;
import org.zeith.multipart.api.placement.PartPlacement;
import org.zeith.multipart.api.placement.PartPos;
import org.zeith.multipart.init.PartPlacementsHM;

public class PartEntityRedstoneTorch
extends PartEntity {
    public final ParticleOptions flameParticle = DustParticleOptions.f_123656_;
    @NBTSerializable
    protected boolean lit = true;
    @NBTSerializable
    protected boolean awaitingTick;
    protected final List<Toggle> recentToggles = new ArrayList<Toggle>();
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)13.0, (double)5.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)13.0, (double)10.5), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)13.0, (double)10.5)));
    private static VoxelShape AABB = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);

    public PartEntityRedstoneTorch(PartDefinition definition, PartContainer container, PartPlacement placement) {
        super(definition, container, placement);
    }

    @Override
    public VoxelShape updateCollisionShape() {
        return Shapes.m_83040_();
    }

    @Override
    public List<ItemStack> getDrops(@Nullable ServerPlayer harvester, LootParams.Builder drops) {
        return Blocks.f_50174_.m_49635_(Blocks.f_50174_.m_49966_(), drops);
    }

    @Override
    protected VoxelShape updateShape() {
        if (this.placement == PartPlacementsHM.DOWN) {
            return AABB;
        }
        Direction direction = this.placement.getDirection();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.updateShape();
        }
        return AABBS.get(direction.m_122424_());
    }

    @Override
    public VoxelShape getPartOccupiedShape() {
        return this.getShape();
    }

    @Override
    public Optional<Tuple2<BlockState, Function<BlockPos, BlockEntity>>> disassemblePart() {
        return Optional.of(Tuples.immutable((Object)this.getRenderState(), null));
    }

    @Override
    public void animateTick(RandomSource random) {
        if (random.m_188499_() || !this.lit) {
            return;
        }
        Level level = this.container.level();
        BlockPos pos = this.container.pos();
        if (this.placement == PartPlacementsHM.DOWN) {
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = (double)pos.m_123342_() + 0.7;
            double d2 = (double)pos.m_123343_() + 0.5;
            level.m_7106_(this.flameParticle, d0, d1, d2, 0.0, 0.0, 0.0);
        } else {
            Direction direction = this.placement.getDirection();
            if (direction == null) {
                return;
            }
            direction = direction.m_122424_();
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = (double)pos.m_123342_() + 0.7;
            double d2 = (double)pos.m_123343_() + 0.5;
            Direction direction1 = direction.m_122424_();
            level.m_7106_(this.flameParticle, d0 + 0.27 * (double)direction1.m_122429_(), d1 + 0.22, d2 + 0.27 * (double)direction1.m_122431_(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void neighborChanged(@Nullable Direction from, BlockPos neigborPos, BlockState neigborState, boolean waterlogged) {
        Level level;
        boolean ns;
        Direction towards = this.placement.getDirection();
        if (towards == null) {
            return;
        }
        if (PartPlacementsHM.SIDED_PLACEMENT.apply(towards) != this.placement) {
            return;
        }
        BlockPos pos = this.container.pos().m_121945_(towards);
        if (waterlogged || !this.container.level().m_8055_(pos).m_60783_((BlockGetter)this.container.level(), pos, towards.m_122424_())) {
            this.container.queuePartRemoval(this.placement, true, true, true);
        }
        if (this.lit == (ns = this.hasNeighborSignal(this.container.level, this.container.pos)) && (level = this.container.level) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            this.awaitingTick = true;
            new MethodHandleLevelAction(SerializableMethodHandle.create(PartEntityRedstoneTorch.class, (String)"tickRedstoneTorch", null, (Object[])new Object[]{sl.m_46472_(), this.pos()})).delay(2).enqueue(sl);
        }
    }

    protected void scheduledTick() {
        this.awaitingTick = false;
        if (!this.isAddedToWorld() || this.container.level == null) {
            return;
        }
        Level pLevel = this.container.level;
        BlockPos pPos = this.container.pos;
        boolean neighborSignal = this.hasNeighborSignal(pLevel, pPos);
        List<Toggle> list = this.recentToggles;
        while (list != null && !list.isEmpty() && pLevel.m_46467_() - list.get((int)0).when > 60L) {
            list.remove(0);
        }
        if (this.lit) {
            if (neighborSignal) {
                this.lit = false;
                if (this.isToggledTooFrequently(pLevel, true)) {
                    pLevel.m_46796_(1502, pPos, 0);
                    pLevel.m_186460_(pPos, pLevel.m_8055_(pPos).m_60734_(), 160);
                }
            }
        } else if (!neighborSignal && !this.isToggledTooFrequently(pLevel, false)) {
            this.lit = true;
        }
        this.container.updateRedstone();
        this.container.owner.syncContainer(true);
    }

    private boolean isToggledTooFrequently(Level level, boolean pLogToggle) {
        List<Toggle> list = this.recentToggles;
        if (pLogToggle) {
            list.add(new Toggle(level.m_46467_()));
        }
        int i = 0;
        for (int j = 0; j < list.size(); ++j) {
            if (++i < 8) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getLightEmission() {
        return this.lit ? 7 : 0;
    }

    protected boolean hasNeighborSignal(Level pLevel, BlockPos pPos) {
        Direction dir = this.placement.getDirection();
        if (dir == null || dir == Direction.DOWN) {
            return pLevel.m_276987_(pPos.m_7495_(), Direction.DOWN);
        }
        return pLevel.m_276987_(pPos.m_121945_(dir), dir);
    }

    @Override
    public int getStrongSignal(Direction towards) {
        return towards == Direction.DOWN ? this.getWeakSignal(towards) : 0;
    }

    @Override
    public int getWeakSignal(Direction towards) {
        Direction dir = this.placement.getDirection();
        if (dir == null) {
            return 0;
        }
        return this.lit && dir.m_122424_() != towards ? 15 : 0;
    }

    @Override
    public boolean canConnectRedstone(@Nullable Direction direction) {
        return true;
    }

    @Override
    @Nullable
    public BlockState getRenderState() {
        Direction dir = this.placement.getDirection();
        if (dir == null || dir == Direction.DOWN) {
            return (BlockState)Blocks.f_50174_.m_49966_().m_61124_((Property)RedstoneTorchBlock.f_55674_, (Comparable)Boolean.valueOf(this.lit));
        }
        if (dir.m_122434_() == Direction.Axis.Y) {
            return null;
        }
        return (BlockState)((BlockState)Blocks.f_50123_.m_49966_().m_61124_((Property)RedstoneWallTorchBlock.f_55740_, (Comparable)this.placement.getDirection().m_122424_())).m_61124_((Property)RedstoneTorchBlock.f_55674_, (Comparable)Boolean.valueOf(this.lit));
    }

    @Override
    public boolean isViewBlocking() {
        return false;
    }

    @Override
    public boolean isRedstoneSource() {
        return true;
    }

    @ExposedToLevelAction
    public static void tickRedstoneTorch(ResourceKey<Level> dimension, PartPos part) {
        ServerLevel level = LogicalSidePredictor.getLevel(dimension);
        if (level == null) {
            return;
        }
        PartEntityRedstoneTorch torch = part.getOfType((Level)level, PartEntityRedstoneTorch.class);
        if (!torch.isAddedToWorld()) {
            torch.setAddedToWorld(true);
        }
        if (torch.container.level == null) {
            torch.container.level = level;
        }
        if (torch != null) {
            torch.scheduledTick();
        }
    }

    public static class Toggle {
        final long when;

        public Toggle(long pWhen) {
            this.when = pWhen;
        }
    }
}

