/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.impl.parts.entities;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.api.io.NBTSerializable;
import org.zeith.hammerlib.util.java.tuples.Tuple2;
import org.zeith.hammerlib.util.java.tuples.Tuples;
import org.zeith.multipart.api.PartContainer;
import org.zeith.multipart.api.PartDefinition;
import org.zeith.multipart.api.PartEntity;
import org.zeith.multipart.api.placement.PartPlacement;

public class PartEntityChain
extends PartEntity {
    @NBTSerializable(value="Axis")
    public Direction.Axis axis = Direction.Axis.Y;
    protected static final VoxelShape Y_AXIS_AABB = Block.m_49796_((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5);
    protected static final VoxelShape Z_AXIS_AABB = Block.m_49796_((double)6.5, (double)6.5, (double)0.0, (double)9.5, (double)9.5, (double)16.0);
    protected static final VoxelShape X_AXIS_AABB = Block.m_49796_((double)0.0, (double)6.5, (double)6.5, (double)16.0, (double)9.5, (double)9.5);

    public PartEntityChain(PartDefinition definition, PartContainer container, PartPlacement placement) {
        super(definition, container, placement);
    }

    @Override
    public List<ItemStack> getDrops(@Nullable ServerPlayer harvester, LootParams.Builder drops) {
        return Blocks.f_50184_.m_49635_(Blocks.f_50184_.m_49966_(), drops);
    }

    @Override
    protected VoxelShape updateShape() {
        if (this.axis == null) {
            return Y_AXIS_AABB;
        }
        return switch (this.axis) {
            case Direction.Axis.X -> X_AXIS_AABB;
            case Direction.Axis.Y -> Y_AXIS_AABB;
            case Direction.Axis.Z -> Z_AXIS_AABB;
            default -> Y_AXIS_AABB;
        };
    }

    @Override
    public VoxelShape getPartOccupiedShape() {
        return this.getShape();
    }

    @Override
    public Optional<Tuple2<BlockState, Function<BlockPos, BlockEntity>>> disassemblePart() {
        return Optional.of(Tuples.immutable((Object)((BlockState)this.getRenderState().m_61124_((Property)ChainBlock.f_51446_, (Comparable)Boolean.valueOf(this.container.waterlogged))), null));
    }

    @Override
    public void neighborChanged(@Nullable Direction from, BlockPos neigborPos, BlockState neigborState, boolean waterlogged) {
        super.neighborChanged(from, neigborPos, neigborState, waterlogged);
        if (this.axis == null) {
            this.container.queuePartRemoval(this.placement, true, true, true);
        }
    }

    @Override
    @Nullable
    public BlockState getRenderState() {
        if (this.axis == null) {
            return null;
        }
        return (BlockState)Blocks.f_50184_.m_49966_().m_61124_((Property)ChainBlock.f_55923_, (Comparable)this.axis);
    }

    @Override
    public boolean isViewBlocking() {
        return false;
    }
}

