/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.impl.parts;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import org.zeith.multipart.api.PartContainer;
import org.zeith.multipart.api.PartDefinition;
import org.zeith.multipart.api.PartEntity;
import org.zeith.multipart.api.placement.IConfiguredPartPlacer;
import org.zeith.multipart.api.placement.PartPlacement;
import org.zeith.multipart.api.placement.PlacedPartConfiguration;
import org.zeith.multipart.impl.parts.entities.PartEntityRedstoneTorch;
import org.zeith.multipart.init.PartPlacementsHM;

public class PartDefRedstoneTorch
extends PartDefinition {
    public PartDefRedstoneTorch() {
        this.model.addParticleIcon(new ResourceLocation("block/redstone_torch"));
        this.soundType = SoundType.f_56736_;
        this.destroySpeed = 1.0E-4f;
        this.survivesInWater = false;
        this.cloneItem = () -> ((Item)Items.f_41978_).m_7968_();
    }

    public Optional<PlacedPartConfiguration> getPlacement(Level level, BlockPos pos, Player player, ItemStack stack, BlockHitResult hit) {
        Direction towards = hit.m_82434_().m_122424_();
        BlockPos offPos = pos.m_121945_(towards);
        if (level.m_8055_(offPos).m_60783_((BlockGetter)level, offPos, hit.m_82434_())) {
            return Optional.of(new PlacedPartConfiguration(this, PartPlacementsHM.SIDED_PLACEMENT.apply(towards)));
        }
        return Optional.empty();
    }

    @Override
    public Optional<PlacedPartConfiguration> convertBlockToPart(Level level, BlockPos pos, BlockState state) {
        if (state.m_60713_(Blocks.f_50174_)) {
            return Optional.of(new PlacedPartConfiguration(this, PartPlacementsHM.DOWN));
        }
        if (state.m_60713_(Blocks.f_50123_)) {
            return Optional.of(new PlacedPartConfiguration(this, PartPlacementsHM.SIDED_PLACEMENT.apply(((Direction)state.m_61143_((Property)RedstoneWallTorchBlock.f_55740_)).m_122424_())));
        }
        return Optional.empty();
    }

    @Override
    public boolean canPlaceAt(PartContainer container, @Nullable IConfiguredPartPlacer placer, PartPlacement placement) {
        Direction towards = placement.getDirection();
        if (towards == null || towards == Direction.UP) {
            return false;
        }
        if (PartPlacementsHM.SIDED_PLACEMENT.apply(towards) != placement) {
            return false;
        }
        if (container.waterlogged) {
            return false;
        }
        BlockPos pos = container.pos().m_121945_(towards);
        BlockState blockstate = container.level().m_8055_(pos);
        return blockstate.m_60783_((BlockGetter)container.level(), pos, towards.m_122424_());
    }

    @Override
    public PartEntity createEntity(PartContainer container, PartPlacement placement) {
        return new PartEntityRedstoneTorch(this, container, placement);
    }
}

