/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.client.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.multipart.api.PartEntity;

public class BakedPartDefinitionModel {
    public final Map<ResourceLocation, TextureAtlasSprite> allParticles;
    public final Map<ResourceLocation, BakedModel> allModels;

    public BakedPartDefinitionModel(Map<ResourceLocation, TextureAtlasSprite> allParticles, Map<ResourceLocation, BakedModel> allModels) {
        this.allParticles = allParticles;
        this.allModels = allModels;
    }

    public List<TextureAtlasSprite> getParticleIconsFor(PartEntity entity) {
        return entity.getParticleIcons(this.allParticles.keySet()).stream().map(this.allParticles::get).filter(Objects::nonNull).toList();
    }

    public Map<ResourceLocation, TextureAtlasSprite> getAllParticles() {
        return this.allParticles;
    }

    public Map<ResourceLocation, BakedModel> getAllModels() {
        return this.allModels;
    }

    public void getQuads(PartEntity part, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType, Consumer<BakedQuad> quadList) {
        ModelManager mm = Minecraft.m_91087_().m_91304_();
        BlockState renderState = part.getRenderState();
        if (renderState != null) {
            BakedModel model = mm.m_119430_().m_110893_(renderState);
            if (renderType == null || model.getRenderTypes(renderState, rand, data).contains(renderType)) {
                model.getQuads(renderState, side, rand, data, renderType).forEach(quadList);
            }
        }
        renderState = Blocks.f_50016_.m_49966_();
        for (ResourceLocation mloc : part.getRenderModels()) {
            BakedModel model = this.getModel(mloc);
            if (renderType != null && !model.getRenderTypes(renderState, rand, data).contains(renderType)) continue;
            model.getQuads(renderState, side, rand, data, renderType).forEach(quadList);
        }
    }

    public TextureAtlasSprite getTexture(ResourceLocation texture) {
        TextureAtlasSprite v = this.allParticles.get(texture);
        if (v == null) {
            return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(MissingTextureAtlasSprite.m_118071_());
        }
        return v;
    }

    public BakedModel getModel(ResourceLocation model) {
        BakedModel mod = this.allModels.get(model);
        if (mod == null) {
            return Minecraft.m_91087_().m_91304_().getModel(model);
        }
        return mod;
    }
}

