/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.blocks;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.api.forge.BlockAPI;
import org.zeith.hammerlib.api.forge.ContainerAPI;
import org.zeith.hammerlib.api.tiles.IContainerTile;
import org.zeith.hammerlib.tiles.TileSyncableTickable;
import org.zeith.hammerlib.util.java.tuples.Tuple2;
import org.zeith.multipart.api.IPartContainerTile;
import org.zeith.multipart.api.PartContainer;
import org.zeith.multipart.api.PartEntity;
import org.zeith.multipart.blocks.BlockMultipartContainer;

public class TileMultipartContainer
extends TileSyncableTickable
implements IContainerTile,
IPartContainerTile {
    public final PartContainer container;
    protected long prevHash;
    protected boolean isUpdatingLogic = false;
    protected boolean hasReceivedUpdateTag = false;
    private final int[] weakRedstones = new int[6];
    private final int[] strongRedstones = new int[6];
    protected long lastSyncGT;

    public TileMultipartContainer(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.container = new PartContainer(pos.m_7949_(), this);
    }

    @Override
    public void openContainer(Player player) {
        ContainerAPI.openContainerTile((Player)player, (BlockEntity)this);
    }

    public AbstractContainerMenu openContainer(Player player, int windowId) {
        BlockHitResult hit = BlockMultipartContainer.getPlayerPOVHitResult((BlockGetter)this.f_58857_, player, ClipContext.Fluid.NONE);
        if (hit.m_6662_() != HitResult.Type.BLOCK) {
            return null;
        }
        return this.container.selectPart(hit.m_82450_()).map(e -> ((PartEntity)e.getValue()).openContainer(player, windowId)).orElse(null);
    }

    public void serverTick() {
        this.container.tickServer();
        if (this.container.causeBlockUpdate) {
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
            BlockAPI.sendBlockUpdate((Level)this.f_58857_, (BlockPos)this.f_58858_);
            this.container.causeBlockUpdate = false;
        }
    }

    public void clientTick() {
        this.container.tickClient();
        this.container.needsSync = false;
    }

    protected void refreshHash() {
        long hash = this.container.calcPartsHash();
        if (hash != this.prevHash) {
            this.prevHash = hash;
            this.container.recalcTintLayers(hash);
            this.container.updateLightLevel();
            this.container.causeBlockUpdate = true;
        }
    }

    public boolean updateLogic(boolean server) {
        if (this.isUpdatingLogic) {
            return false;
        }
        this.isUpdatingLogic = true;
        this.container.level = this.f_58857_;
        this.container.waterlogged = this.m_58900_().m_61145_((Property)BlockStateProperties.f_61362_).orElse(false);
        if (this.tryDisassemble()) {
            return true;
        }
        if (this.container.causeBlockUpdate || this.container.needsSync) {
            this.refreshHash();
        }
        if (this.container.causeRedstoneUpdate) {
            this.updatePowerStrength();
        }
        if (this.container.causeBlockUpdate && server) {
            BlockState st;
            boolean isSource = this.container.parts().stream().anyMatch(PartEntity::isRedstoneSource);
            int light = Mth.m_14045_((int)this.container.parts().stream().mapToInt(PartEntity::getLightEmission).max().orElse(0), (int)0, (int)15);
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)((BlockState)((BlockState)st.m_61124_((Property)BlockMultipartContainer.ALT, (Comparable)Boolean.valueOf((Boolean)(st = this.f_58857_.m_8055_(this.f_58858_)).m_61143_((Property)BlockMultipartContainer.ALT) == false))).m_61124_((Property)BlockMultipartContainer.REDSTONE_SOURCE, (Comparable)Boolean.valueOf(isSource))).m_61124_((Property)BlockMultipartContainer.LIGHT_LEVEL, (Comparable)Integer.valueOf(light)));
            this.f_58857_.m_46672_(this.f_58858_, st.m_60734_());
            BlockAPI.sendBlockUpdate((Level)this.f_58857_, (BlockPos)this.f_58858_);
        }
        if (this.container.needsSync && server) {
            this.sync();
        }
        this.container.causeRedstoneUpdate = false;
        this.container.causeBlockUpdate = false;
        this.container.needsSync = false;
        this.setLightLevel(this.container.lightLevel);
        this.isUpdatingLogic = false;
        return false;
    }

    public boolean tryDisassemble() {
        Collection<PartEntity> ps = this.container.parts();
        if (ps.size() == 1) {
            PartEntity part = ps.iterator().next();
            Optional<Tuple2<BlockState, Function<BlockPos, BlockEntity>>> simple = part.disassemblePart();
            if (simple.isPresent()) {
                simple.ifPresent(tup -> {
                    this.updateRedstoneNeighbors();
                    this.f_58857_.m_46597_(this.f_58858_, (BlockState)tup.a());
                    Function tile = (Function)tup.b();
                    if (tile != null) {
                        this.f_58857_.m_151523_((BlockEntity)tile.apply(this.f_58858_));
                    }
                });
                return true;
            }
        } else if (ps.isEmpty()) {
            this.f_58857_.m_7471_(this.f_58858_, false);
            this.updateRedstoneNeighbors();
            return true;
        }
        return false;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.container.onChunkUnloaded();
    }

    public void onLoad() {
        super.onLoad();
        this.container.level = this.f_58857_;
        this.container.onLoad();
        this.container.refreshTicking();
        this.setLightLevel(this.container.lightLevel);
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        if (!this.hasReceivedUpdateTag && this.isOnClient()) {
            this.container.causeBlockUpdate = true;
            this.updateLogic(false);
            this.hasReceivedUpdateTag = true;
        }
    }

    public long getHash() {
        return this.prevHash;
    }

    public void setLightLevel(int light) {
        light = Mth.m_14045_((int)light, (int)0, (int)15);
        boolean ticking = this.container.isTicking();
        IntegerProperty prop = BlockMultipartContainer.LIGHT_LEVEL;
        BooleanProperty prop2 = BlockMultipartContainer.TICKING;
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)prop) && state.m_61138_((Property)prop2) && (!Objects.equals(state.m_61143_((Property)prop), light) || !Objects.equals(state.m_61143_((Property)prop2), ticking))) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)((BlockState)state.m_61124_((Property)prop, (Comparable)Integer.valueOf(light))).m_61124_((Property)prop2, (Comparable)Boolean.valueOf(ticking)));
        }
    }

    public void updatePowerStrength() {
        boolean upd = false;
        for (int i = 0; i < 6; ++i) {
            if (this.weakRedstones[i] != this.container.weakRedstoneSignals[i]) {
                this.weakRedstones[i] = this.container.weakRedstoneSignals[i];
                upd = true;
                break;
            }
            if (this.strongRedstones[i] == this.container.strongRedstoneSignals[i]) continue;
            this.strongRedstones[i] = this.container.strongRedstoneSignals[i];
            upd = true;
            break;
        }
        if (upd) {
            this.updateRedstoneNeighbors();
        }
        this.container.causeRedstoneUpdate = false;
    }

    public void updateRedstoneNeighbors() {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_46672_(this.f_58858_, state.m_60734_());
        for (Direction direction : Direction.values()) {
            this.f_58857_.m_46672_(this.f_58858_.m_121945_(direction), state.m_60734_());
        }
    }

    public CompoundTag writeNBT(CompoundTag nbt) {
        CompoundTag res = this.container.serializeNBT();
        return nbt.m_128456_() ? res : nbt.m_128391_(res);
    }

    public void readNBT(CompoundTag nbt) {
        this.container.deserializeNBT(nbt);
        if (this.m_58898_() && this.isOnClient()) {
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
            BlockAPI.sendBlockUpdate((Level)this.f_58857_, (BlockPos)this.f_58858_);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        LazyOptional<T> c = this.container.getCapability(cap, side);
        if (c.isPresent()) {
            return c;
        }
        return super.getCapability(cap, side);
    }

    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with(PartContainer.CONTAINER_PROP, (Object)this.container).with(PartContainer.PART_HASH, (Object)this.prevHash).build();
    }

    @Override
    public PartContainer getContainer() {
        return this.container;
    }

    @Override
    public void syncContainer(boolean force) {
        long gt;
        long l = gt = this.f_58857_ != null ? this.f_58857_.m_46467_() : -125L;
        if (this.lastSyncGT == gt && !force) {
            return;
        }
        this.lastSyncGT = gt;
        this.container.needsSync = true;
        this.container.removePendingParts();
        if (this.tryDisassemble()) {
            return;
        }
        this.sync();
        this.refreshHash();
        this.updateLogic(this.isOnServer());
        this.container.waterlogged = this.m_58900_().m_61145_((Property)BlockStateProperties.f_61362_).orElse(false);
        this.container.needsSync = false;
    }
}

