/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.blocks;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.api.blocks.INoItemBlock;
import org.zeith.hammerlib.api.forge.BlockAPI;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.net.packets.PacketRequestTileSync;
import org.zeith.hammerlib.util.SidedLocal;
import org.zeith.hammerlib.util.java.consumers.Consumer2;
import org.zeith.hammerlib.util.java.functions.Function2;
import org.zeith.multipart.api.PartContainer;
import org.zeith.multipart.api.PartEntity;
import org.zeith.multipart.api.WorldPartComponents;
import org.zeith.multipart.api.item.IMultipartPlacerItem;
import org.zeith.multipart.api.placement.PartPlacement;
import org.zeith.multipart.api.placement.PlacedPartConfiguration;
import org.zeith.multipart.blocks.TileMultipartContainer;
import org.zeith.multipart.client.MultipartEffects;
import org.zeith.multipart.init.PartRegistries;
import org.zeith.multipart.mixins.UseOnContextAccessor;
import org.zeith.multipart.net.PacketSendLandingEffect;
import org.zeith.multipart.net.PacketSendRunningEffect;

public class BlockMultipartContainer
extends BaseEntityBlock
implements INoItemBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty ALT = BooleanProperty.m_61465_((String)"alt");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty REDSTONE_SOURCE = BooleanProperty.m_61465_((String)"redstone_source");
    public static final IntegerProperty LIGHT_LEVEL = IntegerProperty.m_61631_((String)"light", (int)0, (int)15);
    public static final BooleanProperty TICKING = BooleanProperty.m_61465_((String)"ticking");
    protected final SidedLocal<Map<LevelAccessor, Set<BlockPos>>> activePlacers = SidedLocal.initializeForBoth(WeakHashMap::new);
    public VoxelShape renderShape;

    public BlockMultipartContainer() {
        super(BlockBehaviour.Properties.m_284310_().m_280574_().m_60988_().m_60955_().m_60953_(s -> (Integer)s.m_61143_((Property)LIGHT_LEVEL)));
        BlockState defState = (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)REDSTONE_SOURCE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)TICKING, (Comparable)Boolean.valueOf(false));
        this.m_49959_(defState);
        MinecraftForge.EVENT_BUS.addListener(this::clickWithItem);
    }

    public <T extends LevelAccessor> void safePlace(T level, BlockPos pos, Consumer2<T, BlockPos> placer) {
        pos = pos.m_7949_();
        Set<BlockPos> action = this.startSafePlace(level, pos);
        placer.accept(level, (Object)pos);
        this.endSafePlace(action, pos);
    }

    public <T extends LevelAccessor, R> R safePlace(T level, BlockPos pos, Function2<T, BlockPos, R> placer) {
        pos = pos.m_7949_();
        Set<BlockPos> action = this.startSafePlace(level, pos);
        Object res = placer.apply(level, (Object)pos);
        this.endSafePlace(action, pos);
        return (R)res;
    }

    private Set<BlockPos> startSafePlace(LevelAccessor level, BlockPos pos) {
        pos = pos.m_7949_();
        Map placers = (Map)this.activePlacers.get(level.m_5776_() ? LogicalSide.CLIENT : LogicalSide.SERVER);
        Set plc = placers.computeIfAbsent(level, l -> new HashSet());
        plc.add(pos);
        return plc;
    }

    private void endSafePlace(Set<BlockPos> action, BlockPos pos) {
        action.remove(pos);
    }

    public BlockState defaultBlockState(BlockGetter level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        FluidState fs = level.m_6425_(pos);
        if (state.m_60713_((Block)this)) {
            return state;
        }
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fs.m_76152_() == Fluids.f_76193_));
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        PartContainer pc = null;
        BlockEntity be = (BlockEntity)params.m_287159_(LootContextParams.f_81462_);
        if (be instanceof TileMultipartContainer) {
            TileMultipartContainer tmc = (TileMultipartContainer)be;
            pc = tmc.container;
        } else {
            ServerLevel level = params.m_287258_();
            Vec3 posVec = (Vec3)params.m_287261_(LootContextParams.f_81460_);
            BlockPos pos = new BlockPos((int)posVec.f_82479_, (int)posVec.f_82480_, (int)posVec.f_82481_);
            pc = BlockMultipartContainer.pc((BlockGetter)level, pos);
        }
        if (pc != null) {
            ServerPlayer sp;
            Object object = params.m_287159_(LootContextParams.f_81455_);
            ServerPlayer player = object instanceof ServerPlayer ? (sp = (ServerPlayer)object) : null;
            return pc.parts().stream().map(part -> part.getDrops(player, params)).flatMap(Collection::stream).toList();
        }
        return List.of();
    }

    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fs) {
        boolean ok = super.m_7361_(level, pos, state, fs);
        PartContainer pc = BlockMultipartContainer.pc((BlockGetter)level, pos);
        if (pc != null) {
            pc.neighborChanged(Direction.UP, pos, state, level.m_8055_(pos).m_61145_((Property)WATERLOGGED).orElse(false));
        }
        return ok;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> b) {
        b.m_61104_(new Property[]{LIGHT_LEVEL, REDSTONE_SOURCE, ALT, WATERLOGGED, TICKING});
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blk, BlockPos from, boolean p_60514_) {
        super.m_6861_(state, level, pos, blk, from, p_60514_);
        if (blk != this) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (!(blockEntity instanceof TileMultipartContainer)) {
                return;
            }
            TileMultipartContainer tpc = (TileMultipartContainer)blockEntity;
            Map placers = (Map)this.activePlacers.get(level.m_5776_() ? LogicalSide.CLIENT : LogicalSide.SERVER);
            if (placers.getOrDefault(level, Set.of()).contains(pos)) {
                return;
            }
            tpc.container.neighborChanged(null, from, level.m_8055_(from), (Boolean)state.m_61143_((Property)WATERLOGGED));
            tpc.updateLogic(!level.m_5776_());
        }
    }

    public BlockState m_7417_(BlockState ourState, Direction direction, BlockState neigborState, LevelAccessor accessor, BlockPos pos, BlockPos neigborPos) {
        BlockEntity blockEntity;
        if (((Boolean)ourState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            accessor.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)accessor));
        }
        if (!((blockEntity = accessor.m_7702_(pos)) instanceof TileMultipartContainer)) {
            return ourState;
        }
        TileMultipartContainer tpc = (TileMultipartContainer)blockEntity;
        Map placers = (Map)this.activePlacers.get(accessor.m_5776_() ? LogicalSide.CLIENT : LogicalSide.SERVER);
        if (placers.getOrDefault(accessor, Set.of()).contains(pos)) {
            return ourState;
        }
        PartContainer pc = tpc.container;
        if (pc == null) {
            return ourState;
        }
        if (pc.level == null && tpc.m_58898_()) {
            pc.level = tpc.m_58904_();
        }
        pc.neighborChanged(direction, neigborPos, neigborState, (Boolean)ourState.m_61143_((Property)WATERLOGGED));
        pc.refreshTicking();
        tpc.updateLogic(!accessor.m_5776_());
        pc.resetShapes();
        tpc.sync();
        return (BlockState)ourState.m_61124_((Property)TICKING, (Comparable)Boolean.valueOf(pc.isTicking()));
    }

    public float m_5880_(BlockState state, Player player, BlockGetter get, BlockPos pos) {
        float f;
        PartContainer pc = BlockMultipartContainer.pc(get, pos);
        if (pc == null) {
            return 10.0f;
        }
        BlockHitResult hit = BlockMultipartContainer.getPlayerPOVHitResult(get, player, ClipContext.Fluid.NONE);
        if (hit.m_6662_() != HitResult.Type.BLOCK) {
            return 10.0f;
        }
        Optional<Map.Entry<PartPlacement, PartEntity>> part = pc.selectPart(hit.m_82450_());
        if (part.isEmpty()) {
            return 10.0f;
        }
        Map.Entry<PartPlacement, PartEntity> e = part.orElseThrow();
        BlockState rs = e.getValue().getHardnessState();
        if (rs != null) {
            state = rs;
        }
        if ((f = e.getValue().getDestroySpeed(player)) == -1.0f) {
            return 0.0f;
        }
        if (f == 0.0f) {
            return 1.0f;
        }
        int i = e.getValue().isCorrectToolForDrops(player) ? 30 : 100;
        return player.getDigSpeed(state, pos) / f / (float)i;
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        PartContainer pc = BlockMultipartContainer.pc((BlockGetter)level, pos);
        if (pc == null || !(entity instanceof Player)) {
            return SoundType.f_56742_;
        }
        Player player = (Player)entity;
        BlockHitResult hit = BlockMultipartContainer.getPlayerPOVHitResult((BlockGetter)level, player, ClipContext.Fluid.NONE);
        if (hit.m_6662_() != HitResult.Type.BLOCK) {
            return SoundType.f_56742_;
        }
        Map.Entry pe = pc.selectPart(hit.m_82450_()).orElse(null);
        if (pe == null) {
            return SoundType.f_56742_;
        }
        return ((PartEntity)pe.getValue()).definition().getSoundType((PartEntity)pe.getValue());
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        PartContainer pc = BlockMultipartContainer.pc((BlockGetter)level, pos);
        if (pc == null) {
            if (level.m_5776_()) {
                Network.sendToServer((IPacket)new PacketRequestTileSync(pos));
            }
            return false;
        }
        BlockHitResult hit = BlockMultipartContainer.getPlayerPOVHitResult((BlockGetter)level, player, ClipContext.Fluid.NONE);
        if (hit.m_6662_() != HitResult.Type.BLOCK) {
            if (level.m_5776_()) {
                Network.sendToServer((IPacket)new PacketRequestTileSync(pos));
            }
            return false;
        }
        if (!hit.m_82425_().equals((Object)pos)) {
            if (level.m_5776_()) {
                Network.sendToServer((IPacket)new PacketRequestTileSync(pos));
            }
            return false;
        }
        Map.Entry pe = pc.selectPart(hit.m_82450_()).orElse(null);
        if (pe == null) {
            if (level.m_5776_()) {
                Network.sendToServer((IPacket)new PacketRequestTileSync(pos));
            }
            return false;
        }
        pc.breakPart(player, willHarvest, (PartPlacement)pe.getKey());
        if (level.m_5776_()) {
            HammerLib.PROXY.queueTask(level, 2, () -> Network.sendToServer((IPacket)new PacketRequestTileSync(pos)));
        }
        return false;
    }

    public static PartContainer pc(BlockGetter get, BlockPos pos) {
        BlockEntity blockEntity;
        if (get != null && (blockEntity = get.m_7702_(pos)) instanceof TileMultipartContainer) {
            Level l;
            TileMultipartContainer ctr = (TileMultipartContainer)blockEntity;
            ctr.container.level = get instanceof Level ? (l = (Level)get) : ctr.m_58904_();
            return ctr.container;
        }
        return null;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        PartContainer pc = BlockMultipartContainer.pc((BlockGetter)level, pos);
        if (pc == null) {
            return;
        }
        for (PartEntity p : pc.parts()) {
            p.animateTick(random);
        }
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext ctx) {
        Player player;
        BlockHitResult res;
        EntityCollisionContext ec;
        Entity entity;
        PartContainer pc = BlockMultipartContainer.pc(getter, pos);
        if (pc != null && ctx instanceof EntityCollisionContext && (entity = (ec = (EntityCollisionContext)ctx).m_193113_()) instanceof Player && (res = BlockMultipartContainer.getPlayerPOVHitResult(getter, player = (Player)entity, ClipContext.Fluid.NONE)).m_6662_() != HitResult.Type.MISS) {
            return pc.selectPart(res.m_82450_()).map(e -> ((PartEntity)e.getValue()).getShape()).orElseGet(Shapes::m_83040_);
        }
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext ctx) {
        if (this.renderShape != null) {
            VoxelShape s = this.renderShape;
            this.renderShape = null;
            return s;
        }
        PartContainer pc = BlockMultipartContainer.pc(getter, pos);
        if (pc != null) {
            return pc.getShape();
        }
        return Shapes.m_83040_();
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext ctx) {
        PartContainer pc = BlockMultipartContainer.pc(getter, pos);
        if (pc != null) {
            return pc.getCollisionShape();
        }
        return Shapes.m_83040_();
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        PartContainer pc = BlockMultipartContainer.pc((BlockGetter)level, pos);
        if (pc == null) {
            return InteractionResult.PASS;
        }
        return pc.selectPart(hit.m_82450_()).map(Map.Entry::getValue).map(ent -> ent.use(player, hand, hit, ent.getSelectionShape(player, hit))).orElse(InteractionResult.PASS);
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        BlockHitResult res;
        PartContainer pc = BlockMultipartContainer.pc((BlockGetter)level, pos);
        if (pc != null && (res = BlockMultipartContainer.getPlayerPOVHitResult((BlockGetter)level, player, ClipContext.Fluid.NONE)).m_6662_() != HitResult.Type.MISS) {
            pc.selectPart(res.m_82450_()).map(Map.Entry::getValue).ifPresent(e -> e.attack(player, res, e.getSelectionShape(player, res)));
        }
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        PartContainer pc = BlockMultipartContainer.pc((BlockGetter)level, pos);
        if (pc == null) {
            return;
        }
        for (PartEntity part : pc.parts()) {
            part.stepOn(entity);
        }
    }

    public boolean makesOpenTrapdoorAboveClimbable(BlockState state, LevelReader level, BlockPos pos, BlockState trapdoorState) {
        PartContainer pc = BlockMultipartContainer.pc((BlockGetter)level, pos);
        if (pc == null) {
            return false;
        }
        return pc.parts().stream().anyMatch(part -> part.makesOpenTrapdoorAboveClimbable(trapdoorState));
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        PartContainer pc = BlockMultipartContainer.pc((BlockGetter)level, pos);
        if (pc == null) {
            return false;
        }
        return pc.parts().stream().anyMatch(part -> part.isLadder(entity));
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        PartContainer pc = BlockMultipartContainer.pc(level, pos);
        if (pc == null) {
            return false;
        }
        return pc.parts().stream().anyMatch(part -> part.canHarvestPart(player));
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        PartContainer pc = BlockMultipartContainer.pc(level, pos);
        if (pc == null) {
            return false;
        }
        return pc.parts().stream().anyMatch(part -> part.canConnectRedstone(direction)) || this.m_7899_(state) && direction != null;
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        PartContainer pc = BlockMultipartContainer.pc((BlockGetter)level, pos);
        if (pc == null) {
            return state;
        }
        for (PartEntity part : pc.parts()) {
            BlockState st = part.getAppearance(state, side, queryState, queryPos);
            if (st == null) continue;
            return st;
        }
        return state;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        PartContainer pc = BlockMultipartContainer.pc(level, pos);
        if (pc != null && target instanceof BlockHitResult) {
            BlockHitResult res = (BlockHitResult)target;
            return pc.selectPart(res.m_82450_()).map(Map.Entry::getValue).map(e -> e.getCloneItemStack(res, player, e.getSelectionShape(player, res))).orElse(ItemStack.f_41583_);
        }
        return ItemStack.f_41583_;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return WorldPartComponents.TILE_TYPE.m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return (Boolean)state.m_61143_((Property)TICKING) != false ? BlockAPI.ticker((Level)level) : null;
    }

    public boolean m_7899_(BlockState state) {
        return (Boolean)state.m_61143_((Property)REDSTONE_SOURCE);
    }

    public int m_6378_(BlockState state, BlockGetter get, BlockPos pos, Direction dir) {
        PartContainer pc = BlockMultipartContainer.pc(get, pos);
        if (pc == null) {
            return 0;
        }
        return pc.weakRedstoneSignals[dir.ordinal()];
    }

    public int m_6376_(BlockState state, BlockGetter get, BlockPos pos, Direction dir) {
        PartContainer pc = BlockMultipartContainer.pc(get, pos);
        if (pc == null) {
            return 0;
        }
        return pc.strongRedstoneSignals[dir.ordinal()];
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        Network.sendToTracking((LevelChunk)level.m_46745_(pos), (IPacket)new PacketSendLandingEffect(pos, numberOfParticles, entity));
        return true;
    }

    public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.m_5776_()) {
            Network.sendToTracking((LevelChunk)level.m_46745_(pos), (IPacket)new PacketSendRunningEffect(pos, entity));
        }
        return true;
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new IClientBlockExtensions(){

            public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine manager) {
                if (target instanceof BlockHitResult) {
                    BlockHitResult hit = (BlockHitResult)target;
                    PartContainer pc = BlockMultipartContainer.pc((BlockGetter)level, hit.m_82425_());
                    if (pc == null) {
                        return true;
                    }
                    Optional<Map.Entry<PartPlacement, PartEntity>> part = pc.selectPart(hit.m_82450_());
                    if (part.isEmpty()) {
                        return true;
                    }
                    Map.Entry<PartPlacement, PartEntity> pe = part.orElseThrow();
                    MultipartEffects.spawnHitFX(pe.getValue(), hit);
                }
                return true;
            }

            public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine manager) {
                PartContainer pc = BlockMultipartContainer.pc((BlockGetter)level, pos);
                if (pc != null) {
                    for (PartEntity part : pc.parts()) {
                        MultipartEffects.spawnBreakFX(part);
                    }
                }
                return true;
            }
        });
    }

    public Optional<InteractionResult> useItem(UseOnContext context) {
        return this.performPlaceAction(((UseOnContextAccessor)context).getHitResult(), context.m_43725_(), context.m_43723_(), context.m_43724_());
    }

    protected void clickWithItem(PlayerInteractEvent.RightClickItem e) {
        BlockHitResult hit = BlockMultipartContainer.getPlayerPOVHitResult((BlockGetter)e.getLevel(), e.getEntity(), ClipContext.Fluid.NONE);
        if (hit.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        this.performPlaceAction(hit, e.getLevel(), e.getEntity(), e.getHand());
    }

    protected Optional<InteractionResult> performPlaceAction(BlockHitResult hit, Level level, Player player, InteractionHand hand) {
        block26: {
            BlockEntity blockEntity;
            Boolean hasWater;
            PlacedPartConfiguration feature;
            ItemStack held;
            boolean isFallback;
            IMultipartPlacerItem it;
            PartContainer pc;
            boolean air;
            BlockPos placePos;
            block27: {
                Optional<PartEntity> sim;
                PartContainer pc0;
                block28: {
                    double desired;
                    VoxelShape selShape;
                    Item item;
                    if (player == null) {
                        return Optional.empty();
                    }
                    placePos = hit.m_82425_().m_7949_();
                    air = level.m_8055_(placePos).m_60629_(new BlockPlaceContext(player, hand, player.m_21120_(hand), hit));
                    BlockPos place0Pos = placePos;
                    pc0 = BlockMultipartContainer.pc((BlockGetter)level, placePos);
                    if (!air) {
                        air = level.m_8055_(placePos = placePos.m_121945_(hit.m_82434_())).m_60629_(new BlockPlaceContext(player, hand, player.m_21120_(hand), hit)) || level.m_8055_(placePos).m_60713_(Blocks.f_49990_);
                    }
                    pc = BlockMultipartContainer.pc((BlockGetter)level, placePos);
                    it = null;
                    isFallback = false;
                    held = player.m_21120_(hand);
                    if (!held.m_41619_() && (item = held.m_41720_()) instanceof IMultipartPlacerItem) {
                        IMultipartPlacerItem it0;
                        it = it0 = (IMultipartPlacerItem)item;
                    } else if (!held.m_41619_()) {
                        it = PartRegistries.getFallbackPlacer(held.m_41720_());
                        isFallback = true;
                    }
                    if (it == null) break block26;
                    Optional<InteractionResult> manualPlacement = it.tryPlacePartFirst(pc, pc0, level, place0Pos, player, held, hit);
                    if (manualPlacement.isPresent()) {
                        return manualPlacement;
                    }
                    feature = it.getPlacement(level, place0Pos, player, held, hit).orElse(null);
                    if (feature == null || (hasWater = (Boolean)WorldPartComponents.BLOCK.defaultBlockState((BlockGetter)level, place0Pos).m_61143_((Property)WATERLOGGED)).booleanValue() && !feature.base().canSurviveInWater(null)) break block27;
                    Optional<PartEntity> optional = sim = pc0 != null ? pc0.simulatePlacePart(feature.base(), feature.placer(), feature.placement()) : Optional.empty();
                    if (!sim.isPresent()) break block27;
                    Map.Entry selection = pc0.selectPart(hit.m_82450_()).orElse(null);
                    VoxelShape voxelShape = selShape = selection != null ? ((PartEntity)selection.getValue()).getShape() : Shapes.m_83040_();
                    if (selShape.m_83281_()) break block28;
                    Vec3 loc = hit.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)hit.m_82425_()));
                    double axial = switch (hit.m_82434_().m_122434_()) {
                        case Direction.Axis.Y -> loc.f_82480_;
                        case Direction.Axis.X -> loc.f_82479_;
                        case Direction.Axis.Z -> loc.f_82481_;
                        default -> -1.0;
                    };
                    double d = desired = hit.m_82434_().m_122421_() == Direction.AxisDirection.NEGATIVE ? 0.0 : 1.0;
                    if (Math.abs(axial - desired) < 0.001) break block27;
                }
                if (pc0.placeSimulationResult(feature.placement(), sim)) {
                    PartEntity part = sim.orElseThrow();
                    it.onPartPlacedBy(part, player, held, hand);
                    return Optional.of(InteractionResult.m_19078_((boolean)level.f_46443_));
                }
            }
            if ((feature = (PlacedPartConfiguration)it.getPlacement(level, placePos, player, held, hit).orElse(null)) == null) {
                return Optional.empty();
            }
            hasWater = (Boolean)WorldPartComponents.BLOCK.defaultBlockState((BlockGetter)level, placePos).m_61143_((Property)WATERLOGGED);
            if (hasWater.booleanValue() && !feature.base().canSurviveInWater(null)) {
                return Optional.empty();
            }
            boolean justTurned = false;
            if (air) {
                if (isFallback) {
                    return Optional.empty();
                }
                pc = WorldPartComponents.createFragile((LevelAccessor)level, placePos);
            } else if (pc == null) {
                pc = PartContainer.turnIntoMultipart(level, placePos).orElse(null);
                boolean bl = justTurned = pc != null;
            }
            if (pc == null) {
                return Optional.empty();
            }
            if (pc.tryPlacePart(feature.base(), feature.placer(), feature.placement())) {
                PartEntity part = pc.getPartAt(feature.placement());
                if (part != null) {
                    it.onPartPlacedBy(part, player, held, hand);
                }
                if (pc.parts().stream().anyMatch(PartEntity::isRedstoneSource)) {
                    pc.updateRedstone();
                    pc.causeRedstoneUpdate = true;
                }
                pc.owner.syncContainer(true);
                return Optional.of(InteractionResult.m_19078_((boolean)level.m_5776_()));
            }
            if (justTurned && (blockEntity = level.m_7702_(placePos)) instanceof TileMultipartContainer) {
                TileMultipartContainer ctr = (TileMultipartContainer)blockEntity;
                ctr.tryDisassemble();
            }
        }
        return Optional.empty();
    }

    public static BlockHitResult getPlayerPOVHitResult(BlockGetter level, Player player, ClipContext.Fluid fluid) {
        float f = player.m_146909_();
        float f1 = player.m_146908_();
        Vec3 vec3 = player.m_146892_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.getBlockReach();
        Vec3 vec31 = vec3.m_82520_((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return level.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, fluid, (Entity)player));
    }
}

