/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.api.src;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.zeith.hammerlib.abstractions.sources.IObjectSource;
import org.zeith.hammerlib.abstractions.sources.IObjectSourceType;
import org.zeith.multipart.api.PartEntity;
import org.zeith.multipart.api.WorldPartComponents;
import org.zeith.multipart.api.placement.PartPlacement;
import org.zeith.multipart.api.placement.PartPos;
import org.zeith.multipart.init.PartRegistries;

public class PartSourceType
implements IObjectSourceType {
    public IObjectSource<?> readSource(CompoundTag tag) {
        return new PartSource(tag);
    }

    public static PartSource of(PartEntity part) {
        return PartSourceType.of(part.pos());
    }

    public static PartSource of(PartPos pos) {
        return new PartSource(pos);
    }

    public static class PartSource
    implements IObjectSource<PartEntity> {
        protected final PartPos pos;

        public PartSource(PartPos pos) {
            this.pos = pos;
        }

        public PartSource(CompoundTag tag) {
            this.pos = new PartPos(new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z")), (PartPlacement)PartRegistries.partPlacements().getValue(ResourceLocation.m_135820_((String)tag.m_128461_("Placement"))));
        }

        public CompoundTag writeSource() {
            CompoundTag tag = new CompoundTag();
            BlockPos pos = this.pos.pos();
            tag.m_128405_("x", pos.m_123341_());
            tag.m_128405_("y", pos.m_123342_());
            tag.m_128405_("z", pos.m_123343_());
            tag.m_128359_("Placement", Objects.toString(PartRegistries.partPlacements().getKey((Object)this.pos.placement())));
            return tag;
        }

        public IObjectSourceType getType() {
            return WorldPartComponents.PART_SOURCE_TYPE;
        }

        public Class<PartEntity> getBaseType() {
            return PartEntity.class;
        }

        public PartEntity get(Level level) {
            return this.pos.getOfType(level, PartEntity.class);
        }
    }
}

