/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.api;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import org.zeith.multipart.api.PartContainer;
import org.zeith.multipart.api.PartDefinitionModel;
import org.zeith.multipart.api.PartEntity;
import org.zeith.multipart.api.placement.IConfiguredPartPlacer;
import org.zeith.multipart.api.placement.PartPlacement;
import org.zeith.multipart.api.placement.PlacedPartConfiguration;
import org.zeith.multipart.client.IClientPartDefinitionExtensions;
import org.zeith.multipart.init.PartRegistries;

public abstract class PartDefinition {
    private Boolean isRegistered;
    public float destroySpeed = 1.0f;
    protected boolean survivesInWater = true;
    protected SoundType soundType = SoundType.f_56742_;
    protected final PartDefinitionModel model = this.createModel();
    protected int tintIndexCount = 0;
    protected Supplier<ItemStack> cloneItem = () -> ItemStack.f_41583_;
    private Object renderProperties;

    public PartDefinition() {
        this.initClient();
    }

    public SoundType getSoundType(PartEntity entity) {
        return this.soundType;
    }

    public boolean canSurviveInWater(@Nullable PartEntity part) {
        return this.survivesInWater;
    }

    protected PartDefinitionModel createModel() {
        return new PartDefinitionModel(this);
    }

    public PartDefinitionModel getModel() {
        return this.model;
    }

    public int getTintIndexCount() {
        return this.tintIndexCount;
    }

    public Optional<PlacedPartConfiguration> convertBlockToPart(Level level, BlockPos pos, BlockState state) {
        return Optional.empty();
    }

    public Optional<PartEntity> tryMergeWith(PartContainer container, PartPlacement placement, PartEntity otherEntity) {
        return Optional.empty();
    }

    public boolean canPlaceAt(PartContainer container, @Nullable IConfiguredPartPlacer placer, PartPlacement placement) {
        return true;
    }

    public abstract PartEntity createEntity(PartContainer var1, PartPlacement var2);

    public ItemStack getCloneItem() {
        return this.cloneItem.get();
    }

    public Object getRenderPropertiesInternal() {
        return this.renderProperties;
    }

    private void initClient() {
        if (FMLEnvironment.dist == Dist.CLIENT && !FMLLoader.getLaunchHandler().isData()) {
            this.initializeClient(properties -> {
                if (properties == this) {
                    throw new IllegalStateException("Don't extend IClientPartDefinitionExtensions in your part, use an anonymous class instead.");
                }
                this.renderProperties = properties;
            });
        }
    }

    public void initializeClient(Consumer<IClientPartDefinitionExtensions> consumer) {
    }

    public boolean isRegistered() {
        if (this.isRegistered == null) {
            this.isRegistered = PartRegistries.partDefinitions().containsValue((Object)this);
        }
        return this.isRegistered;
    }
}

