/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.zeith.multipart.api.IPartContainerTile;
import org.zeith.multipart.api.ITickingPartEntity;
import org.zeith.multipart.api.IndexedVoxelShape;
import org.zeith.multipart.api.PartDefinition;
import org.zeith.multipart.api.PartEntity;
import org.zeith.multipart.api.WorldPartComponents;
import org.zeith.multipart.api.placement.IConfiguredPartPlacer;
import org.zeith.multipart.api.placement.PartPlacement;
import org.zeith.multipart.api.placement.PlacedPartConfiguration;
import org.zeith.multipart.client.IClientPartDefinitionExtensions;
import org.zeith.multipart.client.rendering.IPartRenderer;
import org.zeith.multipart.init.PartRegistries;

public class PartContainer {
    public static final Logger LOG = LogManager.getLogger(PartContainer.class);
    public static final ModelProperty<PartContainer> CONTAINER_PROP = new ModelProperty();
    public static final ModelProperty<Long> PART_HASH = new ModelProperty();
    protected final LinkedHashMap<PartPlacement, PartEntity> parts = new LinkedHashMap();
    protected final Set<ITickingPartEntity> ticking = new HashSet<ITickingPartEntity>();
    @ApiStatus.Internal
    public final LinkedHashMap<PartPlacement, Object> renderers = new LinkedHashMap();
    public final int[] weakRedstoneSignals = new int[6];
    public final int[] strongRedstoneSignals = new int[6];
    public final BlockPos pos;
    public Level level;
    public int lightLevel;
    @Deprecated(forRemoval=true)
    public boolean needsSync;
    public boolean causeBlockUpdate;
    public boolean causeRedstoneUpdate;
    public boolean waterlogged;
    public final IPartContainerTile owner;
    private PartPlacement[] tintToPlacement = new PartPlacement[0];
    protected long lastRecalcHash = -1L;
    protected VoxelShape cachedShape;
    protected VoxelShape cachedCollisionShape;
    protected long prevNetworkHash;
    protected final List<QueuedPartRemoval> toRemove = new ArrayList<QueuedPartRemoval>();

    public PartContainer(BlockPos pos, IPartContainerTile owner) {
        this.pos = pos;
        this.owner = owner;
    }

    public Optional<PartEntity> simulatePlacePart(@NotNull PartDefinition def, @Nullable IConfiguredPartPlacer placer, @NotNull PartPlacement placement) {
        PartEntity placeEntity;
        if (!placement.canBePlacedAlongside(this.parts.keySet())) {
            return Optional.empty();
        }
        if (!def.canPlaceAt(this, placer, placement)) {
            return Optional.empty();
        }
        for (Map.Entry<PartPlacement, PartEntity> entry : this.parts.entrySet()) {
            if (!entry.getKey().isCompatibleWith(placement)) {
                return Optional.empty();
            }
            PartEntity part = entry.getValue();
            if (!part.blocksPlacementFor(def, placement)) continue;
            return Optional.empty();
        }
        PartEntity existingPart = this.getPartAt(placement);
        if (existingPart != null) {
            Optional<PartEntity> opt = def.tryMergeWith(this, placement, existingPart);
            if (opt.isEmpty()) {
                return Optional.empty();
            }
            placeEntity = opt.orElseThrow();
        } else {
            PartEntity partEntity = placeEntity = placer != null ? placer.create(this, placement) : def.createEntity(this, placement);
        }
        if (placeEntity == null) {
            return Optional.empty();
        }
        VoxelShape shapeOfEntity = placeEntity.getPartOccupiedShape();
        for (PartEntity part : this.parts()) {
            if (!IndexedVoxelShape.shapesIntersect(shapeOfEntity, part.getPartOccupiedShapeWith(placeEntity, shapeOfEntity))) continue;
            return Optional.empty();
        }
        return Optional.of(placeEntity);
    }

    public boolean tryPlacePart(@NotNull PartDefinition def, @Nullable IConfiguredPartPlacer placer, @NotNull PartPlacement placement) {
        return this.placeSimulationResult(placement, this.simulatePlacePart(def, placer, placement));
    }

    public boolean placeSimulationResult(PartPlacement placement, Optional<PartEntity> result) {
        result.ifPresent(placeEntity -> {
            this.setPartAt(placement, (PartEntity)placeEntity, true);
            placeEntity.onPlaced();
            if (placeEntity.isRedstoneSource()) {
                this.updateRedstone();
                this.causeRedstoneUpdate = true;
            }
            this.markForSync();
        });
        return result.isPresent();
    }

    public int getColorForTintLayer(int tintLayer) {
        if (tintLayer < 0 || tintLayer >= this.tintToPlacement.length) {
            return 0xFFFFFF;
        }
        PartEntity part = this.getPartAt(this.tintToPlacement[tintLayer]);
        return part != null ? part.getTintLayerColor(tintLayer) : 0xFFFFFF;
    }

    public void recalcTintLayers(long hash) {
        if (hash == this.lastRecalcHash) {
            return;
        }
        while (true) {
            try {
                int layerCount = this.parts().stream().mapToInt(e -> e.tintIndices.length).sum();
                this.tintToPlacement = new PartPlacement[layerCount];
                int i = 0;
                for (Map.Entry<PartPlacement, PartEntity> e2 : this.parts.entrySet()) {
                    PartEntity pe = e2.getValue();
                    int[] ti = pe.tintIndices;
                    for (int j = 0; j < ti.length; ++j) {
                        int layer;
                        ti[j] = layer = i++;
                        this.tintToPlacement[layer] = e2.getKey();
                    }
                }
            }
            catch (ConcurrentModificationException e3) {
                continue;
            }
            break;
        }
        this.lastRecalcHash = hash;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return this.parts().stream().map(pe -> pe.getCapability(cap, side)).filter(LazyOptional::isPresent).findFirst().orElseGet(LazyOptional::empty);
    }

    public void refreshTicking() {
        this.ticking.clear();
        for (PartEntity part : this.parts()) {
            if (!(part instanceof ITickingPartEntity)) continue;
            ITickingPartEntity tpe = (ITickingPartEntity)((Object)part);
            this.ticking.add(tpe);
        }
    }

    public void setPartAt(PartPlacement placement, PartEntity part, boolean shouldUpdate) {
        this.parts.put(placement, part);
        this.refreshTicking();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            IPartRenderer renderer = IClientPartDefinitionExtensions.of(part).createRenderer(part);
            if (renderer != null) {
                this.renderers.put(placement, renderer);
            }
        });
        if (shouldUpdate) {
            this.causeBlockUpdate = true;
            part.onLoad();
            part.setAddedToWorld(true);
            if (!this.causeRedstoneUpdate && part.isRedstoneSource()) {
                this.causeRedstoneUpdate = true;
                this.updateRedstone();
            }
        }
    }

    @Nullable
    public PartEntity getPartAt(PartPlacement placement) {
        return this.parts.get(placement);
    }

    public void tickServer() {
        boolean updateShape = this.causeBlockUpdate;
        for (ITickingPartEntity part : this.ticking) {
            part.tickServer();
            if (part.isShapeDirty()) {
                updateShape = true;
            }
            if (!part.syncDirty()) continue;
            this.markForSync();
            part.markSynced();
        }
        if (this.removePendingParts()) {
            updateShape = true;
        }
        this.tickShape(updateShape);
    }

    public void tickClient() {
        boolean updateShape = this.causeBlockUpdate;
        for (ITickingPartEntity part : this.ticking) {
            part.tickClient();
            if (!part.isShapeDirty()) continue;
            updateShape = true;
        }
        if (this.removePendingParts()) {
            updateShape = true;
        }
        this.tickShape(updateShape);
        this.needsSync = false;
    }

    public boolean removePendingParts() {
        boolean mod = false;
        while (!this.toRemove.isEmpty()) {
            QueuedPartRemoval rem = this.toRemove.remove(0);
            PartEntity part = (PartEntity)this.parts.remove(rem.placement);
            if (part == null) continue;
            mod = true;
            part.onRemoved(null, rem.drops(), rem.sound(), rem.particles());
            part.setAddedToWorld(false);
            if (part.isRedstoneSource()) {
                this.updateRedstone();
            }
            this.causeBlockUpdate = true;
        }
        if (mod) {
            this.refreshTicking();
            this.markForSync();
        }
        return mod;
    }

    protected void tickShape(boolean updateShape) {
        if (this.cachedShape == null || updateShape) {
            this.updateShape();
        }
        if (this.cachedCollisionShape == null || updateShape) {
            this.updateCollisionShape();
        }
        if (updateShape) {
            this.updateLightLevel();
            this.updateRedstone();
        }
    }

    public void updateLightLevel() {
        int pll = this.lightLevel;
        this.lightLevel = 0;
        boolean addedToWorld = this.level != null;
        for (PartEntity part : this.parts()) {
            part.setAddedToWorld(addedToWorld);
            this.lightLevel = Math.max(this.lightLevel, part.getLightEmission());
        }
        if (pll != this.lightLevel) {
            this.causeBlockUpdate = true;
        }
    }

    protected void updateShape() {
        this.cachedShape = this.parts().stream().map(PartEntity::getShape).reduce(Shapes.m_83040_(), Shapes::m_83110_);
    }

    protected void updateCollisionShape() {
        this.cachedCollisionShape = this.parts().stream().map(PartEntity::getCollisionShape).reduce(Shapes.m_83040_(), Shapes::m_83110_);
    }

    public long calcPartsHash() {
        long hash = 1L;
        IForgeRegistry<PartPlacement> pp = PartRegistries.partPlacements();
        IForgeRegistry<PartDefinition> pd = PartRegistries.partDefinitions();
        for (Map.Entry<PartPlacement, PartEntity> entry : this.parts.entrySet()) {
            hash *= 31L;
            hash += (long)Objects.hashCode(pp.getKey((Object)entry.getKey()));
            hash *= 31L;
            hash += (long)Objects.hashCode(pd.getKey((Object)entry.getValue().definition()));
        }
        return hash;
    }

    public VoxelShape getShape() {
        if (this.cachedShape == null) {
            this.updateShape();
        }
        return this.cachedShape;
    }

    public VoxelShape getCollisionShape() {
        if (this.cachedCollisionShape == null) {
            this.updateCollisionShape();
        }
        return this.cachedCollisionShape;
    }

    public void resetShapes() {
        this.cachedCollisionShape = null;
        this.cachedShape = null;
    }

    public void updateRedstone() {
        boolean changed = false;
        for (Direction dir : Direction.values()) {
            int i = dir.ordinal();
            int j = this.strongRedstoneSignals[i];
            this.strongRedstoneSignals[i] = this.parts().stream().mapToInt(p -> p.getStrongSignal(dir)).max().orElse(0);
            if (this.strongRedstoneSignals[i] != j) {
                changed = true;
            }
            j = this.weakRedstoneSignals[i];
            this.weakRedstoneSignals[i] = this.parts().stream().mapToInt(p -> p.getWeakSignal(dir)).max().orElse(0);
            if (this.weakRedstoneSignals[i] == j) continue;
            changed = true;
        }
        if (!changed) {
            return;
        }
        this.causeBlockUpdate = true;
        this.causeRedstoneUpdate = true;
        this.markForSync();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag parts = new ListTag();
        for (PartEntity e : this.parts()) {
            CompoundTag element = new CompoundTag();
            element.m_128359_("Pos", PartRegistries.partPlacements().getKey((Object)e.placement()).toString());
            element.m_128359_("Def", PartRegistries.partDefinitions().getKey((Object)e.definition()).toString());
            element.m_128365_("Data", (Tag)e.serialize());
            element.m_128385_("Tint", e.tintIndices);
            parts.add((Object)element);
        }
        tag.m_128365_("Parts", (Tag)parts);
        tag.m_128405_("Light", this.lightLevel);
        tag.m_128385_("WeakRS", this.weakRedstoneSignals);
        tag.m_128385_("StrongRS", this.strongRedstoneSignals);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.parts.clear();
        this.lightLevel = tag.m_128451_("Light");
        ListTag parts = tag.m_128437_("Parts", 10);
        int[] rs = tag.m_128465_("WeakRS");
        System.arraycopy(rs, 0, this.weakRedstoneSignals, 0, Math.min(this.weakRedstoneSignals.length, rs.length));
        rs = tag.m_128465_("StrongRS");
        System.arraycopy(rs, 0, this.strongRedstoneSignals, 0, Math.min(this.strongRedstoneSignals.length, rs.length));
        for (int i = 0; i < parts.size(); ++i) {
            CompoundTag element = parts.m_128728_(i);
            ResourceLocation pos = ResourceLocation.m_135820_((String)element.m_128461_("Pos"));
            ResourceLocation def = ResourceLocation.m_135820_((String)element.m_128461_("Def"));
            if (pos == null || def == null) continue;
            PartPlacement placement = (PartPlacement)PartRegistries.partPlacements().getValue(pos);
            PartDefinition definition = (PartDefinition)PartRegistries.partDefinitions().getValue(def);
            if (placement == null || definition == null) {
                LOG.warn("Unable to deserialize part with definition {}({}) in {}({}) (at {}): {} unknown", (Object)definition, (Object)def, (Object)placement, (Object)pos, (Object)this.pos(), (Object)(placement == null ? (definition == null ? "placement & definition" : "placement") : "definition"));
                continue;
            }
            PartEntity part = definition.createEntity(this, placement);
            if (part == null) {
                LOG.warn("Unable to create part with definition {}", (Object)def);
                continue;
            }
            part.deserialize(element.m_128469_("Data"));
            this.setPartAt(placement, part, false);
            int[] tints = element.m_128465_("Tint");
            System.arraycopy(tints, 0, part.tintIndices, 0, Math.min(part.tintIndices.length, tints.length));
        }
        long newHash = this.calcPartsHash();
        if (this.prevNetworkHash != newHash) {
            this.prevNetworkHash = newHash;
            this.causeBlockUpdate = true;
        }
    }

    public Optional<Map.Entry<PartPlacement, PartEntity>> selectPart(Vec3 hitPos) {
        double iwx = this.pos.m_123341_();
        double iwy = this.pos.m_123342_();
        double iwz = this.pos.m_123343_();
        Vec3 lpos = hitPos.m_82492_(iwx, iwy, iwz);
        return this.parts.entrySet().stream().filter(e -> ((PartEntity)e.getValue()).getShape().m_83299_().stream().anyMatch(a -> a.m_82400_(1.0E-7).m_82390_(lpos))).findFirst().map(part -> {
            if (((PartEntity)part.getValue()).getMainPart() == part.getKey()) {
                return part;
            }
            return Map.entry(((PartEntity)part.getValue()).getMainPart(), (PartEntity)part.getValue());
        });
    }

    public Level level() {
        return this.level;
    }

    public BlockPos pos() {
        return this.pos;
    }

    public boolean isEmpty() {
        return this.parts.isEmpty();
    }

    public Collection<PartEntity> parts() {
        return this.parts.values();
    }

    public void breakPart(Player player, boolean willHarvest, PartPlacement placement) {
        PartEntity ent = this.parts.get(placement);
        if (ent != null) {
            placement = ent.getMainPart();
            ent = (PartEntity)this.parts.remove(placement);
            ent.onRemovedBy(player, willHarvest);
            ent.setAddedToWorld(false);
            if (ent.isRedstoneSource()) {
                this.updateRedstone();
            }
            this.causeBlockUpdate = true;
            this.refreshTicking();
            this.markForSync();
        }
    }

    public void onChunkUnloaded() {
        for (PartEntity p : this.parts()) {
            p.setAddedToWorld(false);
            p.onChunkUnloaded();
        }
    }

    public void onLoad() {
        for (PartEntity p : this.parts()) {
            p.setAddedToWorld(true);
            p.onLoad();
        }
    }

    public boolean isTicking() {
        return !this.ticking.isEmpty();
    }

    public void queuePartRemoval(PartPlacement placement, boolean spawnDrops, boolean playSound, boolean spawnParticles) {
        this.toRemove.add(new QueuedPartRemoval(placement, spawnDrops, playSound, spawnParticles));
    }

    public static Optional<PartContainer> turnIntoMultipart(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        for (PartDefinition definition : PartRegistries.partDefinitions()) {
            PartContainer pc;
            PlacedPartConfiguration cfg = definition.convertBlockToPart(level, pos, state).orElse(null);
            if (cfg == null || (pc = WorldPartComponents.createFragile((LevelAccessor)level, pos)) == null) continue;
            PartEntity pe = cfg.placer().create(pc, cfg.placement());
            pc.setPartAt(cfg.placement(), pe, false);
            return Optional.of(pc);
        }
        return Optional.empty();
    }

    public void neighborChanged(Direction from, BlockPos neigborPos, BlockState neigborState, boolean waterlogged) {
        for (PartEntity part : this.parts()) {
            part.neighborChanged(from, neigborPos, neigborState, waterlogged);
        }
        this.markForSync();
    }

    public void markForSync() {
        this.owner.syncContainer(false);
    }

    protected record QueuedPartRemoval(PartPlacement placement, boolean drops, boolean sound, boolean particles) {
    }
}

