/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_solcarrot.core.common.util;

import java.util.Collection;
import java.util.function.IntFunction;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUtils {
    public static <COLLECTION extends Collection<Item>> COLLECTION decodeItems(IntFunction<COLLECTION> func, FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        Collection collection = (Collection)func.apply(size);
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = buffer.m_130281_();
            collection.add((Item)ForgeRegistries.ITEMS.getValue(id));
        }
        return (COLLECTION)collection;
    }

    public static void encodeItems(FriendlyByteBuf buffer, Collection<Item> collection) {
        int size = collection.size();
        buffer.writeInt(size);
        for (Item item : collection) {
            ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
            buffer.m_130085_(id);
        }
    }

    public static void deserializeItems(Collection<Item> collection, ListTag listTag) {
        collection.clear();
        for (int i = 0; i < listTag.size(); ++i) {
            Item item;
            ResourceLocation id = ResourceLocation.m_135820_((String)listTag.m_128778_(i));
            if (id == null || (item = (Item)ForgeRegistries.ITEMS.getValue(id)) == null || item == Items.f_41852_) continue;
            collection.add(item);
        }
    }

    public static ListTag serializeItems(Collection<Item> collection) {
        ListTag listTag = new ListTag();
        for (Item item : collection) {
            ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
            if (id == null) continue;
            listTag.add((Object)StringTag.m_129297_((String)id.toString()));
        }
        return listTag;
    }

    private ItemUtils() {
    }
}

