/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_solcarrot.core.common.entity;

import com.google.common.collect.ImmutableSet;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_solcarrot.api.common.IMineColoniesSoLAPI;
import steve_gall.minecolonies_solcarrot.api.common.colony.ICitizenFoodData;
import steve_gall.minecolonies_solcarrot.core.common.util.ItemUtils;

public class CitizenFoodData
implements ICitizenFoodData,
INBTSerializable<CompoundTag> {
    private static final UUID MAX_HEALTH_MODIFIER_ID = UUID.fromString("31091b53-759d-4a00-a064-4e53ac235e2b");
    private static final String TAG_EATENS = "eatens";
    private final ICitizenData citizen;
    private final Set<Item> eatens = new HashSet<Item>();
    private int cachedEatenCount = 0;
    private int cachedMilestone = 0;

    public CitizenFoodData(ICitizenData citizen) {
        this.citizen = citizen;
    }

    public void serializeViewNetworkData(FriendlyByteBuf buffer) {
        ItemUtils.encodeItems(buffer, this.eatens);
        buffer.writeInt(this.cachedEatenCount);
        buffer.writeInt(this.cachedMilestone);
    }

    @Override
    @NotNull
    public ICitizenData citizen() {
        return this.citizen;
    }

    @Override
    public int milestone() {
        return this.cachedMilestone;
    }

    private void setCacheCount(int eatenCount) {
        this.cachedEatenCount = eatenCount;
        this.cachedMilestone = IMineColoniesSoLAPI.instance().getMilestone(eatenCount);
        this.updateModifier();
        this.citizen.markDirty(20);
    }

    @Override
    public boolean milestoneComplete() {
        return IMineColoniesSoLAPI.instance().isMilestoneComplete(this.milestone());
    }

    @Override
    public boolean addEaten(@NotNull ItemStack stack) {
        Item item = stack.m_41720_();
        boolean added = this.eatens.add(item);
        if (added && IMineColoniesSoLAPI.instance().shouldCount(item)) {
            this.setCacheCount(this.cachedEatenCount + 1);
            return added;
        }
        this.updateModifier();
        return false;
    }

    @Override
    public boolean wasEaten(@NotNull Item item) {
        return this.eatens.contains(item);
    }

    @Override
    @NotNull
    public Set<Item> getEatens() {
        return ImmutableSet.copyOf(this.eatens);
    }

    @Override
    public void clearEatens() {
        this.eatens.clear();
        this.setCacheCount(0);
    }

    @Override
    public int eatenCount() {
        return this.cachedEatenCount;
    }

    public boolean updateModifier() {
        AbstractEntityCitizen entity = this.citizen.getEntity().orElse(null);
        if (entity == null) {
            return false;
        }
        int bonusHealth = IMineColoniesSoLAPI.instance().getBonusHealth(this.milestone());
        AttributeModifier oldModifier = entity.m_21051_(Attributes.f_22276_).m_22111_(MAX_HEALTH_MODIFIER_ID);
        if (oldModifier != null && oldModifier.m_22218_() == (double)bonusHealth) {
            return false;
        }
        AttributeModifier newModifier = new AttributeModifier(MAX_HEALTH_MODIFIER_ID, "minecolonies_solcarrot", (double)bonusHealth, AttributeModifier.Operation.ADDITION);
        float oldMax = entity.m_21233_();
        if (oldModifier != null) {
            entity.m_21051_(Attributes.f_22276_).m_22130_(oldModifier);
        }
        entity.m_21051_(Attributes.f_22276_).m_22125_(newModifier);
        float newMax = entity.m_21233_();
        entity.m_21153_(entity.m_21223_() * (newMax / oldMax));
        return true;
    }

    public void deserializeNBT(CompoundTag compound) {
        ItemUtils.deserializeItems(this.eatens, compound.m_128437_(TAG_EATENS, 8));
        this.setCacheCount((int)this.eatens.stream().filter(IMineColoniesSoLAPI.instance()::shouldCount).count());
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_(TAG_EATENS, (Tag)ItemUtils.serializeItems(this.eatens));
        return compound;
    }
}

