/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_solcarrot.core.common.config;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class MineColoniesSoLConfigServer {
    public static final MineColoniesSoLConfigServer INSTANCE;
    public static final ForgeConfigSpec SPEC;
    public final ForgeConfigSpec.BooleanValue followCE;
    public final ForgeConfigSpec.IntValue heartsPerMilestones;
    public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> milestones;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> whitelist;
    public final ForgeConfigSpec.IntValue minimumNutrition;

    public MineColoniesSoLConfigServer(ForgeConfigSpec.Builder builder) {
        builder.comment("Follows 'Spice of Life: Carrot Edition' config, if it installed.");
        this.followCE = builder.define("followCE", true);
        builder.push("milestones");
        this.heartsPerMilestones = builder.defineInRange("heartsPerMilestones", 2, 0, 1000);
        this.milestones = builder.defineList("milestones", () -> Lists.newArrayList((Object[])new Integer[]{5, 10, 15, 20, 25}), e -> e instanceof Integer);
        builder.pop();
        builder.push("filtering");
        this.blacklist = builder.defineList("blacklist", () -> Lists.newArrayList(), e -> e instanceof String);
        this.whitelist = builder.defineList("whitelist", () -> Lists.newArrayList(), e -> e instanceof String);
        this.minimumNutrition = builder.defineInRange("minimumNutrition", 1, 0, 1000);
        builder.pop();
    }

    public boolean shouldCount(Item item) {
        FoodProperties food = item.m_7968_().getFoodProperties(null);
        return food.m_38744_() >= (Integer)this.minimumNutrition.get() && this.isAllowed(item);
    }

    public boolean isAllowed(Item item) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        if (id == null) {
            return false;
        }
        String idStr = id.toString();
        if (((List)this.whitelist.get()).size() > 0) {
            return ((List)this.whitelist.get()).contains(idStr);
        }
        return !((List)this.blacklist.get()).contains(idStr);
    }

    static {
        Pair common = new ForgeConfigSpec.Builder().configure(MineColoniesSoLConfigServer::new);
        INSTANCE = (MineColoniesSoLConfigServer)common.getLeft();
        SPEC = (ForgeConfigSpec)common.getRight();
    }
}

