/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_solcarrot.core.common.compat;

import com.ldtteam.blockui.BOScreen;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_solcarrot.api.common.IMineColoniesSoLAPI;
import steve_gall.minecolonies_solcarrot.api.common.colony.ICitizenFoodDataView;
import steve_gall.minecolonies_solcarrot.core.client.gui.ColonyFoodData;
import steve_gall.minecolonies_solcarrot.core.client.gui.FoodNoniconCitizensWindow;
import steve_gall.minecolonies_tweaks.api.client.gui.ResourceScrollBookElement;

public class FoodNomiconElement
extends ResourceScrollBookElement {
    private ColonyFoodData food = null;
    private Component completed = EMPTY;
    private Component least = EMPTY;
    private Component tooltip = EMPTY;

    public FoodNomiconElement(@NotNull ItemStack stack) {
        super(stack);
    }

    public void onOpenClicked() {
        super.onOpenClicked();
        if (this.food == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        BOWindow window = null;
        Screen screen = mc.f_91080_;
        if (screen instanceof BOScreen) {
            BOScreen screen2 = (BOScreen)screen;
            window = screen2.getWindow();
        }
        new FoodNoniconCitizensWindow(this.food, window).open();
    }

    public void update() {
        super.update();
        Minecraft mc = Minecraft.m_91087_();
        IColony colony = IMinecoloniesAPI.getInstance().getColonyManager().getIColonyByOwner((Level)mc.f_91073_, (Player)mc.f_91074_);
        if (!(colony instanceof IColonyView)) {
            this.valid = false;
            this.food = null;
            this.completed = EMPTY;
            this.least = EMPTY;
            this.tooltip = EMPTY;
            return;
        }
        IColonyView view = (IColonyView)colony;
        this.valid = true;
        this.food = new ColonyFoodData(view);
        int count = 0;
        int completes = 0;
        ICitizenFoodDataView least = null;
        for (Map.Entry<ICitizenDataView, ICitizenFoodDataView> entry : this.food.getCitizenFoodEntrySet()) {
            ++count;
            ICitizenFoodDataView citizen = entry.getValue();
            if (citizen.milestoneComplete()) {
                ++completes;
                continue;
            }
            if (least != null && least.eatenCount() <= citizen.eatenCount()) continue;
            least = citizen;
        }
        int max = IMineColoniesSoLAPI.instance().getFoodCountForMaxBonus();
        this.completed = Component.m_237110_((String)"minecolonies_sol.gui.completed_citizens", (Object[])new Object[]{completes, count});
        this.least = least == null ? EMPTY : Component.m_237110_((String)"minecolonies_sol.gui.least_ate_citizen", (Object[])new Object[]{least.citizen().getName()});
        this.tooltip = least == null ? EMPTY : Component.m_237113_((String)(least.citizen().getName() + "\n")).m_7220_((Component)Component.m_237110_((String)"minecolonies_sol.gui.eaten_count", (Object[])new Object[]{least.eatenCount() + " / " + max}));
    }

    public void update(int index, @NotNull Pane rowPane) {
        super.update(index, rowPane);
        if (!this.valid) {
            return;
        }
        this.getDesc1Label(rowPane).setText(this.completed);
        this.getDesc2Label(rowPane).setText(this.least);
        this.getTooltip2(rowPane).setText(this.tooltip);
    }
}

