/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_solcarrot.core.common.command;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.ToIntBiFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import steve_gall.minecolonies_solcarrot.api.common.IMineColoniesSoLAPI;
import steve_gall.minecolonies_solcarrot.api.common.colony.ICitizenFoodData;
import steve_gall.minecolonies_solcarrot.core.common.util.ItemUtils;

public class CitizenCommands {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        LiteralArgumentBuilder command = Commands.m_82127_((String)"citizens");
        command.then(SaturationCommands.register());
        command.then(EatensCommands.register());
        return command;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> literal(String name, boolean needPermission, ToIntBiFunction<CommandContext<CommandSourceStack>, ICitizenData> func) {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)name).then(IMCCommand.newArgument((String)"colonyID", (ArgumentType)IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument((String)"citizenID", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> CitizenCommands.run((CommandContext<CommandSourceStack>)context, needPermission, func))));
    }

    public static int run(CommandContext<CommandSourceStack> context, boolean needPermission, ToIntBiFunction<CommandContext<CommandSourceStack>, ICitizenData> func) {
        if (needPermission && !((CommandSourceStack)context.getSource()).m_6761_(2)) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"com.minecolonies.command.notop"), true);
            return 0;
        }
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, ((CommandSourceStack)context.getSource()).m_81372_().m_46472_());
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        if (!((CommandSourceStack)context.getSource()).m_6761_(4)) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"com.minecolonies.command.notenabledinconfig"), true);
            return 0;
        }
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(IntegerArgumentType.getInteger(context, (String)"citizenID"));
        if (citizenData == null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"com.minecolonies.command.citizeninfo.notfound"), true);
            return 0;
        }
        return func.applyAsInt(context, citizenData);
    }

    public static class SaturationCommands {
        public static LiteralArgumentBuilder<CommandSourceStack> register() {
            LiteralArgumentBuilder command = Commands.m_82127_((String)"saturation");
            command.then(SaturationCommands.full());
            command.then(SaturationCommands.empty());
            return command;
        }

        private static LiteralArgumentBuilder<CommandSourceStack> full() {
            return CitizenCommands.literal("full", true, (context, citizen) -> {
                citizen.setSaturation(20.0);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Done"), true);
                return 1;
            });
        }

        private static LiteralArgumentBuilder<CommandSourceStack> empty() {
            return CitizenCommands.literal("empty", true, (context, citizen) -> {
                citizen.setSaturation(0.0);
                citizen.setJustAte(false);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Done"), true);
                return 1;
            });
        }
    }

    public class EatensCommands {
        public static LiteralArgumentBuilder<CommandSourceStack> register() {
            LiteralArgumentBuilder command = Commands.m_82127_((String)"eatens");
            command.then(EatensCommands.show());
            command.then(EatensCommands.clear());
            return command;
        }

        private static LiteralArgumentBuilder<CommandSourceStack> clear() {
            return CitizenCommands.literal("clear", false, (context, citizen) -> {
                ICitizenFoodData foodData = IMineColoniesSoLAPI.instance().getFoodData((ICitizenData)citizen);
                foodData.clearEatens();
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)"Done"));
                return 1;
            });
        }

        private static LiteralArgumentBuilder<CommandSourceStack> show() {
            return CitizenCommands.literal("show", false, (context, citizen) -> {
                ICitizenFoodData foodData = IMineColoniesSoLAPI.instance().getFoodData((ICitizenData)citizen);
                ListTag tags = ItemUtils.serializeItems(foodData.getEatens());
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("========== " + tags.size())));
                for (int i = 0; i < tags.size(); ++i) {
                    Tag tag = tags.get(i);
                    ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(i + " - " + tag.m_7916_())));
                }
                return 1;
            });
        }
    }
}

