/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_solcarrot.core.common;

import com.cazsius.solcarrot.SOLCarrotConfig;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_solcarrot.api.common.IMineColoniesSoLAPI;
import steve_gall.minecolonies_solcarrot.api.common.colony.ICitizenFoodData;
import steve_gall.minecolonies_solcarrot.api.common.colony.ICitizenFoodDataView;
import steve_gall.minecolonies_solcarrot.core.common.config.MineColoniesSoLConfigServer;
import steve_gall.minecolonies_solcarrot.core.common.entity.ICitizenDataExtensions;
import steve_gall.minecolonies_solcarrot.core.common.entity.ICitizenDataViewExtensions;

public class MineColoniesSoLAPI
implements IMineColoniesSoLAPI {
    public static final MineColoniesSoLAPI INSTANCE = new MineColoniesSoLAPI();

    private MineColoniesSoLAPI() {
    }

    @Override
    @NotNull
    public ICitizenFoodDataView getFoodDataView(@NotNull ICitizenDataView citizen) {
        return ((ICitizenDataViewExtensions)citizen).minecolonies_sol$getFood();
    }

    @Override
    @NotNull
    public ICitizenFoodData getFoodData(@NotNull ICitizenData citizen) {
        return ((ICitizenDataExtensions)citizen).minecolonies_sol$getFood();
    }

    private boolean followCE() {
        return ModList.get().isLoaded("solcarrot") && (Boolean)MineColoniesSoLConfigServer.INSTANCE.followCE.get() != false;
    }

    @Override
    public boolean shouldCount(@NotNull Item item) {
        if (!ItemStackUtils.ISFOOD.test(item.m_7968_())) {
            return false;
        }
        if (this.followCE()) {
            return SOLCarrotConfig.isAllowed((Item)item);
        }
        return MineColoniesSoLConfigServer.INSTANCE.shouldCount(item);
    }

    @Override
    public int getBonusHeartsPerMilestone() {
        if (this.followCE()) {
            return SOLCarrotConfig.getHeartsPerMilestone();
        }
        return (Integer)MineColoniesSoLConfigServer.INSTANCE.heartsPerMilestones.get();
    }

    @Override
    public boolean isMilestoneComplete(int milestone) {
        if (this.followCE()) {
            return milestone >= SOLCarrotConfig.getMilestoneCount();
        }
        return milestone >= ((List)MineColoniesSoLConfigServer.INSTANCE.milestones.get()).size();
    }

    private List<Integer> getMilestones() {
        if (this.followCE()) {
            return SOLCarrotConfig.getMilestones();
        }
        return new ArrayList<Integer>((Collection)MineColoniesSoLConfigServer.INSTANCE.milestones.get());
    }

    @Override
    public int getFoodCountForMaxBonus() {
        int foodCount = 0;
        for (Integer m : this.getMilestones()) {
            foodCount = Math.max(foodCount, m);
        }
        return foodCount;
    }

    @Override
    public int getMilestone(int eatenCount) {
        int milestone = 0;
        for (Integer criteria : this.getMilestones()) {
            if (eatenCount < criteria) continue;
            ++milestone;
        }
        return milestone;
    }
}

