/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_solcarrot.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_solcarrot.api.common.IMineColoniesSoLAPI;
import steve_gall.minecolonies_solcarrot.api.common.colony.ICitizenFoodDataView;
import steve_gall.minecolonies_solcarrot.core.client.gui.ColonyFoodData;
import steve_gall.minecolonies_solcarrot.core.client.gui.FoodNoniconCitizensWindow;
import steve_gall.minecolonies_solcarrot.core.client.gui.FoodNoniconFoodsWindow;

public abstract class FoodNoniconWindow
extends AbstractWindowSkeleton {
    public static final Component O = Component.m_237113_((String)"O");
    public static final Component X = Component.m_237113_((String)"X");
    public static final String BUTTON_CITIZENS_MODE = "citizensMode";
    public static final String BUTTON_FOODS_MODE = "foodsMode";
    public static final String LIST_CITIZENS = "citizens";
    public static final String LIST_ATE_CITIZENS = "ateCitizens";
    public static final String LIST_NOT_ATE_CITIZENS = "notAteCitizens";
    public static final String LIST_FOODS = "foods";
    public static final String LIST_EATEN_FOODS = "eatenFoods";
    public static final String LIST_NOT_EATEN_FOODS = "notEatenFoods";
    public static final String TEXT_CITIZEN_NAME = "citizenName";
    public static final String TEXT_CITIZEN_STATUS_1 = "citizenStatus1";
    public static final String TEXT_CITIZEN_STATUS_2 = "citizenStatus2";
    public static final String TEXT_FOOD_NAME = "foodName";
    public static final String TEXT_FOOD_STATUS = "foodStatus";
    public static final String ICON_FOOD = "foodIcon";
    public static final String BUTTON_EXCEPT_COMPLETLED = "exceptCompleted";
    private BOWindow parent;
    protected final ColonyFoodData colonyFoodData;
    protected final int maxCount = IMineColoniesSoLAPI.instance().getFoodCountForMaxBonus();

    public FoodNoniconWindow(ColonyFoodData foodData, String resource, @Nullable BOWindow parent) {
        super(resource, null);
        this.colonyFoodData = foodData;
        this.parent = parent;
    }

    public void onButtonClicked(Button button) {
        super.onButtonClicked(button);
        if (Objects.equals(button.getID(), BUTTON_CITIZENS_MODE)) {
            new FoodNoniconCitizensWindow(this.colonyFoodData, this.parent).open();
        } else if (Objects.equals(button.getID(), BUTTON_FOODS_MODE)) {
            new FoodNoniconFoodsWindow(this.colonyFoodData, this.parent).open();
        }
    }

    protected int getHoveredRow(ScrollingList list) {
        List children = list.getContainer().getChildren();
        for (int i = 0; i < children.size(); ++i) {
            if (!((Pane)children.get(i)).wasCursorInPane()) continue;
            return i;
        }
        return -1;
    }

    protected int compareCitizen(ICitizenDataView citizen1, ICitizenDataView citizen2) {
        int count2;
        ICitizenFoodDataView foodData2;
        ICitizenFoodDataView foodData1 = this.colonyFoodData.getFoodData(citizen1);
        if (foodData1 != null != ((foodData2 = this.colonyFoodData.getFoodData(citizen2)) != null)) {
            return Boolean.compare(foodData1 != null, foodData2 != null);
        }
        if (foodData1 == null) {
            return 0;
        }
        int count1 = foodData1.eatenCount();
        if (count1 != (count2 = foodData2.eatenCount())) {
            return Integer.compare(count2, count1);
        }
        return citizen1.getName().compareTo(citizen2.getName());
    }

    protected int compareFood(ItemStack stack1, ItemStack stack2) {
        int count2;
        int count1 = this.colonyFoodData.getEatenCitizens(stack1.m_41720_()).size();
        if (count1 != (count2 = this.colonyFoodData.getEatenCitizens(stack2.m_41720_()).size())) {
            return Integer.compare(count2, count1);
        }
        return this.colonyFoodData.compareFood(stack1, stack2);
    }

    protected void updateCitizenRow(Pane row, ICitizenDataView citizen) {
        ICitizenFoodDataView foodData = this.colonyFoodData.getFoodData(citizen);
        Text nameLabel = (Text)row.findPaneOfTypeByID(TEXT_CITIZEN_NAME, Text.class);
        nameLabel.setText(Component.m_237113_((String)citizen.getName()));
        Text statusLabel1 = (Text)row.findPaneOfTypeByID(TEXT_CITIZEN_STATUS_1, Text.class);
        Text statusLabel2 = (Text)row.findPaneOfTypeByID(TEXT_CITIZEN_STATUS_2, Text.class);
        if (foodData != null) {
            int count = foodData.eatenCount();
            boolean complete = count >= this.maxCount;
            statusLabel1.setText(Component.m_237110_((String)"minecolonies_sol.gui.eaten_count", (Object[])new Object[]{Component.m_237113_((String)(count + " / " + this.maxCount)).m_130940_(complete ? ChatFormatting.GREEN : ChatFormatting.WHITE)}));
            statusLabel2.setText(Component.m_237110_((String)"minecolonies_sol.gui.bonus_heart", (Object[])new Object[]{IMineColoniesSoLAPI.instance().getBonusHearts(foodData.milestone())}));
        } else {
            statusLabel1.setText(Component.m_237119_());
            statusLabel2.setText(Component.m_237119_());
        }
    }

    protected void updateFoodRow(Pane row, ItemStack stack) {
        Text nameLabel = (Text)row.findPaneOfTypeByID(TEXT_FOOD_NAME, Text.class);
        nameLabel.setText(stack.m_41786_());
        ItemIcon foodIcon = (ItemIcon)row.findPaneOfTypeByID(ICON_FOOD, ItemIcon.class);
        foodIcon.setItem(stack);
        Text stautsLabel = (Text)row.findPaneOfTypeByID(TEXT_FOOD_STATUS, Text.class);
        boolean complete = this.colonyFoodData.isCompletedFood(stack.m_41720_());
        stautsLabel.setText(Component.m_237110_((String)"minecolonies_sol.gui.ate_count", (Object[])new Object[]{Component.m_237113_((String)(this.colonyFoodData.getEatenCitizens(stack.m_41720_()).size() + " / " + this.colonyFoodData.getCitizenCount())).m_130940_(complete ? ChatFormatting.GREEN : ChatFormatting.WHITE)}));
    }

    public void close() {
        if (this.parent != null) {
            this.parent.open();
            return;
        }
        super.close();
    }
}

