/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_solcarrot.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.ICitizenDataView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_solcarrot.api.common.colony.ICitizenFoodDataView;
import steve_gall.minecolonies_solcarrot.core.client.gui.ColonyFoodData;
import steve_gall.minecolonies_solcarrot.core.client.gui.FoodNoniconWindow;
import steve_gall.minecolonies_solcarrot.core.common.MineColoniesSoL;

public class FoodNoniconFoodsWindow
extends FoodNoniconWindow {
    private final TextField inputField;
    private final Button exceptCompletedButton;
    private final Text foodText;
    private final ScrollingList foodList;
    private final Text ateCitizenText;
    private final ScrollingList ateCitizenList;
    private final Text notAteCitizenText;
    private final ScrollingList notAteCitizenList;
    private final List<ItemStack> filteredFoods = new ArrayList<ItemStack>();
    private final List<ICitizenDataView> ateCitizens = new ArrayList<ICitizenDataView>();
    private final List<ICitizenDataView> notAteCitizens = new ArrayList<ICitizenDataView>();
    private boolean exceptCompleted = false;
    private int inputFilterRequested = 0;
    private int selectedFoodIndex = -1;
    private int lastCitizenFoodIndex = -1;

    public FoodNoniconFoodsWindow(ColonyFoodData foodData, @Nullable BOWindow parent) {
        super(foodData, MineColoniesSoL.rl("gui/foo_nomicon_foods_window.xml").toString(), parent);
        this.inputField = (TextField)this.window.findPaneOfTypeByID("input", TextField.class);
        this.exceptCompletedButton = (Button)this.window.findPaneOfTypeByID("exceptCompleted", Button.class);
        this.foodText = (Text)this.findPaneOfTypeByID("foodsText", Text.class);
        this.foodList = (ScrollingList)this.window.findPaneOfTypeByID("foods", ScrollingList.class);
        this.ateCitizenText = (Text)this.findPaneOfTypeByID("ateCitizensText", Text.class);
        this.ateCitizenList = (ScrollingList)this.window.findPaneOfTypeByID("ateCitizens", ScrollingList.class);
        this.notAteCitizenText = (Text)this.findPaneOfTypeByID("notAteCitizensText", Text.class);
        this.notAteCitizenList = (ScrollingList)this.window.findPaneOfTypeByID("notAteCitizens", ScrollingList.class);
        this.inputField.setHandler(this::onFieldInput);
        this.foodList.setDataProvider(this.filteredFoods::size, this::updateFoodRow);
        this.ateCitizenList.setDataProvider(this.ateCitizens::size, this::updateAteRow);
        this.notAteCitizenList.setDataProvider(this.notAteCitizens::size, this::updateNotAteRow);
    }

    public void onOpened() {
        super.onOpened();
        this.inputField.setFocus();
        this.onExceptCompletedChanged();
        int citizenCount = this.colonyFoodData.getCitizenCount();
        this.ateCitizenText.setText(Component.m_237110_((String)"minecolonies_sol.gui.ate_citizens", (Object[])new Object[]{this.ateCitizens.size(), citizenCount}));
        this.notAteCitizenText.setText(Component.m_237110_((String)"minecolonies_sol.gui.not_ate_citizens", (Object[])new Object[]{this.notAteCitizens.size(), citizenCount}));
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.inputFilterRequested > 0 && --this.inputFilterRequested == 0) {
            this.updateFoodList();
        }
        this.updateCitizenList();
    }

    public boolean click(double mx, double my) {
        boolean b = super.click(mx, my);
        if (b) {
            return b;
        }
        int foodIndex = this.getHoveredRow(this.foodList);
        if (foodIndex > -1) {
            this.selectedFoodIndex = foodIndex;
            this.updateCitizenList();
            return true;
        }
        return false;
    }

    @Override
    public void onButtonClicked(Button button) {
        super.onButtonClicked(button);
        if (Objects.equals(button.getID(), "exceptCompleted")) {
            this.exceptCompleted ^= true;
            this.onExceptCompletedChanged();
        }
    }

    private void onExceptCompletedChanged() {
        boolean excpet = this.exceptCompleted;
        this.exceptCompletedButton.setText(excpet ? O : X);
        this.exceptCompletedButton.setColors((excpet ? ChatFormatting.BLACK : ChatFormatting.RED).m_126665_().intValue());
        this.updateFoodList();
    }

    protected void onFieldInput(TextField input) {
        if (input == this.inputField) {
            this.inputFilterRequested = 10;
        }
    }

    protected void updateFoodList() {
        this.selectedFoodIndex = -1;
        this.filteredFoods.clear();
        String field = this.inputField.getText().toLowerCase(Locale.ENGLISH);
        ItemStack[] allFoods = (ItemStack[])this.colonyFoodData.getAllFoods().stream().filter(this::testFoodForList).toArray(ItemStack[]::new);
        Arrays.stream(allFoods).filter(i -> this.filterFood(field, (ItemStack)i)).forEach(this.filteredFoods::add);
        this.filteredFoods.sort(this::compareFood);
        this.foodList.setScrollY(0.0);
        this.foodList.refreshElementPanes();
        this.foodText.setText(Component.m_237110_((String)"minecolonies_sol.gui.foods", (Object[])new Object[]{this.filteredFoods.size(), allFoods.length}));
    }

    protected void updateCitizenList() {
        int foodIndex = this.selectedFoodIndex;
        if (this.lastCitizenFoodIndex == foodIndex) {
            return;
        }
        this.lastCitizenFoodIndex = foodIndex;
        this.ateCitizens.clear();
        this.notAteCitizens.clear();
        if (foodIndex > -1) {
            ItemStack stack = this.filteredFoods.get(foodIndex);
            for (Map.Entry<ICitizenDataView, ICitizenFoodDataView> entry : this.colonyFoodData.getCitizenFoodEntrySet()) {
                (entry.getValue().wasEaten(stack.m_41720_()) ? this.ateCitizens : this.notAteCitizens).add(entry.getKey());
            }
        }
        int citizenCount = this.colonyFoodData.getCitizenCount();
        this.ateCitizens.sort(this::compareCitizen);
        this.ateCitizenList.setScrollY(0.0);
        this.ateCitizenList.refreshElementPanes();
        this.ateCitizenText.setText(Component.m_237110_((String)"minecolonies_sol.gui.ate_citizens", (Object[])new Object[]{this.ateCitizens.size(), citizenCount}));
        this.notAteCitizens.sort(this::compareCitizen);
        this.notAteCitizenList.setScrollY(0.0);
        this.notAteCitizenList.refreshElementPanes();
        this.notAteCitizenText.setText(Component.m_237110_((String)"minecolonies_sol.gui.not_ate_citizens", (Object[])new Object[]{this.notAteCitizens.size(), citizenCount}));
    }

    protected boolean filterFood(String filter, ItemStack stack) {
        if (filter.isEmpty()) {
            return true;
        }
        return stack.m_41786_().getString().toLowerCase().contains(filter.toLowerCase());
    }

    protected boolean testFoodForList(ItemStack stack) {
        return !this.exceptCompleted || !this.colonyFoodData.isCompletedFood(stack.m_41720_());
    }

    protected void updateFoodRow(int index, Pane row) {
        ItemStack food = this.filteredFoods.get(index);
        this.updateFoodRow(row, food);
        Text nameLabel = (Text)row.findPaneOfTypeByID("foodName", Text.class);
        nameLabel.setColors(this.getFoodLabelColor(food, index).m_126665_().intValue());
    }

    protected void updateAteRow(int index, Pane row) {
        ICitizenDataView citizen = this.ateCitizens.get(index);
        this.updateCitizenRow(row, citizen);
    }

    protected void updateNotAteRow(int index, Pane row) {
        ICitizenDataView citizen = this.notAteCitizens.get(index);
        this.updateCitizenRow(row, citizen);
    }

    protected ChatFormatting getFoodLabelColor(ItemStack stack, int index) {
        return this.selectedFoodIndex == index ? ChatFormatting.GOLD : ChatFormatting.WHITE;
    }
}

