/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_solcarrot.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.ICitizenDataView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_solcarrot.api.common.colony.ICitizenFoodDataView;
import steve_gall.minecolonies_solcarrot.core.client.gui.ColonyFoodData;
import steve_gall.minecolonies_solcarrot.core.client.gui.FoodNoniconWindow;
import steve_gall.minecolonies_solcarrot.core.common.MineColoniesSoL;

public class FoodNoniconCitizensWindow
extends FoodNoniconWindow {
    private final TextField inputField;
    private final Button exceptCompletedButton;
    private final Text citizenText;
    private final ScrollingList citizenList;
    private final Text eatenFoodText;
    private final ScrollingList eatenFoodList;
    private final Text notEatenFoodText;
    private final ScrollingList notEatenFoodList;
    private final List<ICitizenDataView> filteredCitizens = new ArrayList<ICitizenDataView>();
    private final List<ItemStack> eatenFoods = new ArrayList<ItemStack>();
    private final List<ItemStack> notEatenFoods = new ArrayList<ItemStack>();
    private boolean exceptCompleted = false;
    private int inputFilterRequested = 0;
    private int selectedCitizenIndex = -1;
    private int lastFoodCitizenIndex = -1;

    public FoodNoniconCitizensWindow(ColonyFoodData foodData, @Nullable BOWindow parent) {
        super(foodData, MineColoniesSoL.rl("gui/foo_nomicon_citizens_window.xml").toString(), parent);
        this.inputField = (TextField)this.window.findPaneOfTypeByID("input", TextField.class);
        this.exceptCompletedButton = (Button)this.window.findPaneOfTypeByID("exceptCompleted", Button.class);
        this.citizenText = (Text)this.findPaneOfTypeByID("citizensText", Text.class);
        this.citizenList = (ScrollingList)this.window.findPaneOfTypeByID("citizens", ScrollingList.class);
        this.eatenFoodText = (Text)this.findPaneOfTypeByID("eatenFoodsText", Text.class);
        this.eatenFoodList = (ScrollingList)this.window.findPaneOfTypeByID("eatenFoods", ScrollingList.class);
        this.notEatenFoodText = (Text)this.findPaneOfTypeByID("notEatenFoodsText", Text.class);
        this.notEatenFoodList = (ScrollingList)this.window.findPaneOfTypeByID("notEatenFoods", ScrollingList.class);
        this.inputField.setHandler(this::onFieldInput);
        this.citizenList.setDataProvider(this.filteredCitizens::size, this::updateCitizenRow);
        this.eatenFoodList.setDataProvider(this.eatenFoods::size, this::updateEatenRow);
        this.notEatenFoodList.setDataProvider(this.notEatenFoods::size, this::updateNotEatenRow);
    }

    public void onOpened() {
        super.onOpened();
        this.inputField.setFocus();
        this.onExceptCompletedChanged();
        List<ItemStack> allFoods = this.colonyFoodData.getAllFoods();
        this.eatenFoodText.setText(Component.m_237110_((String)"minecolonies_sol.gui.eaten_foods", (Object[])new Object[]{this.eatenFoods.size(), allFoods.size()}));
        this.notEatenFoodText.setText(Component.m_237110_((String)"minecolonies_sol.gui.not_eaten_foods", (Object[])new Object[]{this.notEatenFoods.size(), allFoods.size()}));
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.inputFilterRequested > 0 && --this.inputFilterRequested == 0) {
            this.updateCitizenList();
        }
        this.updateFoodList();
    }

    public boolean click(double mx, double my) {
        boolean b = super.click(mx, my);
        if (b) {
            return b;
        }
        int citizenIndex = this.getHoveredRow(this.citizenList);
        if (citizenIndex > -1) {
            this.selectedCitizenIndex = citizenIndex;
            this.updateFoodList();
            return true;
        }
        return false;
    }

    @Override
    public void onButtonClicked(Button button) {
        super.onButtonClicked(button);
        if (Objects.equals(button.getID(), "exceptCompleted")) {
            this.exceptCompleted ^= true;
            this.onExceptCompletedChanged();
        }
    }

    private void onExceptCompletedChanged() {
        boolean excpet = this.exceptCompleted;
        this.exceptCompletedButton.setText(excpet ? O : X);
        this.exceptCompletedButton.setColors((excpet ? ChatFormatting.BLACK : ChatFormatting.RED).m_126665_().intValue());
        this.updateCitizenList();
    }

    protected void onFieldInput(TextField input) {
        if (input == this.inputField) {
            this.inputFilterRequested = 10;
        }
    }

    protected void updateCitizenList() {
        this.selectedCitizenIndex = -1;
        this.filteredCitizens.clear();
        String field = this.inputField.getText().toLowerCase(Locale.ENGLISH);
        ICitizenDataView[] citizens = (ICitizenDataView[])this.colonyFoodData.getCitizenFoodEntrySet().stream().map(Map.Entry::getKey).filter(this::testCitizenForList).toArray(ICitizenDataView[]::new);
        Arrays.stream(citizens).filter(i -> this.filterCitizen(field, (ICitizenDataView)i)).forEach(this.filteredCitizens::add);
        this.filteredCitizens.sort(this::compareCitizen);
        this.citizenList.setScrollY(0.0);
        this.citizenList.refreshElementPanes();
        this.citizenText.setText(Component.m_237110_((String)"minecolonies_sol.gui.citizens", (Object[])new Object[]{this.filteredCitizens.size(), citizens.length}));
    }

    protected void updateFoodList() {
        int citizenIndex = this.selectedCitizenIndex;
        if (this.lastFoodCitizenIndex == citizenIndex) {
            return;
        }
        this.lastFoodCitizenIndex = citizenIndex;
        this.eatenFoods.clear();
        this.notEatenFoods.clear();
        List<ItemStack> allFoods = this.colonyFoodData.getAllFoods();
        if (citizenIndex > -1) {
            ICitizenDataView citizen = this.filteredCitizens.get(citizenIndex);
            ICitizenFoodDataView foodData = this.colonyFoodData.getFoodData(citizen);
            for (ItemStack item : allFoods) {
                (foodData.wasEaten(item.m_41720_()) ? this.eatenFoods : this.notEatenFoods).add(item);
            }
        }
        this.eatenFoods.sort(this::compareFood);
        this.notEatenFoods.sort(this::compareFood);
        this.eatenFoodList.setScrollY(0.0);
        this.eatenFoodList.refreshElementPanes();
        this.eatenFoodText.setText(Component.m_237110_((String)"minecolonies_sol.gui.eaten_foods", (Object[])new Object[]{this.eatenFoods.size(), allFoods.size()}));
        this.notEatenFoodList.setScrollY(0.0);
        this.notEatenFoodList.refreshElementPanes();
        this.notEatenFoodText.setText(Component.m_237110_((String)"minecolonies_sol.gui.not_eaten_foods", (Object[])new Object[]{this.notEatenFoods.size(), allFoods.size()}));
    }

    protected boolean filterCitizen(String filter, ICitizenDataView citizen) {
        if (filter.isEmpty()) {
            return true;
        }
        return citizen.getName().toLowerCase().contains(filter.toLowerCase());
    }

    protected boolean testCitizenForList(ICitizenDataView citizen) {
        ICitizenFoodDataView foodData = this.colonyFoodData.getFoodData(citizen);
        if (foodData == null) {
            return false;
        }
        return !this.exceptCompleted || !foodData.milestoneComplete();
    }

    protected void updateCitizenRow(int index, Pane row) {
        ICitizenDataView citizen = this.filteredCitizens.get(index);
        if (citizen == null) {
            return;
        }
        this.updateCitizenRow(row, citizen);
        Text nameLabel = (Text)row.findPaneOfTypeByID("citizenName", Text.class);
        nameLabel.setColors(this.getCitizenLabelColor(citizen, index).m_126665_().intValue());
    }

    protected void updateEatenRow(int index, Pane row) {
        ItemStack item = this.eatenFoods.get(index);
        this.updateFoodRow(row, item);
    }

    protected void updateNotEatenRow(int index, Pane row) {
        ItemStack item = this.notEatenFoods.get(index);
        this.updateFoodRow(row, item);
    }

    protected ChatFormatting getCitizenLabelColor(ICitizenDataView citizen, int index) {
        return this.selectedCitizenIndex == index ? ChatFormatting.GOLD : ChatFormatting.WHITE;
    }
}

