/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_solcarrot.core.client.gui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import steve_gall.minecolonies_solcarrot.api.common.IMineColoniesSoLAPI;
import steve_gall.minecolonies_solcarrot.api.common.colony.ICitizenFoodDataView;

public class ColonyFoodData {
    private final IColonyView colony;
    private final Map<ICitizenDataView, ICitizenFoodDataView> citizenFoodMap = new HashMap<ICitizenDataView, ICitizenFoodDataView>();
    private final Map<Item, Set<ICitizenDataView>> foodCitizensMap = new HashMap<Item, Set<ICitizenDataView>>();
    private final List<ItemStack> allFoods;
    private final Map<Item, String> nameCache = new HashMap<Item, String>();

    public ColonyFoodData(IColonyView colony) {
        this.colony = colony;
        ArrayList<ItemStack> allFoods = new ArrayList<ItemStack>();
        ForgeRegistries.ITEMS.getValues().stream().filter(IMineColoniesSoLAPI.instance()::shouldCount).map(ItemStack::new).forEach(allFoods::add);
        allFoods.forEach(i -> this.nameCache.put(i.m_41720_(), i.m_41786_().getString()));
        allFoods.sort(this::compareFood);
        this.allFoods = ImmutableList.copyOf(allFoods);
        HashMap foodCitizensMap = new HashMap();
        for (ItemStack itemStack : allFoods) {
            foodCitizensMap.put(itemStack.m_41720_(), new HashSet());
        }
        for (ICitizenDataView iCitizenDataView : colony.getCitizens().values()) {
            ICitizenFoodDataView foodData = IMineColoniesSoLAPI.instance().getFoodDataView(iCitizenDataView);
            this.citizenFoodMap.put(iCitizenDataView, foodData);
            for (Item item : foodData.getEatens()) {
                ((Set)foodCitizensMap.get(item)).add(iCitizenDataView);
            }
        }
        for (Map.Entry entry : foodCitizensMap.entrySet()) {
            this.foodCitizensMap.put((Item)entry.getKey(), (Set<ICitizenDataView>)ImmutableSet.copyOf((Collection)((Collection)entry.getValue())));
        }
    }

    public IColonyView getColony() {
        return this.colony;
    }

    public int compareFood(ItemStack stack1, ItemStack stack2) {
        String name1 = this.nameCache.get(stack1.m_41720_());
        String name2 = this.nameCache.get(stack2.m_41720_());
        return name1.compareTo(name2);
    }

    public boolean isCompletedFood(Item item) {
        return this.foodCitizensMap.get(item).size() >= this.getCitizenCount();
    }

    public int getCitizenCount() {
        return this.citizenFoodMap.size();
    }

    public ICitizenFoodDataView getFoodData(ICitizenDataView citizen) {
        return this.citizenFoodMap.get(citizen);
    }

    public Set<ICitizenDataView> getEatenCitizens(Item item) {
        return this.foodCitizensMap.get(item);
    }

    public List<ItemStack> getAllFoods() {
        return this.allFoods;
    }

    public Set<Map.Entry<ICitizenDataView, ICitizenFoodDataView>> getCitizenFoodEntrySet() {
        return this.citizenFoodMap.entrySet();
    }

    public Set<Map.Entry<Item, Set<ICitizenDataView>>> getFoodCitizensEntrySet() {
        return this.foodCitizensMap.entrySet();
    }
}

