/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.fertilization.item;

import java.util.List;
import net.blay09.mods.fertilization.BoneMealHelper;
import net.blay09.mods.fertilization.FertilizationConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.jetbrains.annotations.Nullable;

public class FloristsBoneMealItem
extends Item {
    public FloristsBoneMealItem(Item.Properties properties) {
        super(properties);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource source, ItemStack itemStack) {
                this.m_123573_(true);
                ServerLevel level = source.m_7727_();
                BlockPos pos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                BlockState state = level.m_8055_(pos);
                if (state.m_60795_()) {
                    pos = pos.m_7495_();
                    state = level.m_8055_(pos);
                }
                if (!FloristsBoneMealItem.this.applyBoneMeal((Level)level, pos, state, itemStack, null)) {
                    this.m_123573_(false);
                }
                return itemStack;
            }
        });
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        InteractionHand hand = context.m_43724_();
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof DoublePlantBlock && state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER) {
            state = level.m_8055_(pos.m_7495_());
        }
        if (this.applyBoneMeal(level, pos, state, player.m_21120_(hand), player)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean applyBoneMeal(Level level, BlockPos pos, BlockState state, ItemStack itemStack, @Nullable Player player) {
        if (FertilizationConfig.getActive().isFlowerBlock(state.m_60734_())) {
            if (!level.f_46443_) {
                List drops = Block.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null);
                for (ItemStack drop : drops) {
                    ItemEntity entityItem = new ItemEntity(level, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.25f), (double)((float)pos.m_123343_() + 0.5f), drop);
                    level.m_7967_((Entity)entityItem);
                }
                if (player == null || !player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                level.m_46796_(2005, pos, 0);
            }
            return true;
        }
        if (BoneMealHelper.isGrassBlock(state)) {
            if (!level.f_46443_) {
                RandomSource random = level.f_46441_;
                int tries = FertilizationConfig.getActive().floristsBoneMealMaxFlowers;
                int range = FertilizationConfig.getActive().floristsBoneMealMaxRange;
                boolean spawnedAnyFlower = false;
                for (int i = 0; i < tries; ++i) {
                    BlockPos flowerPos = new BlockPos(pos.m_123341_() + random.m_188503_(range * 2) - range, pos.m_123342_() + 1, pos.m_123343_() + random.m_188503_(range * 2) - range);
                    if (!level.m_46859_(flowerPos) || !BoneMealHelper.isGrassBlock(level.m_8055_(flowerPos.m_7495_()))) continue;
                    this.plantFlower((ServerLevel)level, flowerPos, random);
                    spawnedAnyFlower = true;
                }
                if (spawnedAnyFlower) {
                    level.m_46796_(2005, pos, 0);
                } else {
                    level.m_46796_(2000, pos.m_7494_(), 4);
                }
            }
            if (player == null || !player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            return true;
        }
        return false;
    }

    private void plantFlower(ServerLevel level, BlockPos pos, RandomSource rand) {
        List list = ((Biome)level.m_204166_(pos).m_203334_()).m_47536_().m_47815_();
        if (list.isEmpty()) {
            return;
        }
        ConfiguredFeature configuredFeature = (ConfiguredFeature)list.get(0);
        FeatureConfiguration config = configuredFeature.f_65378_();
        PlacedFeature placedFeature = (PlacedFeature)((RandomPatchConfiguration)config).f_191304_().m_203334_();
        placedFeature.m_226357_((WorldGenLevel)level, level.m_7726_().m_8481_(), rand, pos);
    }
}

