/*
 * Decompiled with CFR 0.152.
 */
package actuallyharvest.util;

import actuallyharvest.common.TagManager;
import actuallyharvest.config.ConfigHandler;
import com.google.common.collect.BiMap;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import technology.roughness.whitenoise.platform.Services;

public class BlockHelper {
    public static boolean isVanilla(Block block) {
        return BlockHelper.getBlockId(block).m_135827_().equals("minecraft");
    }

    public static boolean isBottomBlock(Block block) {
        return BlockHelper.getBlockId(block).m_135815_().contains("_bottom");
    }

    public static ResourceLocation getBlockId(Block block) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)block);
    }

    public static String[] parseBlockString(String blockString) {
        boolean inBracket = false;
        for (int i = 0; i < blockString.length(); ++i) {
            char c = blockString.charAt(i);
            if (c == '[') {
                inBracket = true;
                continue;
            }
            if (c == ']') {
                inBracket = false;
                continue;
            }
            if (c != ',' || inBracket) continue;
            return new String[]{blockString.substring(0, i), blockString.substring(i + 1)};
        }
        return new String[]{blockString};
    }

    public static BlockState fromString(String key) {
        try {
            BlockStateParser.BlockResult result = BlockStateParser.m_234691_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (StringReader)new StringReader(key), (boolean)false);
            return result.f_234748_();
        }
        catch (CommandSyntaxException e) {
            return Blocks.f_50016_.m_49966_();
        }
    }

    public static BlockState getToolModifiedState(BlockState state, UseOnContext context, String toolActionType, boolean simulate) {
        return switch (toolActionType) {
            case "axe_strip" -> BlockHelper.getAxeStrippingState(state);
            case "axe_scrape" -> WeatheringCopper.m_154899_((BlockState)state).orElse(null);
            case "axe_wax_off" -> Optional.ofNullable((Block)((BiMap)HoneycombItem.f_150864_.get()).get((Object)state.m_60734_())).map(block -> block.m_152465_(state)).orElse(null);
            case "shovel_flatten" -> BlockHelper.getShovelPathingState(state);
            case "hoe_till" -> {
                Block block = state.m_60734_();
                if (block == Blocks.f_152549_) {
                    if (!simulate && !context.m_43725_().f_46443_) {
                        Block.m_152435_((Level)context.m_43725_(), (BlockPos)context.m_8083_(), (Direction)context.m_43719_(), (ItemStack)new ItemStack((ItemLike)Items.f_151017_));
                    }
                    yield Blocks.f_50493_.m_49966_();
                }
                if ((block == Blocks.f_50440_ || block == Blocks.f_152481_ || block == Blocks.f_50493_ || block == Blocks.f_50546_) && context.m_43725_().m_8055_(context.m_8083_().m_7494_()).m_60795_()) {
                    if (block == Blocks.f_50546_) {
                        yield Blocks.f_50493_.m_49966_();
                    }
                    yield Blocks.f_50093_.m_49966_();
                }
                yield null;
            }
            default -> null;
        };
    }

    public static InteractionType getInteractionTypeForBlock(BlockState state, boolean canRightClick) {
        if (state.m_204336_(TagManager.Blocks.HARVEST_BLACKLIST)) {
            return InteractionType.NONE;
        }
        if (canRightClick && ConfigHandler.Common.getRightClickBlocks().contains(state.m_60734_())) {
            return InteractionType.CLICK;
        }
        if (ConfigHandler.Common.getCrops().containsKey(state)) {
            return InteractionType.HARVEST;
        }
        return InteractionType.NONE;
    }

    public static boolean playerCanHarvest(Player player) {
        if (ConfigHandler.Common.allowFakePlayer()) {
            return true;
        }
        return !Services.PLATFORM.isFakePlayer(player);
    }

    private static BlockState getAxeStrippingState(BlockState state) {
        Block block = (Block)AxeItem.f_150683_.get(state.m_60734_());
        return block != null ? (BlockState)block.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_))) : null;
    }

    private static BlockState getShovelPathingState(BlockState state) {
        return (BlockState)ShovelItem.f_43110_.get(state.m_60734_());
    }

    public static boolean isBlockItem(ItemStack stack) {
        return Block.m_49814_((Item)stack.m_41720_()) instanceof Block;
    }

    public static enum InteractionType {
        NONE,
        CLICK,
        HARVEST;

    }
}

