/*
 * Decompiled with CFR 0.152.
 */
package actuallyharvest.event;

import actuallyharvest.ActuallyHarvest;
import actuallyharvest.config.ConfigHandler;
import actuallyharvest.event.ClickResult;
import actuallyharvest.util.BlockHelper;
import actuallyharvest.util.ToolHelper;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class HarvestEventHandler {
    private static boolean isHarvesting = false;

    public static ClickResult rightClickBlock(Player player, InteractionHand hand, BlockPos pos, BlockHitResult hitResult) {
        if (player.m_9236_().m_5776_() || isHarvesting || !BlockHelper.playerCanHarvest(player)) {
            return ClickResult.pass();
        }
        isHarvesting = true;
        ClickResult result = HarvestEventHandler.getClickResult(player, hand, pos, hitResult);
        isHarvesting = false;
        return result;
    }

    private static ClickResult getClickResult(Player player, InteractionHand hand, BlockPos pos, BlockHitResult hitResult) {
        if (player == null || hand == null || player.m_5833_()) {
            return ClickResult.pass();
        }
        if (hitResult.m_6662_() != HitResult.Type.BLOCK || !hitResult.m_82425_().equals((Object)pos)) {
            return ClickResult.pass();
        }
        Level level = player.m_9236_();
        BlockState blockState = level.m_8055_(pos);
        BlockState modifiedState = BlockHelper.getToolModifiedState(blockState, new UseOnContext(player, hand, hitResult), "hoe_till", true);
        if (modifiedState != null) {
            return ClickResult.pass();
        }
        ItemStack heldStack = player.m_21120_(hand);
        boolean isHoe = ToolHelper.isHoe(heldStack);
        if (!ConfigHandler.Common.allowEmptyHand() && !isHoe) {
            return ClickResult.pass();
        }
        BlockState above = level.m_8055_(pos.m_7494_());
        int range = 1;
        if (isHoe) {
            if (BlockHelper.getInteractionTypeForBlock(blockState, true) == BlockHelper.InteractionType.NONE && BlockHelper.getInteractionTypeForBlock(above, true) == BlockHelper.InteractionType.NONE) {
                return ClickResult.pass();
            }
            range = ToolHelper.getRange(heldStack);
        }
        boolean harvested = false;
        for (int x = 1 - range; x < range; ++x) {
            for (int z = 1 - range; z < range; ++z) {
                BlockPos shiftPos = pos.m_7918_(x, 0, z);
                if (!HarvestEventHandler.tryHarvest(level, shiftPos, (LivingEntity)player, hand, range > 1)) {
                    if (!HarvestEventHandler.tryHarvest(level, shiftPos = shiftPos.m_7494_(), (LivingEntity)player, hand, range > 1)) continue;
                    harvested = true;
                    continue;
                }
                harvested = true;
            }
        }
        if (!harvested) {
            return ClickResult.pass();
        }
        if (BlockHelper.isBlockItem(heldStack)) {
            return ClickResult.pass();
        }
        return ClickResult.interrupt();
    }

    private static boolean tryHarvest(Level level, BlockPos pos, @Nullable LivingEntity entity, @Nullable InteractionHand hand, boolean canReach) {
        Player player;
        if (entity instanceof Player && !level.m_7966_(player = (Player)entity, pos)) {
            return false;
        }
        BlockState blockState = level.m_8055_(pos);
        BlockHelper.InteractionType interactionType = BlockHelper.getInteractionTypeForBlock(blockState, canReach);
        if (interactionType != BlockHelper.InteractionType.NONE) {
            if (interactionType == BlockHelper.InteractionType.HARVEST) {
                if (entity instanceof Player) {
                    return HarvestEventHandler.harvestAndReplant(level, pos, blockState, entity, hand);
                }
            } else if (interactionType == BlockHelper.InteractionType.CLICK && entity instanceof Player) {
                BlockHitResult hitResult = new BlockHitResult(Vec3.m_82512_((Vec3i)pos), Direction.UP, pos, true);
                if (hand == null) {
                    hand = InteractionHand.MAIN_HAND;
                }
                if (entity instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)entity;
                    return sp.f_8941_.m_7179_(sp, sp.m_9236_(), sp.m_21120_(hand), hand, hitResult).m_19077_();
                }
            }
        }
        return false;
    }

    private static boolean harvestAndReplant(Level level, BlockPos pos, BlockState blockState, LivingEntity entity, InteractionHand hand) {
        BlockState cropBlockState = ConfigHandler.Common.getCrops().get(blockState);
        BlockState above = level.m_8055_(pos.m_7494_());
        BooleanProperty top = BooleanProperty.m_61465_((String)"top");
        if (above.m_60734_() instanceof CropBlock) {
            cropBlockState = ConfigHandler.Common.getCrops().get(above);
        }
        if (cropBlockState == null) {
            return false;
        }
        if (level instanceof ServerLevel) {
            ItemStack copy;
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack heldStack = null;
            if (entity == null || hand == null) {
                copy = new ItemStack((ItemLike)Items.f_42398_);
            } else {
                heldStack = entity.m_21120_(hand);
                if (ConfigHandler.Common.isBlacklistHeldItem(heldStack)) {
                    return false;
                }
                copy = entity.m_21120_(hand).m_41777_();
            }
            MutableBoolean hasTaken = new MutableBoolean(false);
            Item blockItem = blockState.m_60734_().m_5456_();
            boolean dropXp = entity instanceof Player;
            if (!cropBlockState.m_61138_((Property)top)) {
                Block.m_49874_((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)level.m_7702_(pos), (Entity)entity, (ItemStack)copy).forEach(stack -> {
                    if (stack.m_41720_() == blockItem && !hasTaken.getValue().booleanValue()) {
                        stack.m_41774_(1);
                        hasTaken.setValue(true);
                    }
                    if (!stack.m_41619_()) {
                        Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
                    }
                });
                blockState.m_222967_(serverLevel, pos, copy, dropXp);
            }
            if (dropXp && ConfigHandler.Common.xpFromHarvestUseRange()) {
                int xp = ThreadLocalRandom.current().nextInt((Integer)ConfigHandler.Common.xpFromHarvestRangeAmount().getLeft(), (Integer)ConfigHandler.Common.xpFromHarvestRangeAmount().getRight() + 1);
                if (xp > 0) {
                    ExperienceOrb.m_147082_((ServerLevel)serverLevel, (Vec3)Vec3.m_82512_((Vec3i)pos), (int)xp);
                }
            } else if (dropXp && ActuallyHarvest.RANDOM.nextInt(100) + 1 <= ConfigHandler.Common.xpFromHarvestChance()) {
                ExperienceOrb.m_147082_((ServerLevel)serverLevel, (Vec3)Vec3.m_82512_((Vec3i)pos), (int)ConfigHandler.Common.xpFromHarvestAmount());
            }
            if (cropBlockState.m_61138_((Property)DoublePlantBlock.f_52858_)) {
                BlockPos blockPos = pos;
                if (cropBlockState.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER) {
                    blockPos = pos.m_7495_();
                }
                BlockState doubleBlockHalf = level.m_8055_(pos);
                level.m_46796_(2001, blockPos, Block.m_49956_((BlockState)doubleBlockHalf));
                level.m_220407_(GameEvent.f_157794_, blockPos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)doubleBlockHalf));
                level.m_46953_(blockPos, true, (Entity)entity);
                level.m_7731_(blockPos, (BlockState)doubleBlockHalf.m_60734_().m_49966_().m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER), 0);
            } else {
                level.m_46796_(2001, pos, Block.m_49956_((BlockState)cropBlockState));
                level.m_46597_(pos, cropBlockState);
                level.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)blockState));
            }
            if (cropBlockState.m_61138_((Property)top)) {
                level.m_46953_(pos, true, (Entity)entity);
            }
            if (!level.f_46443_ && heldStack != null && ConfigHandler.Common.damageTool() && ToolHelper.isHoe(heldStack)) {
                heldStack.m_41622_(1, entity, p -> p.m_21190_(InteractionHand.MAIN_HAND));
            }
        }
        return true;
    }
}

