/*
 * Decompiled with CFR 0.152.
 */
package actuallyharvest.config;

import actuallyharvest.mixin.DiggerItemAccessor;
import actuallyharvest.util.BlockHelper;
import actuallyharvest.util.ToolHelper;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;
import technology.roughness.whitenoise.config.WhiteNoiseConfigSpec;
import technology.roughness.whitenoise.util.ResourceLocationHelper;

public class ConfigHandler {
    public static final WhiteNoiseConfigSpec COMMON_SPEC;
    private static final Common COMMON;

    public static void init() {
        BooleanProperty upper = BooleanProperty.m_61465_((String)"upper");
        BooleanProperty top = BooleanProperty.m_61465_((String)"top");
        Common.crops.clear();
        Common.rightClickBlocks.clear();
        Common.hoeTools.clear();
        if (Common.autoConfigMods()) {
            for (Block block : BuiltInRegistries.f_256975_) {
                if (Common.isBlacklistMod(block) || Common.isBlacklistCrop(block)) continue;
                if (block instanceof CropBlock) {
                    CropBlock cropBlock = (CropBlock)block;
                    BlockState cropBlockstate = cropBlock.m_49966_();
                    BlockState maxAgeCropBlockstate = cropBlock.m_52289_(cropBlock.m_7419_());
                    if (cropBlockstate.m_61138_((Property)upper)) {
                        cropBlockstate = (BlockState)cropBlockstate.m_61124_((Property)upper, (Comparable)Boolean.valueOf(true));
                        maxAgeCropBlockstate = (BlockState)maxAgeCropBlockstate.m_61124_((Property)upper, (Comparable)Boolean.valueOf(true));
                    } else if (cropBlockstate.m_61138_((Property)top)) {
                        cropBlockstate = (BlockState)cropBlockstate.m_61124_((Property)top, (Comparable)Boolean.valueOf(true));
                        maxAgeCropBlockstate = (BlockState)maxAgeCropBlockstate.m_61124_((Property)top, (Comparable)Boolean.valueOf(true));
                    } else if (cropBlockstate.m_61138_((Property)DoublePlantBlock.f_52858_)) {
                        cropBlockstate = (BlockState)cropBlockstate.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER);
                        maxAgeCropBlockstate = (BlockState)maxAgeCropBlockstate.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER);
                    }
                    if (BlockHelper.isBottomBlock(block)) continue;
                    Common.crops.put(maxAgeCropBlockstate, cropBlockstate);
                    continue;
                }
                if (block instanceof CocoaBlock) {
                    CocoaBlock cocoaBlock = (CocoaBlock)block;
                    BlockStateProperties.f_61374_.m_61702_().forEach(direction -> {
                        BlockState zeroState = (BlockState)((BlockState)cocoaBlock.m_49966_().m_61124_((Property)CocoaBlock.f_51736_, (Comparable)Integer.valueOf(0))).m_61124_((Property)CocoaBlock.f_54117_, (Comparable)((Direction)direction.f_61713_()));
                        BlockState maxAgeState = (BlockState)((BlockState)cocoaBlock.m_49966_().m_61124_((Property)CocoaBlock.f_51736_, (Comparable)Integer.valueOf(2))).m_61124_((Property)CocoaBlock.f_54117_, (Comparable)((Direction)direction.f_61713_()));
                        Common.crops.put(maxAgeState, zeroState);
                    });
                    continue;
                }
                if (!(block instanceof BushBlock) && !(block instanceof GrowingPlantBlock) || !(block instanceof BonemealableBlock)) continue;
                Common.rightClickBlocks.add(block);
            }
        }
        for (String cropKey : (List)ConfigHandler.COMMON.harvestableCrops.get()) {
            String[] parts = BlockHelper.parseBlockString(cropKey);
            BlockState initial = BlockHelper.fromString(cropKey);
            Block block = initial.m_60734_();
            if (block == Blocks.f_50016_ || Common.isBlacklistCrop(block) || Common.isBlacklistMod(block)) continue;
            BlockState result = parts.length > 1 ? BlockHelper.fromString(parts[1]) : block.m_49966_();
            Common.crops.put(initial, result);
        }
        for (String blockKey : (List)ConfigHandler.COMMON.harvestableBlocks.get()) {
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocationHelper.mcLoc((String)blockKey));
            if (block == Blocks.f_50016_ || Common.isBlacklistCrop(block) || Common.isBlacklistMod(block)) continue;
            Common.rightClickBlocks.add(block);
        }
        BuiltInRegistries.f_257033_.forEach(item -> {
            DiggerItem digger;
            DiggerItemAccessor diggerAccessor;
            if (item instanceof DiggerItem && (diggerAccessor = (DiggerItemAccessor)(digger = (DiggerItem)item)).getBlocks() == BlockTags.f_144281_) {
                int tier = 0;
                try {
                    tier = digger.m_43314_().m_6604_();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Common.hoeTools.put((Item)digger, ToolHelper.getBaseRange(tier));
            }
        });
        for (String hoeItem : (List)ConfigHandler.COMMON.hoeItems.get()) {
            String[] parts = hoeItem.split("-");
            int range = ToolHelper.getBaseRange(Integer.parseInt(parts[1]));
            ResourceLocation loc = ResourceLocationHelper.mcLoc((String)parts[0]);
            Item item2 = (Item)BuiltInRegistries.f_257033_.m_7745_(loc);
            Common.hoeTools.put(item2, range);
        }
    }

    static {
        Pair specPairCommon = new WhiteNoiseConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (WhiteNoiseConfigSpec)specPairCommon.getRight();
        COMMON = (Common)specPairCommon.getLeft();
    }

    public static class Common {
        private final WhiteNoiseConfigSpec.BooleanValue allowEmptyHand;
        private final WhiteNoiseConfigSpec.BooleanValue damageTool;
        private final WhiteNoiseConfigSpec.BooleanValue autoConfigMods;
        private final WhiteNoiseConfigSpec.IntValue xpFromHarvestChance;
        private final WhiteNoiseConfigSpec.IntValue xpFromHarvestAmount;
        private final WhiteNoiseConfigSpec.BooleanValue xpFromHarvestUseRange;
        private final WhiteNoiseConfigSpec.ConfigValue<String> xpFromHarvestRangeAmount;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> harvestableCrops;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> harvestableBlocks;
        private final WhiteNoiseConfigSpec.BooleanValue expandHoeRange;
        private final WhiteNoiseConfigSpec.IntValue smallTierExpansionRange;
        private final WhiteNoiseConfigSpec.IntValue highTierExpansionRange;
        private final WhiteNoiseConfigSpec.BooleanValue expandHoeRangeEnchanted;
        private final WhiteNoiseConfigSpec.IntValue maxHoeExpansionRange;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> hoeItems;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> blacklistCrops;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> blacklistMods;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> blacklistHeldItems;
        private final WhiteNoiseConfigSpec.BooleanValue allowFakePlayer;
        private static final Map<BlockState, BlockState> crops = Maps.newHashMap();
        private static final Set<Block> rightClickBlocks = Sets.newHashSet();
        private static final List<String> harvestableCropsList = List.of("harvestableCrops");
        private static final String[] defaultHarvestableCrops = new String[0];
        private static final List<String> harvestableBlocksList = List.of("harvestableBlocks");
        private static final String[] defaultHarvestableBlocks = new String[]{"minecraft:sweet_berry_bush", "minecraft:cave_vines"};
        private static final Predicate<Object> resourceLocationValidator = s -> s instanceof String && ((String)s).matches("[a-z]+[:]{1}[a-z_]+");
        private static final Predicate<Object> modidValidator = s -> s instanceof String && ((String)s).matches("^[a-z][a-z0-9_]{1,63}$");
        private static final Map<Item, Integer> hoeTools = Maps.newHashMap();
        private static final Predicate<Object> hoeItemValidator = s -> s instanceof String && ((String)s).matches("[a-z][a-z0-9_]{1,63}+[:]{1}[a-z_]+[-]{1}[0-9]+");
        private static final Predicate<Object> xpRangeValidator = s -> s instanceof String && ((String)s).matches("[0-9]+[-]{1}[0-9]+");
        private static final List<String> hoeItemList = List.of("hoeItems");
        private static final String[] defaultHoeItemList = new String[0];
        private static final List<String> blacklistCropsList = List.of("blacklistCrops");
        private static final String[] defaultBlacklistCrops = new String[0];
        private static final List<String> blacklistModsList = List.of("blacklistMods");
        private static final String[] defaultBlacklistMods = new String[0];
        private static final List<String> blacklistHeldItemsList = List.of("blacklistHeldItems");
        private static final String[] defaultBlacklistHeldItems = new String[0];

        public Common(WhiteNoiseConfigSpec.Builder builder) {
            builder.push("general");
            this.allowEmptyHand = builder.comment("Allow harvesting with empty hand. If disabled, requires hoe.").define("allowEmptyHand", true);
            this.damageTool = builder.comment("Harvesting crops costs durability.").define("damageTool", false);
            this.autoConfigMods = builder.comment("Automatically register crops.").define("autoConfigMods", true);
            this.xpFromHarvestChance = builder.comment("Chance of XP dropping on harvest.").defineInRange("xpFromHarvestChance", 100, 0, 100);
            this.xpFromHarvestAmount = builder.comment("Amount of XP dropped on harvest.").defineInRange("xpFromHarvestAmount", 1, 0, 10);
            this.xpFromHarvestUseRange = builder.comment("Use range for XP drop, instead of set amount.").define("xpFromHarvestUseRange", false);
            this.xpFromHarvestRangeAmount = builder.comment("Range of XP dropped on harvest. Format: \"min-max\", example: \"0-3\"").define("xpFromHarvestRangeAmount", (Object)"0-3", xpRangeValidator);
            this.harvestableCrops = builder.comment(new String[]{"Harvestable crops.", "Format: \"harvestState[,afterHarvest]\", i.e. \"minecraft:wheat[age=7]\"", "or \"minecraft:cocoa[age=2,facing=north],minecraft:cocoa[age=0,facing=north]\"", "WARNING: If autoConfigMods is set to false, only crops defined here will work.", "If not, it will just add to the auto-configured list."}).defineListAllowEmpty(harvestableCropsList, Common.getCropsList(), s -> s instanceof String);
            this.harvestableBlocks = builder.comment(new String[]{"Blocks that right clicking should simulate click instead of breaking.", "For blocks like berry bushes that have built-in right click harvest."}).defineListAllowEmpty(harvestableBlocksList, Common.getHarvestableBlocksList(), resourceLocationValidator);
            this.expandHoeRange = builder.comment("Expand hoe range based on tier.").define("expandHoeRange", true);
            this.smallTierExpansionRange = builder.comment("Regular hoe (gold, wood, iron) expansion range.").defineInRange("smallTierExpansionRange", 2, 1, 5);
            this.highTierExpansionRange = builder.comment("Regular hoe (gold, wood, iron) expansion range.").defineInRange("highTierExpansionRange", 3, 1, 5);
            this.expandHoeRangeEnchanted = builder.comment("Expand hoe range by 1 for each level of efficiency enchantment level.").define("expandHoeRangeEnchanted", true);
            this.maxHoeExpansionRange = builder.comment(new String[]{"Maximum range hoe can expand for harvesting.", "This is the maximum of tier + efficiency enchantment."}).defineInRange("maxHoeExpansionRange", 11, 1, 11);
            this.hoeItems = builder.comment(new String[]{"List of individual hoe tools and their harvest tier. This is for modded items not covered.", "Format: minecraft:wooden_hoe-0 (with number being tier)"}).defineListAllowEmpty(hoeItemList, Common.getHoeItems(), hoeItemValidator);
            this.blacklistCrops = builder.comment("List of crops to blacklist from right-click harvest. Format: \"modid:block\"").defineListAllowEmpty(blacklistCropsList, Common.getBlacklistCrops(), resourceLocationValidator);
            this.blacklistMods = builder.comment("List of mods to blacklist from right-click harvest. Format: \"modid\"").defineListAllowEmpty(blacklistModsList, Common.getBlacklistMods(), modidValidator);
            this.allowFakePlayer = builder.comment("Allow machines, like Create's deployer, to harvest crops.").define("allowFakePlayer", true);
            this.blacklistHeldItems = builder.comment("List of held items to blacklist from right-click harvest. Format: \"modid:item\"").defineListAllowEmpty(blacklistHeldItemsList, Common.getBlacklistHeldItems(), resourceLocationValidator);
        }

        public static boolean allowEmptyHand() {
            return (Boolean)ConfigHandler.COMMON.allowEmptyHand.get();
        }

        public static boolean damageTool() {
            return (Boolean)ConfigHandler.COMMON.damageTool.get();
        }

        public static boolean autoConfigMods() {
            return (Boolean)ConfigHandler.COMMON.autoConfigMods.get();
        }

        public static int xpFromHarvestChance() {
            return (Integer)ConfigHandler.COMMON.xpFromHarvestChance.get();
        }

        public static int xpFromHarvestAmount() {
            return (Integer)ConfigHandler.COMMON.xpFromHarvestAmount.get();
        }

        public static boolean xpFromHarvestUseRange() {
            return (Boolean)ConfigHandler.COMMON.xpFromHarvestUseRange.get();
        }

        public static Pair<Integer, Integer> xpFromHarvestRangeAmount() {
            int right;
            String[] amounts = ((String)ConfigHandler.COMMON.xpFromHarvestRangeAmount.get()).split("-");
            int left = Integer.parseInt(amounts[0]);
            if (left > (right = Integer.parseInt(amounts[1]))) {
                return Pair.of((Object)0, (Object)3);
            }
            return Pair.of((Object)left, (Object)right);
        }

        public static Set<Block> getRightClickBlocks() {
            return rightClickBlocks;
        }

        public static Map<BlockState, BlockState> getCrops() {
            return crops;
        }

        public static boolean expandHoeRange() {
            return (Boolean)ConfigHandler.COMMON.expandHoeRange.get();
        }

        public static int smallTierExpansionRange() {
            return (Integer)ConfigHandler.COMMON.smallTierExpansionRange.get();
        }

        public static int highTierExpansionRange() {
            return (Integer)ConfigHandler.COMMON.highTierExpansionRange.get();
        }

        public static boolean expandHoeRangeEnchanted() {
            return (Boolean)ConfigHandler.COMMON.expandHoeRangeEnchanted.get();
        }

        public static int maxHoeExpansionRange() {
            return (Integer)ConfigHandler.COMMON.maxHoeExpansionRange.get();
        }

        public static Map<Item, Integer> getHoeTools() {
            return hoeTools;
        }

        public static boolean allowFakePlayer() {
            return (Boolean)ConfigHandler.COMMON.allowFakePlayer.get();
        }

        private static Supplier<List<? extends String>> getCropsList() {
            return () -> Arrays.asList(defaultHarvestableCrops);
        }

        private static Supplier<List<? extends String>> getHarvestableBlocksList() {
            return () -> Arrays.asList(defaultHarvestableBlocks);
        }

        private static Supplier<List<? extends String>> getHoeItems() {
            return () -> Arrays.asList(defaultHoeItemList);
        }

        private static Supplier<List<? extends String>> getBlacklistCrops() {
            return () -> Arrays.asList(defaultBlacklistCrops);
        }

        private static Supplier<List<? extends String>> getBlacklistMods() {
            return () -> Arrays.asList(defaultBlacklistMods);
        }

        private static Supplier<List<? extends String>> getBlacklistHeldItems() {
            return () -> Arrays.asList(defaultBlacklistHeldItems);
        }

        private static boolean isBlacklistCrop(Block block) {
            return ((List)ConfigHandler.COMMON.blacklistCrops.get()).contains(BlockHelper.getBlockId(block).toString());
        }

        private static boolean isBlacklistMod(Block block) {
            return ((List)ConfigHandler.COMMON.blacklistMods.get()).contains(BlockHelper.getBlockId(block).m_135827_());
        }

        public static boolean isBlacklistHeldItem(ItemStack stack) {
            return ((List)ConfigHandler.COMMON.blacklistHeldItems.get()).contains(ToolHelper.getItemStackId(stack).toString());
        }
    }
}

