/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.recipe.combiner;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import teamrazor.deepaether.init.DABlocks;
import teamrazor.deepaether.recipe.DABookCategory;
import teamrazor.deepaether.recipe.DARecipeSerializers;
import teamrazor.deepaether.recipe.DARecipeTypes;

public class CombinerRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final String group;
    private final DABookCategory category;
    public final NonNullList<Ingredient> inputItems = NonNullList.m_122779_();
    public final ItemStack output;
    protected final float experience;
    protected final int processingTime;

    public CombinerRecipe(ResourceLocation id, String group, DABookCategory category, List<Ingredient> inputItems, ItemStack output, float experience, int processingTime) {
        this.id = id;
        this.group = group;
        this.inputItems.addAll(inputItems);
        this.output = output;
        this.category = category;
        this.experience = experience;
        this.processingTime = processingTime;
    }

    public ItemStack m_5874_(Container worldlyContainer, RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output;
    }

    public ItemStack getResult() {
        return this.output;
    }

    public String m_6076_() {
        return this.group;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    public DABookCategory daCategory() {
        return this.category;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)DABlocks.COMBINER.get());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)DARecipeTypes.COMBINING.get();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)DARecipeSerializers.COMBINER_RECIPE.get();
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        if (pLevel.m_5776_()) {
            return false;
        }
        return this.testEachSlot(pContainer, (Ingredient)this.inputItems.get(0)) && this.testEachSlot(pContainer, (Ingredient)this.inputItems.get(1)) && this.testEachSlot(pContainer, (Ingredient)this.inputItems.get(2));
    }

    private boolean testEachSlot(Container pContainer, Ingredient ingredient) {
        return ingredient.test(pContainer.m_8020_(0)) ^ ingredient.test(pContainer.m_8020_(1)) ^ ingredient.test(pContainer.m_8020_(2));
    }

    public static class Serializer
    implements RecipeSerializer<CombinerRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public CombinerRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            String group = GsonHelper.m_13851_((JsonObject)pSerializedRecipe, (String)"group", (String)"");
            DABookCategory category = (DABookCategory)DABookCategory.CODEC.m_262792_(GsonHelper.m_13851_((JsonObject)pSerializedRecipe, (String)"category", null), (Enum)DABookCategory.UNKNOWN);
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)3, (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            float experience = GsonHelper.m_13820_((JsonObject)pSerializedRecipe, (String)"experience", (float)0.0f);
            int processingTime = GsonHelper.m_13824_((JsonObject)pSerializedRecipe, (String)"processing_time", (int)200);
            int amplifier = GsonHelper.m_13824_((JsonObject)pSerializedRecipe, (String)"amplifier", (int)0);
            int time = GsonHelper.m_13824_((JsonObject)pSerializedRecipe, (String)"duration", (int)14400);
            String effect = GsonHelper.m_13851_((JsonObject)pSerializedRecipe, (String)"effect", (String)"");
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("amplifier", amplifier);
            tag.m_128405_("time", time);
            tag.m_128359_("effect", effect);
            output.m_41751_(tag);
            return new CombinerRecipe(pRecipeId, group, category, (List<Ingredient>)inputs, output, experience, processingTime);
        }

        @Nullable
        public CombinerRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            DABookCategory daBookCategory = (DABookCategory)buffer.m_130066_(DABookCategory.class);
            NonNullList inputs = NonNullList.m_122780_((int)buffer.readInt(), (Object)Ingredient.f_43901_);
            inputs.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            ItemStack output = buffer.m_130267_();
            float experience = buffer.readFloat();
            int processingTime = buffer.readInt();
            return new CombinerRecipe(pRecipeId, group, daBookCategory, (List<Ingredient>)inputs, output, experience, processingTime);
        }

        public void toNetwork(FriendlyByteBuf buffer, CombinerRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130068_((Enum)recipe.daCategory());
            buffer.writeInt(recipe.inputItems.size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.writeItemStack(recipe.m_8043_(null), false);
            buffer.writeFloat(recipe.getExperience());
            buffer.writeInt(recipe.getProcessingTime());
        }
    }

    public static class Type
    implements RecipeType<CombinerRecipe> {
        public static final Type INSTANCE = new Type();
    }
}

