/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.item.moa_food;

import com.aetherteam.aether.entity.passive.Moa;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class FodderItem
extends Item {
    public FodderItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand interactionHand) {
        if (!(livingEntity instanceof Moa)) {
            return InteractionResult.FAIL;
        }
        if (!player.m_7500_()) {
            itemStack.m_41774_(1);
        }
        if (this.applyMoaEffect(livingEntity, itemStack)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_41472_() {
        return false;
    }

    private boolean applyMoaEffect(LivingEntity livingEntity, ItemStack stack) {
        MobEffectInstance fodder = FodderItem.getMobEffect(stack);
        if (fodder == null) {
            return false;
        }
        if (livingEntity.m_7292_(fodder)) {
            livingEntity.m_9236_().m_245747_(livingEntity.m_20183_(), SoundEvents.f_12321_, SoundSource.AMBIENT, 1.0f, 0.2f, true);
            return true;
        }
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        MobEffectInstance fodder = FodderItem.getMobEffect(stack);
        if (fodder != null) {
            PotionUtils.m_257410_(List.of(fodder), components, (float)1.0f);
        }
        super.m_7373_(stack, level, components, flag);
    }

    @Nullable
    public static MobEffectInstance getMobEffect(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            int amplifier = tag.m_128441_("amplifier") ? tag.m_128451_("amplifier") : 0;
            int time = tag.m_128441_("time") ? tag.m_128451_("time") : 14400;
            if (!tag.m_128441_("effect")) {
                return null;
            }
            String effect = tag.m_128461_("effect");
            MobEffect mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effect));
            if (mobEffect == null) {
                return null;
            }
            return new MobEffectInstance(mobEffect, time, amplifier);
        }
        return null;
    }
}

