/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.fluids;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidType;
import teamrazor.deepaether.fluids.DAFluidTypes;
import teamrazor.deepaether.init.DABlocks;

public class DAFluidInteraction {
    private static final Map<FluidType, List<FluidInteractionRegistry.InteractionInformation>> INTERACTIONS = new HashMap<FluidType, List<FluidInteractionRegistry.InteractionInformation>>();

    public static synchronized void addInteraction(FluidType source, FluidInteractionRegistry.InteractionInformation interaction) {
        INTERACTIONS.computeIfAbsent(source, s -> new ArrayList()).add(interaction);
    }

    public static boolean canInteract(Level level, BlockPos pos) {
        FluidState state = level.m_6425_(pos);
        for (Direction direction : LiquidBlock.f_181233_) {
            BlockPos relativePos = pos.m_121945_(direction.m_122424_());
            List interactions = INTERACTIONS.getOrDefault(state.getFluidType(), Collections.emptyList());
            for (FluidInteractionRegistry.InteractionInformation interaction : interactions) {
                if (!interaction.predicate().test(level, pos, relativePos, state)) continue;
                interaction.interaction().interact(level, pos, relativePos, state);
                return true;
            }
        }
        return false;
    }

    static {
        DAFluidInteraction.addInteraction((FluidType)DAFluidTypes.POISON_FLUID_TYPE.get(), new FluidInteractionRegistry.InteractionInformation((FluidType)ForgeMod.WATER_TYPE.get(), fluidState -> ((Block)DABlocks.AERSMOG.get()).m_49966_()));
        DAFluidInteraction.addInteraction((FluidType)DAFluidTypes.POISON_FLUID_TYPE.get(), new FluidInteractionRegistry.InteractionInformation((FluidType)ForgeMod.LAVA_TYPE.get(), fluidState -> Blocks.f_50723_.m_49966_()));
    }
}

