/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.entity;

import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.passive.AetherAnimal;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;
import teamrazor.deepaether.entity.VenomiteBubble;
import teamrazor.deepaether.entity.goals.FollowPlayerGoal;
import teamrazor.deepaether.init.DAEntities;
import teamrazor.deepaether.init.DASounds;

public class Venomite
extends AetherAnimal
implements NeutralMob,
FlyingAnimal {
    public static final int TICKS_PER_FLAP = Mth.m_14167_((float)1.4959966f);
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Venomite.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(Venomite.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int underWaterTicks;
    private float rollAmount;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    @Nullable
    private UUID persistentAngerTarget;

    public Venomite(EntityType<? extends Animal> type, Level level) {
        super(type, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.f_21364_ = 3;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22280_, (double)0.6f).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 48.0);
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)DAEntities.VENOMITE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50016_));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public float m_5610_(BlockPos state, LevelReader blockState) {
        return blockState.m_8055_(state).m_60795_() ? 10.0f : 0.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new VenomiteAttackGoal((PathfinderMob)this, 1.4f, true));
        this.f_21345_.m_25352_(1, (Goal)new FollowPlayerGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new VenomiteHurtByOtherGoal(this).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new VenomiteBecomeAngryTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        this.m_21678_(compoundTag);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.m_147285_(this.m_9236_(), compoundTag);
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)DASounds.VENOMITE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)DASounds.VENOMITE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)DASounds.VENOMITE_DEATH.get();
    }

    protected void m_7840_(double v, boolean b, BlockState blockState, BlockPos blockPos) {
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigation.m_7008_(true);
        return flyingpathnavigation;
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return !effectInstance.m_19544_().equals(AetherEffects.INEBRIATION.get());
    }

    private boolean getFlag(int flag) {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & flag) != 0;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob ageableMob) {
        return null;
    }

    public boolean m_142039_() {
        return this.m_29443_() && this.f_19797_ % TICKS_PER_FLAP == 0;
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int set) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)set);
    }

    @javax.annotation.Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@javax.annotation.Nullable UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_ * 0.5f;
    }

    private void setFlag(int i, boolean b) {
        if (b) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) | i)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & ~i)));
        }
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        if (!this.m_9236_().f_46443_ && this.m_21224_() && this.f_19796_.m_188499_()) {
            VenomiteBubble bubble = new VenomiteBubble(this.m_9236_());
            bubble.m_20219_(this.m_20318_(0.0f));
            this.m_9236_().m_7967_((Entity)bubble);
        }
        super.m_142687_(removalReason);
    }

    public void m_8119_() {
        super.m_8119_();
        this.updateRollAmount();
    }

    private void updateRollAmount() {
        this.rollAmount = this.isRolling() ? Math.min(1.0f, this.rollAmount + 0.2f) : Math.max(0.0f, this.rollAmount - 0.24f);
    }

    protected void m_8024_() {
        this.underWaterTicks = this.m_20072_() ? ++this.underWaterTicks : 0;
        if (this.underWaterTicks > 20) {
            this.m_6469_(this.m_269291_().m_269063_(), 1.0f);
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), false);
        }
    }

    private boolean isRolling() {
        return this.getFlag(2);
    }

    private void setRolling(boolean p_27930_) {
        this.setFlag(2, p_27930_);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            boolean flag = this.m_21660_() && this.m_5448_() != null && this.m_5448_().m_20280_((Entity)this) < 4.0;
            this.setRolling(flag);
        }
    }

    class VenomiteAttackGoal
    extends MeleeAttackGoal {
        VenomiteAttackGoal(PathfinderMob mob, double v, boolean b) {
            super(mob, v, b);
        }

        public boolean m_8036_() {
            return super.m_8036_() && Venomite.this.m_21660_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && Venomite.this.m_21660_();
        }
    }

    class VenomiteHurtByOtherGoal
    extends HurtByTargetGoal {
        VenomiteHurtByOtherGoal(Venomite venomite) {
            super((PathfinderMob)venomite, new Class[0]);
        }

        public boolean m_8045_() {
            return Venomite.this.m_21660_() && super.m_8045_();
        }

        protected void m_5766_(Mob mob, LivingEntity livingEntity) {
            if (mob instanceof Venomite && this.f_26135_.m_142582_((Entity)livingEntity)) {
                mob.m_6710_(livingEntity);
            }
        }
    }

    static class VenomiteBecomeAngryTargetGoal
    extends NearestAttackableTargetGoal<Player> {
        VenomiteBecomeAngryTargetGoal(Venomite venomite) {
            super((Mob)venomite, Player.class, 10, true, false, arg_0 -> ((Venomite)venomite).m_21674_(arg_0));
        }

        public boolean m_8036_() {
            return this.venomiteCanTarget() && super.m_8036_();
        }

        public boolean m_8045_() {
            boolean flag = this.venomiteCanTarget();
            if (flag && this.f_26135_.m_5448_() != null) {
                return super.m_8045_();
            }
            this.f_26137_ = null;
            return false;
        }

        private boolean venomiteCanTarget() {
            Venomite venomite = (Venomite)this.f_26135_;
            return venomite.m_21660_();
        }
    }
}

