/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.entity;

import com.aetherteam.nitrogen.capability.INBTSynchable;
import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import teamrazor.deepaether.entity.WindCrystal;
import teamrazor.deepaether.init.DAEntities;
import teamrazor.deepaether.init.DASounds;
import teamrazor.deepaether.item.gear.EquipmentUtil;
import teamrazor.deepaether.networking.DeepAetherPlayer;
import top.theillusivec4.curios.api.SlotResult;

public class GentleWind
extends FlyingMob {
    private static final int RIDE_COOLDOWN = 300;
    private int rideCooldownCounter;
    private static final EntityDataAccessor<Integer> DATA_OWNER_ID = SynchedEntityData.m_135353_(GentleWind.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_ON_NECK = SynchedEntityData.m_135353_(GentleWind.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COLOR_0 = SynchedEntityData.m_135353_(GentleWind.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COLOR_1 = SynchedEntityData.m_135353_(GentleWind.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COLOR_2 = SynchedEntityData.m_135353_(GentleWind.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COLOR_3 = SynchedEntityData.m_135353_(GentleWind.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COLOR_4 = SynchedEntityData.m_135353_(GentleWind.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public GentleWind(EntityType<? extends FlyingMob> type, Level level) {
        super(type, level);
        this.f_21342_ = new GentleWindMoveControl(this);
        this.f_21365_ = new GentleWindLookControl(this);
    }

    public GentleWind(Level level, Player owner) {
        this((EntityType<? extends FlyingMob>)((EntityType)DAEntities.GENTLE_WIND.get()), level);
        this.setOwner(owner);
        this.m_146884_(owner.m_20182_());
        this.setEntityAroundNeck();
        level.m_7967_((Entity)this);
    }

    public GentleWind(Level level, Player owner, int[] colors) {
        this(level, owner);
        this.setColors(colors);
    }

    public boolean m_271807_() {
        return false;
    }

    public static AttributeSupplier.Builder m_21552_() {
        return FlyingMob.m_21552_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22279_, 10.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_OWNER_ID, (Object)0);
        this.f_19804_.m_135372_(IS_ON_NECK, (Object)false);
        this.f_19804_.m_135372_(COLOR_0, (Object)-1);
        this.f_19804_.m_135372_(COLOR_1, (Object)-1);
        this.f_19804_.m_135372_(COLOR_2, (Object)-1);
        this.f_19804_.m_135372_(COLOR_3, (Object)-1);
        this.f_19804_.m_135372_(COLOR_4, (Object)-1);
    }

    private void setColors(int[] colors) {
        this.f_19804_.m_135381_(COLOR_0, (Object)colors[0]);
        this.f_19804_.m_135381_(COLOR_1, (Object)colors[1]);
        this.f_19804_.m_135381_(COLOR_2, (Object)colors[2]);
        this.f_19804_.m_135381_(COLOR_3, (Object)colors[3]);
        this.f_19804_.m_135381_(COLOR_4, (Object)colors[4]);
    }

    public int getColor(int id) {
        return GentleWind.opaque(switch (id) {
            case 0 -> (Integer)this.f_19804_.m_135370_(COLOR_0);
            case 1 -> (Integer)this.f_19804_.m_135370_(COLOR_1);
            case 2 -> (Integer)this.f_19804_.m_135370_(COLOR_2);
            case 3 -> (Integer)this.f_19804_.m_135370_(COLOR_3);
            case 4 -> (Integer)this.f_19804_.m_135370_(COLOR_4);
            default -> -1;
        });
    }

    public static int opaque(int color) {
        return color | 0xFF000000;
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(1, (Goal)new GentleWindOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new GentleWindOwnerHurtTargetGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new GentleWindAirChargeGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new WrapAroundPlayerGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new FollowPlayerGoal(this));
    }

    public boolean m_142066_() {
        return false;
    }

    protected void m_6138_() {
    }

    protected boolean m_7341_(Entity vehicle) {
        return false;
    }

    public boolean m_6469_(DamageSource source, float damage) {
        return false;
    }

    @Nullable
    public Player getOwner() {
        return (Player)this.m_9236_().m_6815_(((Integer)this.m_20088_().m_135370_(DATA_OWNER_ID)).intValue());
    }

    @Nullable
    public ServerPlayer getServerOwner() {
        return (ServerPlayer)this.m_9236_().m_6815_(((Integer)this.m_20088_().m_135370_(DATA_OWNER_ID)).intValue());
    }

    public void setOwner(Player entity) {
        this.m_20088_().m_135381_(DATA_OWNER_ID, (Object)entity.m_19879_());
    }

    private void followOwner() {
        Player player = this.getOwner();
        if (player != null) {
            float distance = this.m_20270_((Entity)player);
            if (distance > 50.0f) {
                this.m_146884_(player.m_20182_().m_82520_(0.0, 1.2, 0.0));
            } else if ((double)distance < 5.0) {
                this.f_21342_.m_6849_(player.m_20185_() + this.m_20184_().f_82479_ * 2.0, player.m_20186_() + 2.0, player.m_20189_() + this.m_20184_().f_82481_ * 2.0, 1.0);
            } else {
                this.f_21342_.m_6849_(player.m_20185_(), player.m_20186_() + 2.0, player.m_20189_(), 1.0);
            }
        }
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        TamableAnimal tamableanimal;
        AbstractHorse abstracthorse;
        if (target.m_7306_((Entity)owner)) {
            return false;
        }
        if (target instanceof Creeper || target instanceof Ghast || target instanceof ArmorStand || target instanceof GentleWind) {
            return false;
        }
        if (target instanceof Wolf) {
            Wolf wolf = (Wolf)target;
            return !wolf.m_21824_() || wolf.m_269323_() != owner;
        }
        if (target instanceof Player) {
            Player player1;
            Player player = (Player)target;
            if (owner instanceof Player && !(player1 = (Player)owner).m_7099_(player)) {
                return false;
            }
        }
        if (target instanceof AbstractHorse && (abstracthorse = (AbstractHorse)target).m_30614_()) {
            return false;
        }
        return !(target instanceof TamableAnimal) || !(tamableanimal = (TamableAnimal)target).m_21824_();
    }

    protected void m_8021_() {
    }

    public void m_8119_() {
        if (this.isWrappedAroundNeck() && this.getOwner() != null) {
            this.m_6034_(this.getOwner().m_20185_(), this.getOwner().m_20186_() + 50.0, this.getOwner().m_20189_());
            this.m_21573_().m_26573_();
        }
        ++this.rideCooldownCounter;
        super.m_8119_();
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean isWrappedAroundNeck() {
        return (Boolean)this.f_19804_.m_135370_(IS_ON_NECK);
    }

    public void setEntityAroundNeck() {
        Player owner;
        if (this.isWrappedAroundNeck()) {
            return;
        }
        if (!this.m_9236_().m_5776_() && (owner = this.getOwner()) != null) {
            DeepAetherPlayer.get(owner).ifPresent(aetherPlayer -> aetherPlayer.setSynched(INBTSynchable.Direction.CLIENT, "setFloatyScarfWrappedAroundNeck", true));
        }
        this.f_19804_.m_135381_(IS_ON_NECK, (Object)true);
    }

    public void removeEntityAroundNeck() {
        this.rideCooldownCounter = 0;
        if (!this.isWrappedAroundNeck()) {
            return;
        }
        this.f_19804_.m_135381_(IS_ON_NECK, (Object)false);
        Player owner = this.getOwner();
        if (owner != null) {
            this.m_6034_(owner.m_20185_(), this.getOwner().m_20186_() + 1.2, this.getOwner().m_20189_());
            if (!this.m_9236_().m_5776_()) {
                DeepAetherPlayer.get(owner).ifPresent(aetherPlayer -> aetherPlayer.setSynched(INBTSynchable.Direction.CLIENT, "setFloatyScarfWrappedAroundNeck", false));
            }
        }
    }

    public static class GentleWindMoveControl
    extends MoveControl {
        private float speed = 0.1f;
        private final GentleWind gentleWind;

        public GentleWindMoveControl(GentleWind gentleWind) {
            super((Mob)gentleWind);
            this.gentleWind = gentleWind;
        }

        public void m_8126_() {
            if (this.gentleWind.f_19862_) {
                this.gentleWind.m_146922_(this.gentleWind.m_146908_() + 180.0f);
                this.speed = 0.1f;
            }
            double d0 = this.m_25000_() - this.gentleWind.m_20185_();
            double d1 = this.m_25001_() - this.gentleWind.m_20186_();
            double d2 = this.m_25002_() - this.gentleWind.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            if (Math.abs(d3) > (double)1.0E-5f) {
                double d4 = 1.0 - Math.abs(d1 * (double)0.7f) / d3;
                d3 = Math.sqrt((d0 *= d4) * d0 + (d2 *= d4) * d2);
                double d5 = Math.sqrt(d0 * d0 + d2 * d2 + d1 * d1);
                float f = this.gentleWind.m_146908_();
                float f1 = (float)Mth.m_14136_((double)d2, (double)d0);
                float f2 = Mth.m_14177_((float)(this.gentleWind.m_146908_() + 90.0f));
                float f3 = Mth.m_14177_((float)(f1 * 57.295776f));
                this.gentleWind.m_146922_(Mth.m_14148_((float)f2, (float)f3, (float)4.0f) - 90.0f);
                this.gentleWind.f_20883_ = this.gentleWind.m_146908_();
                this.speed = Mth.m_14145_((float)f, (float)this.gentleWind.m_146908_()) < 3.0f ? Mth.m_14121_((float)this.speed, (float)1.8f, (float)(0.005f * (1.8f / this.speed))) : Mth.m_14121_((float)this.speed, (float)0.2f, (float)0.025f);
                float f4 = (float)(-(Mth.m_14136_((double)(-d1), (double)d3) * 180.0 / 3.1415927410125732));
                this.gentleWind.m_146926_(f4);
                float f5 = this.gentleWind.m_146908_() + 90.0f;
                double d6 = (double)(this.speed * Mth.m_14089_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d0 / d5);
                double d7 = (double)(this.speed * Mth.m_14031_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d2 / d5);
                double d8 = (double)(this.speed * Mth.m_14031_((float)(f4 * ((float)Math.PI / 180)))) * Math.abs(d1 / d5);
                Vec3 vec3 = this.gentleWind.m_20184_();
                this.gentleWind.m_20256_(vec3.m_82549_(new Vec3(d6, d8, d7).m_82546_(vec3).m_82490_(0.2)));
            }
        }
    }

    protected static class GentleWindLookControl
    extends LookControl {
        public GentleWindLookControl(GentleWind gentleWind) {
            super((Mob)gentleWind);
        }

        public void m_8128_() {
        }
    }

    public static class GentleWindOwnerHurtByTargetGoal
    extends TargetGoal {
        private final GentleWind gentleWind;
        private LivingEntity ownerLastHurtBy;
        private int timestamp;

        public GentleWindOwnerHurtByTargetGoal(GentleWind gentleWind) {
            super((Mob)gentleWind, false);
            this.gentleWind = gentleWind;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            Player livingentity = this.gentleWind.getOwner();
            if (livingentity == null) {
                return false;
            }
            this.ownerLastHurtBy = livingentity.m_21188_();
            int i = livingentity.m_21213_();
            return i != this.timestamp && this.m_26150_(this.ownerLastHurtBy, TargetingConditions.f_26872_) && this.gentleWind.wantsToAttack(this.ownerLastHurtBy, (LivingEntity)livingentity);
        }

        public void m_8056_() {
            this.gentleWind.removeEntityAroundNeck();
            this.f_26135_.m_6710_(this.ownerLastHurtBy);
            Player livingentity = this.gentleWind.getOwner();
            if (livingentity != null) {
                this.timestamp = livingentity.m_21213_();
            }
            super.m_8056_();
        }
    }

    public static class GentleWindOwnerHurtTargetGoal
    extends TargetGoal {
        private final GentleWind gentleWind;
        private LivingEntity ownerLastHurt;
        private int timestamp;

        public GentleWindOwnerHurtTargetGoal(GentleWind gentleWind) {
            super((Mob)gentleWind, false);
            this.gentleWind = gentleWind;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            Player livingentity = this.gentleWind.getOwner();
            if (livingentity == null) {
                return false;
            }
            this.ownerLastHurt = livingentity.m_21214_();
            int i = livingentity.m_21215_();
            return i != this.timestamp && this.m_26150_(this.ownerLastHurt, TargetingConditions.f_26872_) && this.gentleWind.wantsToAttack(this.ownerLastHurt, (LivingEntity)livingentity);
        }

        public void m_8056_() {
            this.gentleWind.removeEntityAroundNeck();
            this.f_26135_.m_6710_(this.ownerLastHurt);
            Player livingentity = this.gentleWind.getOwner();
            if (livingentity != null) {
                this.timestamp = livingentity.m_21215_();
            }
            super.m_8056_();
        }
    }

    protected static class GentleWindAirChargeGoal
    extends Goal {
        GentleWind gentleWind;
        private int attackTimer = 10;
        private int attackDelay = 10;
        private int numberOfAttacks = 0;

        public GentleWindAirChargeGoal(GentleWind gentleWind) {
            this.gentleWind = gentleWind;
        }

        public boolean m_8036_() {
            if (this.gentleWind.m_5448_() == null || !this.gentleWind.m_5448_().m_6084_() || !this.gentleWind.m_142582_((Entity)this.gentleWind.m_5448_())) {
                return false;
            }
            if (this.attackTimer > 0) {
                --this.attackTimer;
                return false;
            }
            this.attackTimer = 2 + this.gentleWind.m_217043_().m_188503_(10);
            return true;
        }

        public boolean m_8045_() {
            if (this.attackDelay < -2) {
                return false;
            }
            LivingEntity livingentity = this.gentleWind.m_5448_();
            return livingentity != null && livingentity.m_6084_();
        }

        public void m_8056_() {
            this.gentleWind.removeEntityAroundNeck();
            this.attackDelay = 10;
            this.numberOfAttacks = this.gentleWind.f_19796_.m_188503_(3);
            super.m_8056_();
        }

        public void m_8037_() {
            if (this.gentleWind.m_5448_() != null) {
                this.lookAt(this.gentleWind.m_5448_());
                if (this.attackDelay <= 0) {
                    new WindCrystal(this.gentleWind.m_9236_(), (Entity)this.gentleWind, this.gentleWind.m_20154_().m_82542_((double)0.7f, (double)0.7f, (double)0.7f).m_272010_(this.gentleWind.f_19796_, 0.15f), true);
                    this.gentleWind.m_9236_().m_6263_(null, this.gentleWind.m_20185_(), this.gentleWind.m_20186_(), this.gentleWind.m_20189_(), (SoundEvent)DASounds.EOTS_SHOOT.get(), SoundSource.HOSTILE, 1.0f, 2.0f);
                    if (this.numberOfAttacks > 0) {
                        --this.numberOfAttacks;
                        this.attackDelay = 9;
                    } else {
                        this.attackDelay = -3;
                    }
                } else {
                    --this.attackDelay;
                }
            }
        }

        private void lookAt(LivingEntity target) {
            double d0 = target.m_20185_() - this.gentleWind.m_20185_();
            double d1 = target.m_20188_() - this.gentleWind.m_20188_();
            double d2 = target.m_20189_() - this.gentleWind.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            this.gentleWind.m_146926_(Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d1, (double)d3) * 180.0 / 3.1415927410125732)))));
            this.gentleWind.m_146922_(Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 180.0 / 3.1415927410125732) - 90.0f)));
            this.gentleWind.m_5616_(this.gentleWind.m_146908_());
            this.gentleWind.f_19860_ = this.gentleWind.m_146909_();
            this.gentleWind.f_19859_ = this.gentleWind.m_146908_();
        }
    }

    public static class WrapAroundPlayerGoal
    extends Goal {
        private final GentleWind eots;
        private ServerPlayer owner;

        public WrapAroundPlayerGoal(GentleWind eots) {
            this.eots = eots;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8045_() {
            return this.eots.isWrappedAroundNeck() && this.eots.m_5448_() == null;
        }

        public boolean m_8036_() {
            ServerPlayer serverplayer = this.eots.getServerOwner();
            if (serverplayer == null) {
                return false;
            }
            boolean flag = !serverplayer.m_5833_() && !serverplayer.m_20069_() && !serverplayer.f_146808_;
            return flag && !this.eots.isWrappedAroundNeck() && this.eots.rideCooldownCounter > 300 && this.eots.m_5448_() == null;
        }

        public void m_8056_() {
            this.owner = this.eots.getServerOwner();
        }

        public void m_8041_() {
            this.eots.removeEntityAroundNeck();
        }

        public void m_8037_() {
            if (!this.eots.isWrappedAroundNeck() && this.eots.m_20191_().m_82381_(this.owner.m_20191_().m_82377_(1.3, 2.0, 1.3))) {
                this.eots.setEntityAroundNeck();
            }
        }
    }

    public static class FollowPlayerGoal
    extends Goal {
        private final GentleWind eots;

        public FollowPlayerGoal(GentleWind eots) {
            this.eots = eots;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            Player livingentity = this.eots.getOwner();
            if (livingentity == null) {
                this.eots.m_146870_();
                return false;
            }
            Optional<SlotResult> reference = EquipmentUtil.getFloatyScarf((LivingEntity)livingentity);
            if (reference.isEmpty()) {
                this.eots.m_146870_();
                return false;
            }
            CompoundTag scarf = reference.get().stack().m_41783_();
            if (scarf == null || scarf.m_128451_("UUID") != this.eots.m_19879_()) {
                this.eots.m_146870_();
                return false;
            }
            return !this.eots.isWrappedAroundNeck();
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            this.eots.followOwner();
        }
    }
}

